/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.property.IChangeUpperMultiplicityFromPropertyMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.ChangeUpperMultiplicityDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ChangeUpperMultiplicityFromPropertyMigrator
extends AbstractMigrator
implements IChangeUpperMultiplicityFromPropertyMigrator {
    private int newValue;
    private Property property;
    private int oldValue;

    public ChangeUpperMultiplicityFromPropertyMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        EStructuralFeature structuralFeature;
        Element property;
        EObject element;
        if (TreeNodeUtils.isChangeType(treeNode, MigratorProfileApplication.appliedProfile)) {
            Element oldProperty;
            EObject oldElement;
            Element property2;
            EObject element2 = TreeNodeUtils.getChangedElement(treeNode);
            EStructuralFeature structuralFeature2 = TreeNodeUtils.getChangedAttribute(treeNode);
            if (element2 instanceof LiteralUnlimitedNatural && structuralFeature2 == UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value() && (property2 = ((LiteralUnlimitedNatural)element2).getOwner()) instanceof Property && ((Property)property2).getUpperValue() == element2 && (oldElement = TreeNodeUtils.getChangedOldElement(treeNode)) instanceof LiteralUnlimitedNatural && (oldProperty = ((LiteralUnlimitedNatural)oldElement).getOwner()) instanceof Property && ((Property)oldProperty).getUpperValue() == oldElement) {
                return true;
            }
        } else if (TreeNodeUtils.isAddType(treeNode, MigratorProfileApplication.appliedProfile) && (element = TreeNodeUtils.getAddedElement(treeNode)) instanceof LiteralUnlimitedNatural && (property = ((LiteralUnlimitedNatural)element).getOwner()) instanceof Property && (structuralFeature = TreeNodeUtils.getAddedStructuralFeature(treeNode)) == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue() && (!TreeNodeUtils.isAddType(treeNode.getParent(), MigratorProfileApplication.appliedProfile) || !(TreeNodeUtils.getAddedElement(treeNode.getParent()) instanceof Property))) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return ChangeUpperMultiplicityFromPropertyMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        List<StereotypeApplicationDescriptor> list;
        if (this.isDisplayDialogPreference() && (this.newValue < this.oldValue || this.oldValue == -1) && this.newValue != -1 && this.property.getOwner() instanceof Stereotype && !(list = StereotypeApplicationRegistry.getAllStereotypeApplicationDescriptors((Stereotype)this.property.getOwner())).isEmpty()) {
            HashMap mapElementToStereotype = new HashMap();
            for (StereotypeApplicationDescriptor descriptor : list) {
                EStructuralFeature feature;
                Object values;
                EObject stereotypeApplication = descriptor.getOwner().getStereotypeApplication(descriptor.getStereotype());
                if (stereotypeApplication == null || !((values = stereotypeApplication.eGet(feature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)this.property.getName())))) instanceof List) || ((List)values).size() <= this.newValue) continue;
                if (mapElementToStereotype.get(descriptor.getOwner()) == null) {
                    ArrayList<Stereotype> stereotypeList = new ArrayList<Stereotype>();
                    stereotypeList.add(descriptor.getStereotype());
                    mapElementToStereotype.put(descriptor.getOwner(), stereotypeList);
                    continue;
                }
                ((List)mapElementToStereotype.get(descriptor.getOwner())).add(descriptor.getStereotype());
            }
            if (!mapElementToStereotype.isEmpty()) {
                ChangeUpperMultiplicityDialog dialog = new ChangeUpperMultiplicityDialog(Display.getDefault().getActiveShell(), this.property, this.oldValue, this.newValue, mapElementToStereotype);
                dialog.open();
            }
        }
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            if (TreeNodeUtils.isChangeType(this.treeNode, MigratorProfileApplication.appliedProfile)) {
                EObject element = TreeNodeUtils.getChangedElement(this.treeNode);
                this.newValue = ((LiteralUnlimitedNatural)element).getValue();
                this.property = (Property)((LiteralUnlimitedNatural)element).getOwner();
                EObject oldElement = TreeNodeUtils.getChangedOldElement(this.treeNode);
                this.oldValue = ((LiteralUnlimitedNatural)oldElement).getValue();
            } else if (TreeNodeUtils.isAddType(this.treeNode, MigratorProfileApplication.appliedProfile)) {
                EObject element = TreeNodeUtils.getAddedElement(this.treeNode);
                this.newValue = ((LiteralUnlimitedNatural)element).getValue();
                this.oldValue = 1;
                this.property = (Property)((LiteralUnlimitedNatural)element).getOwner();
            }
        }
    }

    @Override
    public int getPriority() {
        return 48;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("ChangeUpperMultiplicityOfProperty");
    }

    @Override
    public int getValue() {
        return this.newValue;
    }

    @Override
    public int getOldValue() {
        return this.oldValue;
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public Element getChangedElement() {
        return this.getProperty();
    }

    @Override
    public Object getNewValue() {
        return this.getValue();
    }

    @Override
    public EStructuralFeature getChangedStructuralFeature() {
        return UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
    }
}

