/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker;

import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.AbstractGraphicalEdgeCreationChecker;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DRepresentationElement;

public class DEdgeCreationChecker
extends AbstractGraphicalEdgeCreationChecker {
    private final String edgeMappingType;
    private Consumer<? super EdgeTarget> sourceVerification;
    private Consumer<? super EdgeTarget> targetVerification;

    public DEdgeCreationChecker(Diagram diagram, EObject container, String edgeMappingType) {
        super(diagram, container);
        this.edgeMappingType = edgeMappingType;
    }

    public DEdgeCreationChecker(Diagram diagram, String edgeMappingType) {
        this(diagram, diagram.getElement(), edgeMappingType);
    }

    public void setSourceVerification(Consumer<? super EdgeTarget> sourceVerification) {
        this.sourceVerification = sourceVerification;
    }

    public void setTargetVerification(Consumer<? super EdgeTarget> verification) {
        this.targetVerification = verification;
    }

    @Override
    public void validateRepresentationElement(DRepresentationElement createdElementRepresentation) {
        this.validateEnds(createdElementRepresentation);
        super.validateRepresentationElement(createdElementRepresentation);
    }

    protected void validateEnds(DRepresentationElement view) {
        if (this.sourceVerification != null) {
            this.sourceVerification.accept((EdgeTarget)((DEdge)view).getSourceNode());
        }
        if (this.targetVerification != null) {
            this.targetVerification.accept((EdgeTarget)((DEdge)view).getTargetNode());
        }
    }

    @Override
    protected String getEdgeMappingType() {
        return this.edgeMappingType;
    }
}

