/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.checker;

import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.IGraphicalRepresentationElementChecker;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.semantic.checker.ISemanticRepresentationElementChecker;
import org.eclipse.sirius.viewpoint.DRepresentationElement;

public abstract class SemanticAndGraphicChecker {
    private final ISemanticRepresentationElementChecker semanticChecker;
    private final IGraphicalRepresentationElementChecker graphicalChecker;

    public SemanticAndGraphicChecker(ISemanticRepresentationElementChecker semanticChecker, IGraphicalRepresentationElementChecker graphicalChecker) {
        this.semanticChecker = semanticChecker;
        this.graphicalChecker = graphicalChecker;
    }

    public void validateRepresentationElement(DRepresentationElement createdElementRepresentation) {
        this.semanticChecker.validateRepresentationElement(createdElementRepresentation);
        this.graphicalChecker.validateRepresentationElement(createdElementRepresentation);
    }

    public void validateAfterUndo() {
        this.semanticChecker.validateAfterUndo();
        this.graphicalChecker.validateAfterUndo();
    }

    public void validateAfterRedo() {
        this.semanticChecker.validateAfterRedo();
        this.graphicalChecker.validateAfterRedo();
    }

    public IGraphicalRepresentationElementChecker getGraphicalChecker() {
        return this.graphicalChecker;
    }

    public ISemanticRepresentationElementChecker getSemanticChecker() {
        return this.semanticChecker;
    }
}

