/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentIndexLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.RowGroupExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupMultiRowReorderCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupMultiRowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupRowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupRowReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupRowReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupsCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.UpdateRowGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.config.DefaultRowGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.group.performance.event.RowGroupCollapseEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.painter.RowGroupHeaderGridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TransformedLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.reorder.event.RowReorderEvent;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowGroupHeaderLayer
extends AbstractLayerTransform {
    private static final Logger LOG = LoggerFactory.getLogger(RowGroupHeaderLayer.class);
    private static final String PERSISTENCE_KEY_ROW_GROUPS = ".rowGroups";
    private final List<GroupModel> model;
    private final SizeConfig columnWidthConfig = new SizeConfig(20);
    private boolean calculateWidth = false;
    private boolean showAlwaysGroupNames = false;
    private IUniqueIndexLayer positionLayer;
    private GroupModel.IndexPositionConverter indexPositionConverter;
    private List<ILayer> layerPath;
    private int reorderFromRowPosition;
    private Map<Integer, Boolean> reorderSupportedOnLevel = new HashMap<Integer, Boolean>();
    private CompositeFreezeLayer compositeFreezeLayer;

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, 1, true);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer, int numberOfGroupLevels) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, numberOfGroupLevels, true);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer) {
        this(underlyingHeaderLayer, positionLayer, selectionLayer, 1, true);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer, int numberOfGroupLevels) {
        this(underlyingHeaderLayer, positionLayer, selectionLayer, numberOfGroupLevels, true);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer, int numberOfGroupLevels, boolean useDefaultConfiguration) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, numberOfGroupLevels, useDefaultConfiguration);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, 1, useDefaultConfiguration);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(underlyingHeaderLayer, positionLayer, selectionLayer, 1, useDefaultConfiguration);
    }

    public RowGroupHeaderLayer(ILayer underlyingHeaderLayer, final IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer, int numberOfGroupLevels, boolean useDefaultConfiguration) {
        super(underlyingHeaderLayer);
        this.positionLayer = positionLayer;
        this.indexPositionConverter = new GroupModel.IndexPositionConverter(){

            @Override
            public int convertPositionToIndex(int position) {
                return positionLayer.getRowIndexByPosition(position);
            }

            @Override
            public int convertIndexToPosition(int index) {
                return positionLayer.getRowPositionByIndex(index);
            }
        };
        this.model = new ArrayList<GroupModel>(numberOfGroupLevels);
        int i = 0;
        while (i < numberOfGroupLevels) {
            GroupModel groupModel = new GroupModel();
            groupModel.setIndexPositionConverter(this.indexPositionConverter);
            this.model.add(groupModel);
            this.reorderSupportedOnLevel.put(i, Boolean.TRUE);
            ++i;
        }
        this.layerPath = this.findLayerPath(this, 0);
        this.layerPainter = new RowGroupHeaderGridLineCellLayerPainter(this);
        positionLayer.addLayerListener(new StructuralChangeLayerListener());
        this.registerCommandHandlers(selectionLayer);
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowGroupHeaderLayerConfiguration(false));
        }
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    @Override
    public void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    protected void registerCommandHandlers(SelectionLayer selectionLayer) {
        this.registerCommandHandler(new RowGroupsCommandHandler(this, selectionLayer));
        this.registerCommandHandler(new ConfigureScalingCommandHandler(this.columnWidthConfig, null));
        this.registerCommandHandler(new RowGroupReorderCommandHandler(this));
        this.registerCommandHandler(new RowGroupReorderStartCommandHandler(this));
        this.registerCommandHandler(new RowGroupReorderEndCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupRowReorderCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupRowReorderStartCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupRowReorderEndCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupMultiRowReorderCommandHandler(this));
    }

    public GroupModel getGroupModel() {
        return this.getGroupModel(0);
    }

    public GroupModel getGroupModel(int level) {
        if (level >= this.model.size()) {
            LOG.warn("tried to add a group on a non-existent level");
            return null;
        }
        return this.model.get(level);
    }

    public void addGroupingLevel() {
        GroupModel groupModel = new GroupModel();
        groupModel.setIndexPositionConverter(this.indexPositionConverter);
        this.model.add(groupModel);
        this.reorderSupportedOnLevel.put(this.model.size() - 1, Boolean.TRUE);
    }

    public int getLevelCount() {
        return this.model.size();
    }

    public IUniqueIndexLayer getPositionLayer() {
        return this.positionLayer;
    }

    List<ILayer> findLayerPath(ILayer layer, int rowPosition) {
        if (layer == this.getPositionLayer()) {
            ArrayList<ILayer> result = new ArrayList<ILayer>();
            result.add(layer);
            return result;
        }
        if (this.compositeFreezeLayer == null && layer instanceof CompositeFreezeLayer) {
            this.compositeFreezeLayer = (CompositeFreezeLayer)layer;
        }
        List<ILayer> result = null;
        Collection<ILayer> underlyingLayers = layer.getUnderlyingLayersByRowPosition(rowPosition);
        if (underlyingLayers != null) {
            for (ILayer underlyingLayer : underlyingLayers) {
                if (underlyingLayer == null) continue;
                result = this.findLayerPath(underlyingLayer, rowPosition);
            }
        }
        if (result == null && layer instanceof DimensionallyDependentLayer) {
            result = this.findLayerPath(((DimensionallyDependentLayer)layer).getVerticalLayerDependency(), rowPosition);
        }
        if (result == null && this.underlyingLayer instanceof DimensionallyDependentIndexLayer) {
            result = this.findLayerPath(((DimensionallyDependentIndexLayer)layer).getVerticalLayerDependency(), rowPosition);
        }
        if (result == null && layer instanceof CompositeFreezeLayer) {
            result = this.findLayerPath(((CompositeFreezeLayer)layer).getChildLayerByLayoutCoordinate(1, 1), rowPosition);
        }
        if (result != null) {
            result.add(layer);
        }
        return result;
    }

    protected int convertRowPositionUpwards(int rowPosition) {
        int converted = rowPosition;
        List<ILayer> path = this.layerPath;
        if (path == null) {
            path = this.findLayerPath(this, rowPosition);
        }
        if (path != null) {
            int i = 0;
            while (i < path.size() - 1) {
                ILayer underlying = path.get(i);
                ILayer upper = path.get(i + 1);
                converted = upper.underlyingToLocalRowPosition(underlying, converted);
                ++i;
            }
        }
        return converted;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowGroupExpandCollapseCommand && command.convertToTargetLayer(this.getPositionLayer())) {
            int rowPosition;
            RowGroupExpandCollapseCommand cmd = (RowGroupExpandCollapseCommand)command;
            int columnPosition = cmd.getLocalColumnPosition(this);
            Object[] found = this.findGroupForCoordinates(columnPosition, rowPosition = cmd.getRowPosition());
            if (found != null) {
                GroupModel groupModel = (GroupModel)found[0];
                GroupModel.Group group = (GroupModel.Group)found[1];
                if (group.isCollapsed()) {
                    this.expandGroup(groupModel, group);
                } else {
                    this.collapseGroup(groupModel, group);
                }
            }
            return true;
        }
        if (command instanceof ColumnResizeCommand && command.convertToTargetLayer(this) && ((ColumnResizeCommand)command).getColumnPosition() < this.getColumnCount() - 1) {
            ColumnResizeCommand columnResizeCommand = (ColumnResizeCommand)command;
            int newColumnWidth = columnResizeCommand.downScaleValue() ? this.columnWidthConfig.downScale(columnResizeCommand.getNewColumnWidth()) : columnResizeCommand.getNewColumnWidth();
            this.setColumnWidth(columnResizeCommand.getColumnPosition(), newColumnWidth);
            this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, columnResizeCommand.getColumnPosition()));
            return true;
        }
        if (command instanceof MultiColumnResizeCommand && command.convertToTargetLayer(this)) {
            MultiColumnResizeCommand columnResizeCommand = (MultiColumnResizeCommand)command;
            int[] nArray = columnResizeCommand.getColumnPositionsArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                int newColumnWidth = columnResizeCommand.downScaleValue() ? this.columnWidthConfig.downScale(columnResizeCommand.getColumnWidth(column)) : columnResizeCommand.getColumnWidth(column);
                this.setColumnWidth(column, newColumnWidth);
                this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, column));
                ++n2;
            }
        }
        return super.doCommand(command);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        int level = 0;
        for (GroupModel groupModel : this.model) {
            groupModel.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_GROUPS + "_" + level, properties);
            ++level;
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.expandAllGroups();
        int level = 0;
        for (GroupModel groupModel : this.model) {
            groupModel.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_GROUPS + "_" + level, properties);
            ArrayList<GroupModel.Group> collapsedGroups = new ArrayList<GroupModel.Group>();
            for (GroupModel.Group group : groupModel.getGroups()) {
                if (!group.isCollapsed()) continue;
                collapsedGroups.add(group);
            }
            if (!collapsedGroups.isEmpty()) {
                this.doCommand(new RowGroupCollapseCommand(groupModel, collapsedGroups));
            }
            ++level;
        }
        this.fireLayerEvent(new RowStructuralRefreshEvent(this));
    }

    @Override
    public int getColumnCount() {
        return this.underlyingLayer.getColumnCount() + this.model.size();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.underlyingLayer.getPreferredColumnCount() + this.model.size();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        int columnCount = this.model.size();
        if (columnPosition < columnCount) {
            return columnPosition;
        }
        return this.underlyingLayer.getColumnIndexByPosition(columnPosition - columnCount);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int columnCount = this.model.size();
        if (localColumnPosition < columnCount) {
            return localColumnPosition;
        }
        return localColumnPosition - columnCount;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        int columnCount = this.model.size();
        return underlyingColumnPosition + columnCount;
    }

    private int getGroupingWidth() {
        if (!this.calculateWidth) {
            return this.columnWidthConfig.getAggregateSize(this.model.size());
        }
        int width = 0;
        int i = 0;
        while (i < this.model.size()) {
            GroupModel groupModel = this.model.get(i);
            if (!groupModel.isEmpty()) {
                width += this.columnWidthConfig.getSize(this.getColumnPositionForLevel(i));
            }
            ++i;
        }
        return width;
    }

    @Override
    public int getWidth() {
        return this.getGroupingWidth() + this.underlyingLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.getGroupingWidth() + this.underlyingLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        int columnCount = this.model.size();
        if (columnPosition < columnCount) {
            if (!this.calculateWidth) {
                return this.columnWidthConfig.getSize(columnPosition);
            }
            int level = this.getLevelForColumnPosition(columnPosition);
            return this.getGroupModel(level).isEmpty() ? 0 : this.columnWidthConfig.getSize(columnPosition);
        }
        return this.underlyingLayer.getColumnWidthByPosition(columnPosition - columnCount);
    }

    public void setColumnWidth(int columnWidth) {
        this.setColumnWidth(this.getColumnPositionForLevel(0), columnWidth);
    }

    public void setColumnWidth(int column, int columnWidth) {
        this.columnWidthConfig.setSize(column, columnWidth);
    }

    public int getColumnPositionForLevel(int level) {
        return this.model.size() - level - 1;
    }

    public int getLevelForColumnPosition(int columnPosition) {
        return this.model.size() - columnPosition - 1;
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        int columnCount = this.model.size();
        if (columnPosition < columnCount) {
            return this.columnWidthConfig.isPositionResizable(columnPosition);
        }
        return this.underlyingLayer.isColumnPositionResizable(columnPosition - columnCount);
    }

    public void setColumnPositionResizable(int columnPosition, boolean resizable) {
        this.columnWidthConfig.setPositionResizable(columnPosition, resizable);
    }

    @Override
    public int getColumnPositionByX(int x) {
        int groupWidth = this.getGroupingWidth();
        if (x <= groupWidth) {
            return LayerUtil.getColumnPositionByX(this, x);
        }
        return this.model.size() + this.underlyingLayer.getColumnPositionByX(x - groupWidth);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        int columnCount = this.model.size();
        if (columnPosition < columnCount) {
            if (!this.calculateWidth) {
                return this.columnWidthConfig.getAggregateSize(columnPosition);
            }
            int startX = 0;
            int i = 0;
            while (i < columnPosition) {
                GroupModel groupModel = this.model.get(i);
                if (!groupModel.isEmpty()) {
                    startX += this.columnWidthConfig.getSize(this.getColumnPositionForLevel(i));
                }
                ++i;
            }
            return startX;
        }
        return this.getGroupingWidth() + this.underlyingLayer.getStartXOfColumnPosition(columnPosition - this.model.size());
    }

    @Override
    public ILayerCell getCellByPosition(final int columnPosition, int rowPosition) {
        if (columnPosition < this.model.size()) {
            int level = this.getLevelForColumnPosition(columnPosition);
            GroupModel.Group group = this.getGroupByPosition(level, rowPosition);
            if (group != null) {
                int start = this.compositeFreezeLayer == null ? this.convertRowPositionUpwards(this.getPositionLayer().getRowPositionByIndex(group.getVisibleStartIndex())) : this.compositeFreezeLayer.getRowPositionByIndex(group.getVisibleStartIndex());
                int column = columnPosition;
                int columnSpan = 1;
                while (level < this.model.size() - 1) {
                    GroupModel.Group upperGroup;
                    if ((upperGroup = this.getGroupByPosition(++level, rowPosition)) != null) break;
                    --column;
                    ++columnSpan;
                }
                int rowSpan = this.getRowSpan(group);
                if (this.showAlwaysGroupNames) {
                    if (start < 0) {
                        rowSpan += start;
                        start = 0;
                    }
                    if (start + rowSpan > this.getRowCount()) {
                        rowSpan = this.getRowCount() - start;
                    }
                }
                ILayerCell cell = new LayerCell(this, column, start, columnPosition, rowPosition, columnSpan, rowSpan);
                if (this.compositeFreezeLayer != null) {
                    cell = this.compositeFreezeLayer.modifyRowSpanLayerCell(cell);
                }
                return cell;
            }
            int columnSpan = 2;
            GroupModel.Group subGroup = null;
            while (level > 0) {
                if ((group = this.getGroupByPosition(--level, rowPosition)) == null) {
                    ++columnSpan;
                    continue;
                }
                subGroup = group;
            }
            if (subGroup != null) {
                int start = this.compositeFreezeLayer == null ? this.convertRowPositionUpwards(this.getPositionLayer().getRowPositionByIndex(subGroup.getVisibleStartIndex())) : this.compositeFreezeLayer.getRowPositionByIndex(subGroup.getVisibleStartIndex());
                int rowSpan = this.getRowSpan(subGroup);
                if (this.showAlwaysGroupNames) {
                    if (start < 0) {
                        rowSpan += start;
                        start = 0;
                    }
                    if (start + rowSpan > this.getRowCount()) {
                        rowSpan = this.getRowCount() - start;
                    }
                }
                return new LayerCell(this, columnPosition, start, columnPosition, rowPosition, columnSpan, rowSpan);
            }
            final int span = columnSpan;
            ILayerCell cell = this.underlyingLayer.getCellByPosition(0, rowPosition);
            if (cell != null) {
                cell = new TransformedLayerCell(cell){

                    @Override
                    public ILayer getLayer() {
                        return RowGroupHeaderLayer.this;
                    }

                    @Override
                    public int getColumnSpan() {
                        return span;
                    }

                    @Override
                    public int getColumnPosition() {
                        return columnPosition;
                    }

                    @Override
                    public int getOriginColumnPosition() {
                        return columnPosition;
                    }
                };
            }
            return cell;
        }
        int columnSpan = 1;
        if (columnPosition - 1 < this.model.size()) {
            int level = this.getLevelForColumnPosition(columnPosition - 1);
            GroupModel.Group group = null;
            while (level < this.model.size()) {
                group = this.getGroupByPosition(level, rowPosition);
                if (group != null) break;
                ++columnSpan;
                ++level;
            }
        }
        final int span = columnSpan;
        ILayerCell cell = this.underlyingLayer.getCellByPosition(0, rowPosition);
        if (cell != null) {
            cell = new TransformedLayerCell(cell){

                @Override
                public ILayer getLayer() {
                    return RowGroupHeaderLayer.this;
                }

                @Override
                public int getColumnSpan() {
                    return span;
                }

                @Override
                public int getColumnPosition() {
                    return columnPosition;
                }

                @Override
                public int getOriginColumnPosition() {
                    return columnPosition - (span - 1);
                }
            };
        }
        return cell;
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        Rectangle bounds = super.getBoundsByPosition(columnPosition, rowPosition);
        if (this.compositeFreezeLayer != null && this.compositeFreezeLayer.isFrozen()) {
            ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
            int[] rowBounds = this.compositeFreezeLayer.getRowBounds(rowPosition, cell.getOriginRowPosition(), cell.getOriginRowPosition() + cell.getRowSpan() - 1);
            bounds.y = rowBounds[0];
            bounds.height = rowBounds[1];
        }
        return bounds;
    }

    public GroupModel.Group getGroupByPosition(int rowPosition) {
        return this.getGroupByPosition(0, rowPosition);
    }

    public GroupModel.Group getGroupByPosition(int level, int rowPosition) {
        GroupModel groupModel;
        int posRow = LayerUtil.convertRowPosition(this, rowPosition, this.getPositionLayer());
        if (posRow > -1 && (groupModel = this.getGroupModel(level)) != null) {
            return groupModel.getGroupByPosition(posRow);
        }
        return null;
    }

    protected Object[] findGroupForCoordinates(int columnPosition, int rowPosition) {
        int level = this.getLevelForColumnPosition(columnPosition);
        GroupModel groupModel = null;
        GroupModel.Group group = null;
        while (level >= 0) {
            groupModel = this.getGroupModel(level);
            if (groupModel != null && (group = groupModel.getGroupByPosition(rowPosition)) != null) {
                return new Object[]{groupModel, group};
            }
            --level;
        }
        return null;
    }

    public boolean isPartOfAGroup(int rowPosition) {
        int level = 0;
        while (level < this.model.size()) {
            if (this.isPartOfAGroup(level, rowPosition)) {
                return true;
            }
            ++level;
        }
        return false;
    }

    public boolean isPartOfAGroup(int level, int rowPosition) {
        GroupModel.Group group = this.getGroupByPosition(level, rowPosition);
        return group != null;
    }

    public boolean isPartOfAnUnbreakableGroup(int rowPosition) {
        return this.isPartOfAnUnbreakableGroup(0, rowPosition);
    }

    public boolean isPartOfAnUnbreakableGroup(int level, int rowPosition) {
        GroupModel.Group group = this.getGroupByPosition(level, rowPosition);
        if (group != null) {
            return group.isUnbreakable();
        }
        return false;
    }

    public int getRowSpan(GroupModel.Group group) {
        int sizeOfGroup = group.getVisibleSpan();
        if (group.isCollapsed()) {
            int sizeOfStaticRows = group.getStaticIndexes().length;
            if (sizeOfStaticRows == 0) {
                return 1;
            }
            int staticSize = 0;
            int[] nArray = group.getStaticIndexes();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                if (this.getPositionLayer().getRowPositionByIndex(index) >= 0) {
                    ++staticSize;
                }
                ++n2;
            }
            sizeOfGroup = staticSize;
        }
        return sizeOfGroup;
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        if (columnPosition < this.model.size() && this.isPartOfAGroup(this.getLevelForColumnPosition(columnPosition), rowPosition)) {
            return DisplayMode.NORMAL;
        }
        int columnPos = columnPosition < this.model.size() ? columnPosition : columnPosition - this.model.size();
        return this.underlyingLayer.getDisplayModeByPosition(columnPos, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        GroupModel.Group group;
        int posRow = LayerUtil.convertRowPosition(this, rowPosition, this.getPositionLayer());
        Object[] found = this.findGroupForCoordinates(columnPosition, posRow);
        GroupModel.Group group2 = group = found != null ? (GroupModel.Group)found[1] : null;
        if (columnPosition < this.model.size() && group != null) {
            LabelStack stack = new LabelStack(new String[0]);
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(stack, columnPosition, rowPosition);
            }
            stack.addLabel("ROW_GROUP_HEADER");
            if (group != null && group.isCollapseable()) {
                if (group.isCollapsed()) {
                    stack.addLabelOnTop("GROUP_COLLAPSED");
                } else {
                    stack.addLabelOnTop("GROUP_EXPANDED");
                }
            }
            return stack;
        }
        int columnPos = columnPosition < this.model.size() ? columnPosition : columnPosition - this.model.size();
        return this.underlyingLayer.getConfigLabelsByPosition(columnPos, rowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (columnPosition < this.model.size()) {
            int level = this.getLevelForColumnPosition(columnPosition);
            GroupModel.Group group = this.getGroupByPosition(level, rowPosition);
            while (group == null && level > 0) {
                group = this.getGroupByPosition(--level, rowPosition);
            }
            if (group != null) {
                return group.getName();
            }
        }
        return this.underlyingLayer.getDataValueByPosition(0, rowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        if (x < this.getGroupingWidth()) {
            int i = 0;
            while (i < this.model.size()) {
                if (this.isPartOfAGroup(i, this.getRowPositionByY(y))) {
                    return new LabelStack("ROW_GROUP_HEADER");
                }
                ++i;
            }
        }
        return this.underlyingLayer.getRegionLabelsByXY(x, y - this.getGroupingWidth());
    }

    public GroupModel.Group getGroupByName(String name) {
        return this.getGroupByName(0, name);
    }

    public GroupModel.Group getGroupByName(int level, String name) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            return groupModel.getGroupByName(name);
        }
        return null;
    }

    public void addPositionsToGroup(String groupName, int ... positions) {
        this.addPositionsToGroup(0, groupName, positions);
    }

    public void addPositionsToGroup(int level, String groupName, int ... positions) {
        GroupModel.Group group;
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.getGroupByName(groupName)) != null) {
            this.addPositionsToGroup(group, positions);
        }
    }

    public void addPositionsToGroup(int level, int rowPosition, int ... positions) {
        GroupModel.Group group = this.getGroupByPosition(level, rowPosition);
        if (group != null) {
            this.addPositionsToGroup(group, positions);
        }
    }

    protected void addPositionsToGroup(GroupModel.Group group, int ... positions) {
        this.addPositionsToGroup(0, group, positions);
    }

    protected void addPositionsToGroup(int level, GroupModel.Group group, int ... positions) {
        GroupModel groupModel;
        int[] converted = new int[positions.length];
        int pos = 0;
        while (pos < positions.length) {
            converted[pos] = LayerUtil.convertRowPosition(this, positions[pos], this.getPositionLayer());
            ++pos;
        }
        if (group.isCollapsed()) {
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(this.getGroupModel(level), group));
        }
        if ((groupModel = this.getGroupModel(level)) != null) {
            groupModel.addPositionsToGroup(group, converted);
        }
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this.underlyingLayer));
    }

    public void removePositionsFromGroup(int level, int ... positions) {
        int[] converted = new int[positions.length];
        int pos = 0;
        while (pos < positions.length) {
            converted[pos] = LayerUtil.convertRowPosition(this, positions[pos], this.getPositionLayer());
            ++pos;
        }
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            int i = converted.length - 1;
            while (i >= 0) {
                int pos2 = converted[i];
                GroupModel.Group group = groupModel.getGroupByPosition(pos2);
                if (group.isCollapsed()) {
                    this.getPositionLayer().doCommand(new RowGroupExpandCommand(groupModel, group));
                }
                groupModel.removePositionsFromGroup(group, pos2);
                --i;
            }
        }
        if (this.calculateWidth) {
            this.fireLayerEvent(new ColumnStructuralRefreshEvent(this.underlyingLayer));
        }
    }

    public void addGroup(String groupName, int startIndex, int span) {
        this.addGroup(0, groupName, startIndex, span);
    }

    public void addGroup(int level, String groupName, int startIndex, int span) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.addGroup(groupName, startIndex, span);
        }
    }

    public void removeGroup(String groupName) {
        this.removeGroup(0, groupName);
    }

    public void removeGroup(int level, String groupName) {
        GroupModel.Group group;
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.removeGroup(groupName)) != null && group.isCollapsed()) {
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(this.getGroupModel(level), group));
        }
    }

    public void removeGroup(int rowPosition) {
        this.removeGroup(0, rowPosition);
    }

    public void removeGroup(int level, int rowPosition) {
        GroupModel.Group group;
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.removeGroup(rowPosition)) != null && group.isCollapsed()) {
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(this.getGroupModel(level), group));
        }
    }

    public void removeGroup(GroupModel.Group group) {
        this.removeGroup(0, group);
    }

    public void removeGroup(int level, GroupModel.Group group) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.removeGroup(group);
            if (group != null && group.isCollapsed()) {
                this.getPositionLayer().doCommand(new RowGroupExpandCommand(this.getGroupModel(level), group));
            }
        }
    }

    public void clearAllGroups() {
        for (GroupModel groupModel : this.model) {
            if (!groupModel.isEmpty()) {
                this.getPositionLayer().doCommand(new RowGroupExpandCommand(groupModel, groupModel.getGroups()));
            }
            groupModel.clear();
        }
    }

    public void clearAllGroups(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && !groupModel.isEmpty()) {
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(groupModel, groupModel.getGroups()));
            groupModel.clear();
        }
    }

    public void addStaticRowIndexesToGroup(String groupName, int ... staticIndexes) {
        this.addStaticRowIndexesToGroup(0, groupName, staticIndexes);
    }

    public void addStaticRowIndexesToGroup(int level, String groupName, int ... staticIndexes) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.addStaticIndexesToGroup(groupName, staticIndexes);
        }
    }

    public void addStaticRowIndexesToGroup(int level, int rowPosition, int ... staticIndexes) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.addStaticIndexesToGroup(rowPosition, staticIndexes);
        }
    }

    public void collapseGroup(String groupName) {
        this.collapseGroup(0, groupName);
    }

    public void collapseGroup(int level, String groupName) {
        this.collapseGroup(this.getGroupModel(level), this.getGroupByName(groupName));
    }

    public void collapseGroup(int position) {
        this.collapseGroup(0, position);
    }

    public void collapseGroup(int level, int position) {
        this.collapseGroup(this.getGroupModel(level), this.getGroupByPosition(level, position));
    }

    public void collapseGroup(GroupModel groupModel, GroupModel.Group group) {
        if (groupModel != null && group != null) {
            this.getPositionLayer().doCommand(new RowGroupCollapseCommand(groupModel, group));
        }
    }

    public void collapseAllGroups() {
        for (GroupModel groupModel : this.model) {
            if (groupModel.isEmpty()) continue;
            this.getPositionLayer().doCommand(new RowGroupCollapseCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void collapseAllGroups(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && !groupModel.isEmpty()) {
            this.getPositionLayer().doCommand(new RowGroupCollapseCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void expandGroup(String groupName) {
        this.expandGroup(0, groupName);
    }

    public void expandGroup(int level, String groupName) {
        this.expandGroup(this.getGroupModel(level), this.getGroupByName(groupName));
    }

    public void expandGroup(int position) {
        this.expandGroup(0, position);
    }

    public void expandGroup(int level, int position) {
        this.expandGroup(this.getGroupModel(level), this.getGroupByPosition(level, position));
    }

    public void expandGroup(GroupModel groupModel, GroupModel.Group group) {
        if (groupModel != null && group != null) {
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(groupModel, group));
        }
    }

    public void expandAllGroups() {
        for (GroupModel groupModel : this.model) {
            if (groupModel.isEmpty()) continue;
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void expandAllGroups(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && !groupModel.isEmpty()) {
            this.getPositionLayer().doCommand(new RowGroupExpandCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void setDefaultCollapseable(boolean defaultCollapseable) {
        for (GroupModel groupModel : this.model) {
            groupModel.setDefaultCollapseable(defaultCollapseable);
        }
    }

    public boolean isDefaultCollapseable(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            return groupModel.isDefaultCollapseable();
        }
        return false;
    }

    public void setDefaultCollapseable(int level, boolean defaultCollapseable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setDefaultCollapseable(defaultCollapseable);
        }
    }

    public void setGroupCollapseable(String groupName, boolean collabseable) {
        this.setGroupCollapseable(0, groupName, collabseable);
    }

    public void setGroupCollapseable(int level, String groupName, boolean collabseable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupCollapseable(groupName, collabseable);
        }
    }

    public void setGroupCollapseable(int position, boolean collabseable) {
        this.setGroupCollapseable(0, position, collabseable);
    }

    public void setGroupCollapseable(int level, int position, boolean collabseable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupCollapseable(position, collabseable);
        }
    }

    public void setDefaultUnbreakable(boolean defaultUnbreakable) {
        for (GroupModel groupModel : this.model) {
            groupModel.setDefaultUnbreakable(defaultUnbreakable);
        }
    }

    public boolean isDefaultUnbreakable(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            return groupModel.isDefaultUnbreakable();
        }
        return false;
    }

    public void setDefaultUnbreakable(int level, boolean defaultUnbreakable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setDefaultUnbreakable(defaultUnbreakable);
        }
    }

    public void setGroupUnbreakable(String groupName, boolean unbreakable) {
        this.setGroupUnbreakable(0, groupName, unbreakable);
    }

    public void setGroupUnbreakable(int level, String groupName, boolean unbreakable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupUnbreakable(groupName, unbreakable);
        }
    }

    public void setGroupUnbreakable(int position, boolean unbreakable) {
        this.setGroupUnbreakable(0, position, unbreakable);
    }

    public void setGroupUnbreakable(int level, int position, boolean unbreakable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupUnbreakable(position, unbreakable);
        }
    }

    public boolean isCalculateWidth() {
        return this.calculateWidth;
    }

    public void setCalculateWidth(boolean calculateWidth) {
        boolean changed = calculateWidth ^ this.calculateWidth;
        this.calculateWidth = calculateWidth;
        if (changed) {
            this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
        }
    }

    public boolean isShowAlwaysGroupNames() {
        return this.showAlwaysGroupNames;
    }

    public void setShowAlwaysGroupNames(boolean showAlwaysGroupNames) {
        this.showAlwaysGroupNames = showAlwaysGroupNames;
    }

    public int getReorderFromRowPosition() {
        return this.reorderFromRowPosition;
    }

    public void setReorderFromRowPosition(int fromRowPosition) {
        this.reorderFromRowPosition = fromRowPosition;
    }

    public boolean isReorderSupportedOnLevel(int level) {
        Boolean supported = this.reorderSupportedOnLevel.get(level);
        if (supported != null) {
            return supported;
        }
        return true;
    }

    public void setReorderSupportedOnLevel(int level, boolean supported) {
        if (level < this.model.size()) {
            this.reorderSupportedOnLevel.put(level, supported);
        }
    }

    public boolean reorderRowGroup(int level, int fromRowPosition, int toRowPosition) {
        GroupModel.Group group;
        if (!this.isReorderSupportedOnLevel(level) || !RowGroupUtils.isBetweenTwoGroups(this, level, toRowPosition, toRowPosition < this.getPositionLayer().getRowCount(), PositionUtil.getVerticalMoveDirection(fromRowPosition, toRowPosition))) {
            return true;
        }
        if (level < this.getLevelCount() - 1 && !RowGroupUtils.isReorderValid(this, level + 1, fromRowPosition, toRowPosition, toRowPosition < this.getPositionLayer().getRowCount())) {
            return true;
        }
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.getGroupByPosition(fromRowPosition)) != null) {
            if (group.isCollapsed()) {
                int groupStart = group.getVisibleStartPosition();
                int groupEnd = group.getVisibleStartPosition() + group.getVisibleSpan();
                if (fromRowPosition >= groupStart && fromRowPosition <= groupEnd && toRowPosition == groupStart || toRowPosition == groupEnd) {
                    return true;
                }
            }
            int toPosition = toRowPosition;
            int underlyingTo = this.getPositionLayer().localToUnderlyingRowPosition(toPosition);
            GroupMultiRowReorderCommand command = new GroupMultiRowReorderCommand((ILayer)this.getPositionLayer(), group.getMembers(), underlyingTo);
            GroupModel.Group toBottom = groupModel.getGroupByPosition(toPosition);
            if (toBottom != null) {
                command.setGroupToBottom(toBottom);
            } else {
                GroupModel.Group toTop = groupModel.getGroupByPosition(toPosition - 1);
                if (toTop != null) {
                    command.setGroupToTop(toTop);
                }
            }
            command.setReorderByIndex(true);
            return this.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(command);
        }
        return false;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add("ROW_GROUP_HEADER");
        labels.add("GROUP_COLLAPSED");
        labels.add("GROUP_EXPANDED");
        if (this.getConfigLabelAccumulator() instanceof IConfigLabelProvider) {
            labels.addAll(((IConfigLabelProvider)this.getConfigLabelAccumulator()).getProvidedLabels());
        }
        return labels;
    }

    private final class StructuralChangeLayerListener
    implements ILayerListener {
        private StructuralChangeLayerListener() {
        }

        @Override
        public void handleLayerEvent(ILayerEvent event) {
            block21: {
                Collection<StructuralDiff> rowDiffs;
                block22: {
                    block20: {
                        if (!(event instanceof RowReorderEvent)) break block20;
                        this.updateRowGroupModel((RowReorderEvent)event);
                        break block21;
                    }
                    if (!(event instanceof IStructuralChangeEvent) || !((IStructuralChangeEvent)event).isVerticalStructureChanged()) break block21;
                    IStructuralChangeEvent changeEvent = (IStructuralChangeEvent)event;
                    rowDiffs = changeEvent.getRowDiffs();
                    if (rowDiffs == null || rowDiffs.isEmpty()) break block22;
                    int[] deletedPositions = this.getDeletedPositions(rowDiffs);
                    if (deletedPositions != null) {
                        if (event instanceof RowGroupCollapseEvent || event instanceof RowStructuralChangeEvent && ((RowStructuralChangeEvent)event).getRowIndexes().length > deletedPositions.length) {
                            this.handleDeleteDiffs(new int[0]);
                        } else {
                            this.handleDeleteDiffs(deletedPositions);
                        }
                    }
                    for (StructuralDiff diff : rowDiffs) {
                        if (diff.getDiffType() != StructuralDiff.DiffTypeEnum.ADD) continue;
                        this.updateVisibleStartPositions();
                        for (GroupModel groupModel : RowGroupHeaderLayer.this.model) {
                            HashMap<GroupModel.Group, UpdateRowGroupCollapseCommand> collapseUpdates = new HashMap<GroupModel.Group, UpdateRowGroupCollapseCommand>();
                            int i = diff.getAfterPositionRange().start;
                            while (i < diff.getAfterPositionRange().end) {
                                block25: {
                                    int newStartIndex;
                                    block23: {
                                        GroupModel.Group group;
                                        block24: {
                                            group = groupModel.getGroupByPosition(i);
                                            newStartIndex = RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(i);
                                            if (group == null || group.getVisibleStartPosition() > i) break block23;
                                            if (group.isCollapsed()) break block24;
                                            group.setVisibleSpan(group.getVisibleSpan() + 1);
                                            break block25;
                                        }
                                        UpdateRowGroupCollapseCommand cmd = (UpdateRowGroupCollapseCommand)collapseUpdates.get(group);
                                        if (cmd == null) {
                                            cmd = new UpdateRowGroupCollapseCommand(groupModel, group);
                                            collapseUpdates.put(group, cmd);
                                        }
                                        if (!group.containsStaticIndex(newStartIndex)) {
                                            cmd.addIndexesToShow(newStartIndex);
                                            cmd.addIndexesToHide(RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(i) + 1);
                                        }
                                        if (group.getVisibleSpan() != 0) break block25;
                                        group.setVisibleSpan(1);
                                        break block25;
                                    }
                                    GroupModel.Group topGroup = groupModel.getGroupByPosition(i - 1);
                                    if (topGroup != null && topGroup.getVisibleSpan() < topGroup.getOriginalSpan() && topGroup.hasMember(newStartIndex)) {
                                        if (!topGroup.isCollapsed()) {
                                            topGroup.setVisibleSpan(topGroup.getVisibleSpan() + 1);
                                        } else if (!topGroup.containsStaticIndex(newStartIndex)) {
                                            UpdateRowGroupCollapseCommand cmd = (UpdateRowGroupCollapseCommand)collapseUpdates.get(topGroup);
                                            if (cmd == null) {
                                                cmd = new UpdateRowGroupCollapseCommand(groupModel, topGroup);
                                                collapseUpdates.put(topGroup, cmd);
                                            }
                                            cmd.addIndexesToHide(RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(i));
                                        } else {
                                            topGroup.setVisibleSpan(topGroup.getVisibleSpan() + 1);
                                        }
                                    } else {
                                        GroupModel.Group g = groupModel.getGroupByStaticIndex(newStartIndex);
                                        if (g != null) {
                                            g.setVisibleStartIndex(newStartIndex);
                                            g.setVisibleSpan(g.getVisibleSpan() + 1);
                                            g.updateVisibleStartPosition();
                                        } else {
                                            int e = diff.getAfterPositionRange().end;
                                            while (e > diff.getAfterPositionRange().start) {
                                                g = groupModel.getGroupByPosition(e);
                                                if (g != null && g.hasMember(newStartIndex)) {
                                                    g.setStartIndex(newStartIndex);
                                                    g.setVisibleStartIndex(newStartIndex);
                                                    g.setVisibleSpan(g.getVisibleSpan() + 1);
                                                    g.updateVisibleStartPosition();
                                                    break;
                                                }
                                                --e;
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                            for (UpdateRowGroupCollapseCommand cmd : collapseUpdates.values()) {
                                RowGroupHeaderLayer.this.doCommand(cmd);
                            }
                        }
                    }
                    this.updateVisibleStartPositions();
                    break block21;
                }
                this.performConsistencyCheck(rowDiffs == null);
            }
        }

        private int[] getDeletedPositions(Collection<StructuralDiff> rowDiffs) {
            MutableIntList result = IntLists.mutable.empty();
            boolean deleteDiffFound = false;
            for (StructuralDiff diff : rowDiffs) {
                if (diff.getDiffType() != StructuralDiff.DiffTypeEnum.DELETE) continue;
                deleteDiffFound = true;
                int[] positions = PositionUtil.getPositions(diff.getBeforePositionRange());
                result.addAll(positions);
            }
            if (deleteDiffFound) {
                return result.sortThis().reverseThis().toArray();
            }
            return null;
        }

        private void handleDeleteDiffs(int[] positionList) {
            if (positionList.length > 0) {
                for (GroupModel groupModel : RowGroupHeaderLayer.this.model) {
                    MutableIntList groupPositionList = IntLists.mutable.of(Arrays.copyOf(positionList, positionList.length));
                    while (!groupPositionList.isEmpty()) {
                        int pos = groupPositionList.get(0);
                        GroupModel.Group group = groupModel.getGroupByPosition(pos);
                        if (group != null) {
                            MutableIntList groupPositions = IntLists.mutable.of(group.getVisiblePositions());
                            MutableIntList hiddenGroupPositions = groupPositions.select(arg_0 -> ((MutableIntList)groupPositionList).contains(arg_0));
                            groupPositionList.removeAll((IntIterable)hiddenGroupPositions);
                            groupPositions.removeAll((IntIterable)hiddenGroupPositions);
                            if (groupPositions.size() > 0) {
                                group.setVisibleSpan(groupPositions.size());
                                hiddenGroupPositions.forEach((IntProcedure & Serializable)i -> {
                                    if (group.getVisibleStartPosition() == i) {
                                        group.setVisibleStartIndex(RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(i - groupPositionList.size()));
                                    }
                                });
                                continue;
                            }
                            group.setVisibleStartIndex(-1);
                            group.setVisibleSpan(0);
                            continue;
                        }
                        groupPositionList.remove(pos);
                    }
                }
            } else {
                this.performConsistencyCheck(false);
            }
        }

        private void updateVisibleStartPositions() {
            for (GroupModel groupModel : RowGroupHeaderLayer.this.model) {
                groupModel.updateVisibleStartPositions();
            }
        }

        private void performConsistencyCheck(boolean updateStartIndex) {
            for (GroupModel groupModel : RowGroupHeaderLayer.this.model) {
                groupModel.performConsistencyCheck(updateStartIndex);
            }
        }

        private void updateRowGroupModel(RowReorderEvent reorderEvent) {
            int[] fromRowPositions = PositionUtil.getPositions(reorderEvent.getBeforeFromRowPositionRanges());
            int toRowPosition = reorderEvent.getBeforeToRowPosition();
            boolean reorderToTopEdge = reorderEvent.isReorderToTopEdge();
            int fromRowPosition = toRowPosition;
            if (toRowPosition > fromRowPositions[fromRowPositions.length - 1]) {
                fromRowPosition = fromRowPositions[fromRowPositions.length - 1];
            } else if (toRowPosition < fromRowPositions[fromRowPositions.length - 1]) {
                fromRowPosition = fromRowPositions[0];
            }
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getVerticalMoveDirection(fromRowPosition, toRowPosition);
            if (reorderToTopEdge && toRowPosition > 0 && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection) {
                --toRowPosition;
            }
            if (fromRowPosition == -1 || toRowPosition == -1) {
                LOG.error("Invalid reorder positions, fromPosition: {}, toPosition: {}", (Object)fromRowPosition, (Object)toRowPosition);
                return;
            }
            for (GroupModel groupModel : RowGroupHeaderLayer.this.model) {
                GroupModel.Group toRowGroup = groupModel.getGroupByPosition(toRowPosition);
                GroupModel.Group fromRowGroup = groupModel.getGroupByPosition(fromRowPosition);
                if (fromRowGroup != null && toRowGroup != null && fromRowGroup.equals(toRowGroup)) {
                    if (fromRowPosition == toRowPosition && (!RowGroupUtils.isGroupReordered(fromRowGroup, fromRowPositions) || fromRowGroup.isCollapsed() && fromRowGroup.getMembers().length > 1) && (fromRowGroup.isGroupStart(fromRowPosition) || fromRowGroup.isGroupEnd(fromRowPosition))) {
                        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection) {
                            int[] pos = new int[fromRowPositions.length];
                            int index = 0;
                            int from = fromRowPositions.length - 1;
                            while (from >= 0) {
                                pos[index] = fromRowPositions[from];
                                ++index;
                                --from;
                            }
                            this.removePositionsFromGroup(groupModel, fromRowGroup, pos, reorderEvent.getBeforeFromRowIndexesArray(), fromRowPosition, moveDirection);
                            break;
                        }
                        this.removePositionsFromGroup(groupModel, fromRowGroup, fromRowPositions, reorderEvent.getBeforeFromRowIndexesArray(), fromRowPosition, moveDirection);
                        break;
                    }
                    if (fromRowPosition != toRowPosition && (fromRowGroup.getVisibleStartPosition() == fromRowPositions[0] || toRowGroup.getVisibleStartPosition() == toRowPosition)) {
                        int newStartIndex = RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(fromRowGroup.getVisibleStartPosition());
                        fromRowGroup.setVisibleStartIndex(newStartIndex);
                        if (!fromRowGroup.isCollapsed() || fromRowGroup.containsStaticIndex(fromRowGroup.getStartIndex())) {
                            fromRowGroup.setStartIndex(newStartIndex);
                        }
                    }
                } else if (fromRowGroup == null && toRowGroup != null) {
                    this.addPositionsToGroup(groupModel, toRowGroup, fromRowPositions, reorderEvent.getBeforeFromRowIndexesArray(), toRowPosition, moveDirection);
                } else if (fromRowGroup != null && toRowGroup == null && !RowGroupUtils.isGroupReordered(fromRowGroup, fromRowPositions)) {
                    this.removePositionsFromGroup(groupModel, fromRowGroup, fromRowPositions, reorderEvent.getBeforeFromRowIndexesArray(), fromRowPosition, moveDirection);
                } else if (fromRowGroup == null && toRowGroup == null && fromRowPosition == toRowPosition && fromRowPositions.length == 1) {
                    int adjacentPos = moveDirection == SelectionLayer.MoveDirectionEnum.DOWN ? fromRowPosition + 1 : fromRowPosition - 1;
                    GroupModel.Group adjacentRowGroup = groupModel.getGroupByPosition(adjacentPos);
                    if (adjacentRowGroup != null && !adjacentRowGroup.isUnbreakable()) {
                        this.addPositionsToGroup(groupModel, adjacentRowGroup, fromRowPositions, reorderEvent.getBeforeFromRowIndexesArray(), adjacentRowGroup.isCollapsed() && moveDirection != SelectionLayer.MoveDirectionEnum.DOWN ? toRowPosition : adjacentPos, moveDirection);
                    }
                } else if (!(fromRowGroup == null || toRowGroup == null || fromRowGroup.equals(toRowGroup) || RowGroupUtils.isGroupReordered(fromRowGroup, fromRowPositions) && (fromRowGroup.isCollapsed() || fromRowGroup.getVisiblePositions().length != 1))) {
                    this.removePositionsFromGroup(groupModel, fromRowGroup, fromRowPositions, reorderEvent.getBeforeFromRowIndexesArray(), fromRowPositions[0], moveDirection);
                    this.addPositionsToGroup(groupModel, toRowGroup, fromRowPositions, reorderEvent.getBeforeFromRowIndexesArray(), toRowPosition, moveDirection);
                }
                groupModel.updateVisibleStartPositions();
            }
        }

        private void addPositionsToGroup(GroupModel groupModel, GroupModel.Group group, int[] fromRowPositions, int[] fromRowIndexes, int toPosition, SelectionLayer.MoveDirectionEnum moveDirection) {
            if (!group.isUnbreakable()) {
                group.setOriginalSpan(group.getOriginalSpan() + fromRowPositions.length);
                if (group.isGroupStart(toPosition)) {
                    int newStartIndex;
                    int n = newStartIndex = moveDirection == SelectionLayer.MoveDirectionEnum.DOWN ? RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(group.getVisibleStartPosition() - fromRowPositions.length) : RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(group.getVisibleStartPosition());
                    if (group.getVisibleStartIndex() == group.getStartIndex()) {
                        group.setStartIndex(newStartIndex);
                    }
                    group.setVisibleStartIndex(newStartIndex);
                }
                group.addMembers(fromRowIndexes);
                if (group.isCollapsed()) {
                    UpdateRowGroupCollapseCommand cmd = new UpdateRowGroupCollapseCommand(groupModel, group);
                    if (group.isGroupStart(toPosition)) {
                        cmd.addIndexesToHide(group.getMembers());
                        if (group.getStaticIndexes().length > 0) {
                            group.setVisibleSpan(group.getVisibleSpan() + fromRowPositions.length);
                        }
                        group.updateVisibleStartPosition();
                    } else {
                        cmd.addIndexesToHide(fromRowIndexes);
                        group.setVisibleSpan(group.getVisibleSpan() + fromRowPositions.length);
                    }
                    RowGroupHeaderLayer.this.getPositionLayer().doCommand(cmd);
                } else {
                    group.setVisibleSpan(group.getVisibleSpan() + fromRowPositions.length);
                }
            }
        }

        private void removePositionsFromGroup(GroupModel groupModel, GroupModel.Group group, int[] fromRowPositions, int[] fromRowIndexes, int fromRowPosition, SelectionLayer.MoveDirectionEnum moveDirection) {
            if (!group.isUnbreakable()) {
                boolean collapsed = group.isCollapsed();
                if (collapsed) {
                    int fromRowIndex = RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(fromRowPosition);
                    RowGroupHeaderLayer.this.expandGroup(groupModel, group);
                    fromRowPosition = RowGroupHeaderLayer.this.getPositionLayer().getRowPositionByIndex(fromRowIndex);
                }
                group.setOriginalSpan(group.getOriginalSpan() - fromRowPositions.length);
                group.setVisibleSpan(group.getVisibleSpan() - fromRowPositions.length);
                if (group.isGroupStart(fromRowPosition)) {
                    int newStartIndex = moveDirection == SelectionLayer.MoveDirectionEnum.DOWN ? RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(group.getVisibleStartPosition()) : RowGroupHeaderLayer.this.getPositionLayer().getRowIndexByPosition(group.getVisibleStartPosition() + fromRowPositions.length);
                    group.setStartIndex(newStartIndex);
                    group.setVisibleStartIndex(newStartIndex);
                }
                group.removeMembers(fromRowIndexes);
                group.removeStaticIndexes(fromRowIndexes);
                if (group.getOriginalSpan() > 0) {
                    group.updateVisibleStartPosition();
                    if (collapsed) {
                        RowGroupHeaderLayer.this.collapseGroup(groupModel, group);
                    }
                } else {
                    groupModel.removeGroup(group);
                }
            }
        }
    }
}

