/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.hyperlink.commands.CreateHyperLinkWebCommand;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkWeb;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperLinkWebShell;
import org.eclipse.swt.widgets.Shell;

public class WebHyperLinkHelper
extends AbstractHyperLinkHelper {
    @Override
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        if (eAnnotation.getSource().equals("PapyrusHyperLink__web")) {
            HyperLinkWeb hyperLinkWeb = new HyperLinkWeb();
            hyperLinkWeb.setHyperLinkWeb((String)eAnnotation.getDetails().get((Object)"link"));
            hyperLinkWeb.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
            if (eAnnotation.getDetails().get((Object)"is_default_navigation") != null) {
                boolean isDefaultNaviagation = Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation"));
                hyperLinkWeb.setIsDefault(isDefaultNaviagation);
            } else {
                hyperLinkWeb.setIsDefault(false);
            }
            return hyperLinkWeb;
        }
        return null;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject HyperLinkObject2) {
        if (HyperLinkObject2 instanceof HyperLinkWeb) {
            HyperLinkWeb hyperLinkWeb = (HyperLinkWeb)HyperLinkObject2;
            return new CreateHyperLinkWebCommand(domain, object, hyperLinkWeb.getTooltipText(), hyperLinkWeb.getHyperLinkWeb(), HyperLinkObject2.getIsDefault());
        }
        return null;
    }

    @Override
    public String getNameofManagedHyperLink() {
        return Messages.WebHyperLinkHelper_Web;
    }

    @Override
    public void executeNewMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject aModel) {
        EditorHyperLinkWebShell editor = new EditorHyperLinkWebShell(parentShell);
        editor.open();
        if (editor.getHyperLinkWeb() != null) {
            list.add(editor.getHyperLinkWeb());
        }
    }

    public ArrayList<HyperLinkObject> getFilteredObject(List<HyperLinkObject> HyperLinkObjects) {
        ArrayList<HyperLinkObject> result = new ArrayList<HyperLinkObject>();
        for (HyperLinkObject HyperLinkObject2 : HyperLinkObjects) {
            if (!(HyperLinkObject2 instanceof HyperLinkWeb)) continue;
            result.add(HyperLinkObject2);
        }
        return result;
    }
}

