/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.launch.proptesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.ros2.launch.lifecycle.LifecycleState;
import org.eclipse.papyrus.robotics.ros2.launch.utils.LaunchUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class LaunchTester
extends PropertyTester {
    public static final String CAN_ACTIVATE = "canActivate";
    public static final String CURRENT_STATE = "currentState";
    public static final String BIN_AVAILABLE = "binAvailable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)receiver;
            if (CURRENT_STATE.equals(property)) {
                return this.checkState(selection, expectedValue);
            }
            if (BIN_AVAILABLE.equals(property)) {
                return this.binaryAvailable(selection);
            }
            if (CAN_ACTIVATE.equals(property)) {
                return this.isLifecycle(selection);
            }
        }
        return false;
    }

    protected boolean checkState(IStructuredSelection selection, Object expectedValue) {
        Property instance;
        EObject prop = EMFHelper.getEObject((Object)selection.getFirstElement());
        String expectedStateStr = (String)expectedValue;
        if (prop instanceof Property && expectedValue instanceof String && StereotypeUtil.isApplied((Element)(instance = (Property)prop), ComponentInstance.class)) {
            LifecycleState.EState currentState = LifecycleState.getState(instance.getName());
            String[] stringArray = expectedStateStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String expectedState = stringArray[n2];
                if (currentState == LifecycleState.getEState(expectedState)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean binaryAvailable(IStructuredSelection selection) {
        Property instance;
        EObject part = EMFHelper.getEObject((Object)selection.getFirstElement());
        if (part instanceof Property && StereotypeUtil.isApplied((Element)(instance = (Property)part), ComponentInstance.class)) {
            return LaunchUtils.existsExecutable(instance);
        }
        return false;
    }

    protected boolean isLifecycle(IStructuredSelection selection) {
        EObject eObject = EMFHelper.getEObject((Object)selection.getFirstElement());
        if (eObject instanceof Element) {
            Element systemOrpart = (Element)eObject;
            if (StereotypeUtil.isApplied((Element)systemOrpart, System.class)) {
                return true;
            }
            if (StereotypeUtil.isApplied((Element)systemOrpart, ComponentInstance.class)) {
                Property instance = (Property)systemOrpart;
                return InstanceUtils.isLifecycle((Property)instance);
            }
        }
        return true;
    }
}

