/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.profile.robotics.skills;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SkillResultKind implements Enumerator
{
    RUNNING(0, "RUNNING", "RUNNING"),
    SUCCESS(1, "SUCCESS", "SUCCESS"),
    FAILURE(2, "FAILURE", "FAILURE");

    public static final int RUNNING_VALUE = 0;
    public static final int SUCCESS_VALUE = 1;
    public static final int FAILURE_VALUE = 2;
    private static final SkillResultKind[] VALUES_ARRAY;
    public static final List<SkillResultKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SkillResultKind[]{RUNNING, SUCCESS, FAILURE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SkillResultKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SkillResultKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SkillResultKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SkillResultKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SkillResultKind get(int value) {
        switch (value) {
            case 0: {
                return RUNNING;
            }
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return FAILURE;
            }
        }
        return null;
    }

    private SkillResultKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

