/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.utils.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PapyrusEditorUtils {
    protected static final String PAPYRUS_EDITOR_ID = "org.eclipse.papyrus.infra.core.papyrusEditor";

    public static List<IMultiDiagramEditor> resolveActiveOpenPapyrusEditors() {
        ArrayList<IMultiDiagramEditor> editors = new ArrayList<IMultiDiagramEditor>();
        for (IEditorReference editorReference : PapyrusEditorUtils.resolveOpenPapyrusEditors()) {
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart == null) continue;
            editors.add((IMultiDiagramEditor)editorPart);
        }
        return editors;
    }

    public static List<IEditorReference> resolveOpenPapyrusEditors() {
        ArrayList<IEditorReference> editorReferences = new ArrayList<IEditorReference>();
        for (IWorkbenchWindow workbenchWindow : Arrays.asList(PlatformUI.getWorkbench().getWorkbenchWindows())) {
            for (IWorkbenchPage page : Arrays.asList(workbenchWindow.getPages())) {
                for (IEditorReference editorReference : Arrays.asList(page.getEditorReferences())) {
                    if (!editorReference.getId().equals(PAPYRUS_EDITOR_ID)) continue;
                    editorReferences.add(editorReference);
                }
            }
        }
        return editorReferences;
    }

    public static boolean existsOpenPapyrusEditor() {
        return !PapyrusEditorUtils.resolveOpenPapyrusEditors().isEmpty();
    }

    public static ServicesRegistry resolveServiceRegistry() {
        Iterator<IMultiDiagramEditor> editorIterator = PapyrusEditorUtils.resolveActiveOpenPapyrusEditors().iterator();
        if (editorIterator.hasNext()) {
            return editorIterator.next().getServicesRegistry();
        }
        return null;
    }

    public static ModelSet resolveModelSet() {
        ModelSet modelSet = null;
        ServicesRegistry registry = PapyrusEditorUtils.resolveServiceRegistry();
        if (registry != null) {
            try {
                modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return modelSet;
    }

    public static Resource resolveResource(String path) {
        Resource resource = null;
        ModelSet modelSet = PapyrusEditorUtils.resolveModelSet();
        if (modelSet != null) {
            resource = modelSet.getResource(URI.createURI((String)path), true);
        }
        return resource;
    }

    public static IEditorPart getEditor(URI modelDIUri) {
        IEditorPart part = null;
        Iterator<IEditorReference> editorIterator = PapyrusEditorUtils.resolveOpenPapyrusEditors().iterator();
        while (part == null && editorIterator.hasNext()) {
            URI fileInputURI;
            IEditorReference editorReference = editorIterator.next();
            IEditorInput editorInput = null;
            try {
                editorInput = editorReference.getEditorInput();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (!(editorInput instanceof FileEditorInput) || ((FileEditorInput)editorInput).getFile() == null || !(fileInputURI = URI.createPlatformResourceURI((String)((FileEditorInput)editorInput).getFile().getFullPath().toString(), (boolean)true)).equals(modelDIUri)) continue;
            part = editorReference.getEditor(false);
        }
        return part;
    }

    public static boolean isEditorActivated(URI modelDIUri) {
        IEditorPart part = PapyrusEditorUtils.getEditor(modelDIUri);
        return part != null && part.getSite().getPage().getActiveEditor() == part;
    }

    public static boolean activateEditor(URI modelDIUri) {
        final IEditorPart part = PapyrusEditorUtils.getEditor(modelDIUri);
        if (part != null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    part.getSite().getPage().activate((IWorkbenchPart)part);
                }
            });
        }
        return PapyrusEditorUtils.isEditorActivated(modelDIUri);
    }

    public static boolean isProjectOpen(URI modelDIUri) {
        boolean match = false;
        Iterator<IEditorReference> editorIterator = PapyrusEditorUtils.resolveOpenPapyrusEditors().iterator();
        while (!match && editorIterator.hasNext()) {
            IEditorReference editorReference = editorIterator.next();
            IEditorInput editorInput = null;
            try {
                editorInput = editorReference.getEditorInput();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (!(editorInput instanceof FileEditorInput) || ((FileEditorInput)editorInput).getFile() == null) continue;
            URI fileInputURI = URI.createPlatformResourceURI((String)((FileEditorInput)editorInput).getFile().getFullPath().toString(), (boolean)true);
            match = fileInputURI.equals(modelDIUri);
        }
        return match;
    }

    public static boolean openProject(IProject project, URI modelDIUri) {
        final IFile modelFile = project.getFile((IPath)new Path(modelDIUri.lastSegment()));
        if (modelFile.exists()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(modelFile), PapyrusEditorUtils.PAPYRUS_EDITOR_ID);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return PapyrusEditorUtils.isProjectOpen(modelDIUri);
    }
}

