/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.papyrus.moka.ui.MokaUIActivator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PapyrusSimulationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Configure preferences for the Papyrus simulation tool";
    private static final String SERVER_PATH_LABEL = "Server path";
    private static final String SERVER_PORT_LABEL = "Server port";
    private static final String MODEL_VALIDATION_ON_LAUNCH_LABEL = "Run validation on launch";

    public PapyrusSimulationPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore store = MokaUIActivator.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(DESCRIPTION);
    }

    protected void createFieldEditors() {
        FileFieldEditor serverPathEditor = new FileFieldEditor("MQTT_SERVER_PATH", SERVER_PATH_LABEL, this.getFieldEditorParent());
        serverPathEditor.setEmptyStringAllowed(false);
        serverPathEditor.setErrorMessage("Invalid path to the server");
        this.addField((FieldEditor)serverPathEditor);
        IntegerFieldEditor portFieldEditor = new IntegerFieldEditor("MQTT_SERVER_PORT", SERVER_PORT_LABEL, this.getFieldEditorParent());
        portFieldEditor.setValidRange(0, 65536);
        portFieldEditor.setErrorMessage("Invalid port");
        this.addField((FieldEditor)portFieldEditor);
        BooleanFieldEditor validationOnLaunch = new BooleanFieldEditor("MODEL_VALIDATION_ON_LAUNCH", MODEL_VALIDATION_ON_LAUNCH_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)validationOnLaunch);
    }
}

