/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pscs.utils.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.moka.pscs.utils.handlers.Utils;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public abstract class AbstractCompositeUtilsHandler
extends AbstractHandler {
    public boolean isEnabled() {
        Element selectedElement = Utils.getSelection();
        if (selectedElement != null) {
            return selectedElement instanceof Class && !(selectedElement instanceof Behavior);
        }
        return false;
    }

    protected Class getClassFromSelection(ISelection selected) {
        if (selected.isEmpty()) {
            return null;
        }
        IAdaptable adaptableObj = (IAdaptable)((IStructuredSelection)selected).getFirstElement();
        EObject modelObj = (EObject)adaptableObj.getAdapter(EObject.class);
        NamedElement nElem = (NamedElement)modelObj;
        return nElem instanceof Class ? (Class)nElem : null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Class context = null;
        context = this.getClassFromSelection(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (context != null) {
            this.start(context);
        }
        return null;
    }

    public void start(Class myClass) {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)myClass);
        RecordingCommand updateCommand = this.getUpdateCommand(myClass, domain);
        domain.getCommandStack().execute((Command)updateCommand);
    }

    public abstract RecordingCommand getUpdateCommand(Class var1, TransactionalEditingDomain var2);
}

