/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.time.scheduling.de;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.AbstractPushPullStrategy;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.DefaultPushPullStrategy;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.Event;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.actions.CallbackAction;

public class DEScheduler {
    protected double currentTime;
    protected double stopTime = -1.0;
    protected boolean finished = false;
    protected boolean started = false;
    protected List<Event> events = new ArrayList<Event>();
    protected List<CallbackAction> preRunActions = new ArrayList<CallbackAction>();
    protected List<CallbackAction> preStepActions = new ArrayList<CallbackAction>();
    protected List<CallbackAction> postStepActions = new ArrayList<CallbackAction>();
    protected static ThreadLocal<DEScheduler> instance = new ThreadLocal();
    protected AbstractPushPullStrategy pushPullStrategy;

    public static void init(double stopTime) {
        DefaultPushPullStrategy pushPullStrategy = new DefaultPushPullStrategy();
        DEScheduler.init(stopTime, 0.0, pushPullStrategy);
    }

    public static void init(double stopTime, double startTime) {
        DefaultPushPullStrategy pushPullStrategy = new DefaultPushPullStrategy();
        DEScheduler.init(stopTime, startTime, pushPullStrategy);
    }

    public static void init(double stopTime, double startTime, AbstractPushPullStrategy pushPullStrategy) {
        DEScheduler scheduler = new DEScheduler();
        instance.set(scheduler);
        scheduler.stopTime = stopTime;
        scheduler.currentTime = startTime;
        scheduler.started = false;
        scheduler.finished = false;
        scheduler.pushPullStrategy = pushPullStrategy;
        scheduler.pushPullStrategy.setScheduler(scheduler);
    }

    public static void init(double stopTime, AbstractPushPullStrategy pushPullStrategy) {
        DEScheduler.init(stopTime, 0.0, pushPullStrategy);
    }

    public static DEScheduler getInstance() {
        return instance.get();
    }

    public void run() {
        for (CallbackAction a : this.preRunActions) {
            a.execute();
        }
        while (!this.finished) {
            this.step();
        }
    }

    public void step() {
        this.updateTime();
        if (!this.finished) {
            for (CallbackAction a : this.preStepActions) {
                a.execute();
            }
            List<Event> events = this.pullEvents(this.currentTime);
            for (Event e : events) {
                e.getAction().execute();
            }
            for (CallbackAction a : this.postStepActions) {
                a.execute();
            }
        }
    }

    public void updateTime() {
        if (this.events.isEmpty()) {
            this.finished = true;
        } else {
            this.currentTime = this.events.get(0).getAbsoluteDate();
        }
        if (this.stopTime != -1.0 && this.currentTime >= this.stopTime) {
            this.finished = true;
        }
    }

    public List<Event> pullEvents(double date) {
        List<Event> selectedEvents = this.pushPullStrategy.pullEvents(date);
        return selectedEvents;
    }

    public void pushEvent(Event event) {
        this.pushPullStrategy.pushEvent(event);
    }

    public void pushEvent(Event event, double absoluteDate) {
        if (this.currentTime <= absoluteDate) {
            this.pushPullStrategy.pushEvent(event, absoluteDate);
        }
    }

    public void pushPreRunAction(CallbackAction action) {
        this.preRunActions.add(action);
    }

    public void pushPreStepAction(CallbackAction action) {
        this.preStepActions.add(action);
    }

    public void pushPostStepAction(CallbackAction action) {
        this.postStepActions.add(action);
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void removeAllEvents(List<Event> selectedEvents) {
        this.events.removeAll(selectedEvents);
    }

    public void addEventAt(int insertAt, Event event) {
        this.events.add(insertAt, event);
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }
}

