/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.util;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class Debug {
    private static final String CLASS_NAME = ClientComms.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final String separator = "==============";
    private static final String lineSep = System.getProperty("line.separator", "\n");
    private String clientID;
    private ClientComms comms;

    public Debug(String clientID, ClientComms comms) {
        this.clientID = clientID;
        this.comms = comms;
        log.setResourceName(clientID);
    }

    public void dumpClientDebug() {
        this.dumpClientComms();
        this.dumpConOptions();
        this.dumpClientState();
        this.dumpBaseDebug();
    }

    public void dumpBaseDebug() {
        this.dumpVersion();
        this.dumpSystemProperties();
        this.dumpMemoryTrace();
    }

    protected void dumpMemoryTrace() {
        log.dumpTrace();
    }

    protected void dumpVersion() {
        StringBuffer vInfo = new StringBuffer();
        vInfo.append(String.valueOf(lineSep) + separator + " Version Info " + separator + lineSep);
        vInfo.append(String.valueOf(Debug.left("Version", 20, ' ')) + ":  " + ClientComms.VERSION + lineSep);
        vInfo.append(String.valueOf(Debug.left("Build Level", 20, ' ')) + ":  " + ClientComms.BUILD_LEVEL + lineSep);
        vInfo.append("==========================================" + lineSep);
        log.fine(CLASS_NAME, "dumpVersion", vInfo.toString());
    }

    public void dumpSystemProperties() {
        Properties sysProps = System.getProperties();
        log.fine(CLASS_NAME, "dumpSystemProperties", Debug.dumpProperties(sysProps, "SystemProperties").toString());
    }

    public void dumpClientState() {
        Properties props = null;
        if (this.comms != null && this.comms.getClientState() != null) {
            props = this.comms.getClientState().getDebug();
            log.fine(CLASS_NAME, "dumpClientState", Debug.dumpProperties(props, String.valueOf(this.clientID) + " : ClientState").toString());
        }
    }

    public void dumpClientComms() {
        Properties props = null;
        if (this.comms != null) {
            props = this.comms.getDebug();
            log.fine(CLASS_NAME, "dumpClientComms", Debug.dumpProperties(props, String.valueOf(this.clientID) + " : ClientComms").toString());
        }
    }

    public void dumpConOptions() {
        Properties props = null;
        if (this.comms != null) {
            props = this.comms.getConOptions().getDebug();
            log.fine(CLASS_NAME, "dumpConOptions", Debug.dumpProperties(props, String.valueOf(this.clientID) + " : Connect Options").toString());
        }
    }

    public static String dumpProperties(Properties props, String name) {
        StringBuffer propStr = new StringBuffer();
        Enumeration<?> propsE = props.propertyNames();
        propStr.append(String.valueOf(lineSep) + separator + " " + name + " " + separator + lineSep);
        while (propsE.hasMoreElements()) {
            String key = (String)propsE.nextElement();
            propStr.append(String.valueOf(Debug.left(key, 28, ' ')) + ":  " + props.get(key) + lineSep);
        }
        propStr.append("==========================================" + lineSep);
        return propStr.toString();
    }

    public static String left(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        sb.append(s);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        return sb.toString();
    }
}

