/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.python.codegen.transformation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.base.AutoLanguageProjectSupport;
import org.eclipse.papyrus.designer.languages.common.base.TestInfo;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Project;
import org.eclipse.papyrus.designer.languages.python.codegen.Activator;
import org.eclipse.papyrus.designer.languages.python.codegen.Messages;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LocatePythonProject {
    private static final boolean Headless = TestInfo.runsHeadless();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        Project projectStereo;
        Object projectName;
        Package rootPkg = PackageUtil.getRootPackage((Element)pe);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject modelProject = root.getProject((String)(projectName = (projectStereo = (Project)UMLUtil.getStereotypeApplication((Element)rootPkg, Project.class)) != null ? projectStereo.getProjectName() : "org.eclipse.papyrus.pygen." + rootPkg.getName()));
        if (!modelProject.exists()) {
            if (Headless) {
                try {
                    modelProject.create(null);
                }
                catch (CoreException e) {
                    return null;
                }
            }
            if (!createIfMissing) return null;
            if (!LocatePythonProject.openQuestion(Messages.LocatePythonProjectTitle, String.format(Messages.LocatePythonProjectInfo, projectName))) return null;
            boolean bl = true;
            boolean create = bl;
            if (!create) return null;
            try {
                ILangProjectSupport projectSupport = AutoLanguageProjectSupport.getProjectSupport((String)"python");
                modelProject = projectSupport.createProject((String)projectName);
                projectSupport.setSettings(modelProject, projectSupport.initialConfigurationData());
                if (modelProject == null) {
                    return null;
                }
            }
            catch (Exception e) {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                try {
                    modelProject.create((IProgressMonitor)progressMonitor);
                }
                catch (CoreException ce) {
                    Activator.log.error((Throwable)ce);
                }
            }
        }
        if (modelProject.isOpen()) return modelProject;
        try {
            modelProject.open(null);
            return modelProject;
        }
        catch (CoreException e) {
            return null;
        }
    }

    private static boolean openQuestion(final String title, final String message) {
        final boolean[] ret = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ret[0] = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
        return ret[0];
    }
}

