/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.JdtCompilationUnitAnalyzer;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.IProjectExplorerNodeVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ClassifierCatalog;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class ReverseWithJDTParserVisitor
implements IProjectExplorerNodeVisitor {
    protected JdtCompilationUnitAnalyzer javaAnalyser;
    protected ClassifierCatalog classifierCatalog;
    protected List<String> reversedElementQualifiedNames;
    protected List<NamedElement> reversedNamedElement;

    public ReverseWithJDTParserVisitor(Package rootPackage, String generatedPackageName, List<String> searchPaths) {
        this.javaAnalyser = new JdtCompilationUnitAnalyzer(rootPackage, generatedPackageName, searchPaths);
        this.reversedElementQualifiedNames = new ArrayList<String>();
        this.reversedNamedElement = new ArrayList<NamedElement>();
        this.classifierCatalog = this.javaAnalyser.getClassifierCatalog();
    }

    public ReverseWithJDTParserVisitor(Parameters parameters) {
        this(parameters.getUmlRootPackage(), parameters.getPackageName(), parameters.getSearchPaths());
    }

    public List<String> getReversedElementQualifiedNames() {
        return this.reversedElementQualifiedNames;
    }

    public List<NamedElement> getReversedNamedElement() {
        return this.reversedNamedElement;
    }

    protected void addReversedName(String name) {
        this.reversedElementQualifiedNames.add(name);
        Classifier namedElement = this.classifierCatalog.getClassifier(name);
        if (namedElement != null) {
            this.reversedNamedElement.add((NamedElement)namedElement);
        }
    }

    @Override
    public void visitICompilationUnit(ICompilationUnit unit) {
        this.processITypeRoot((ITypeRoot)unit);
    }

    protected void processITypeRoot(ITypeRoot unit) {
        System.out.println(String.format("try to reverseType(%s)", unit.getElementName()));
        try {
            String source = unit.getSource();
            if (source == null) {
                System.err.println(String.format("No source attached to unit '%s'", unit.getElementName()));
                return;
            }
            ASTParser parser = ASTParser.newParser((int)10);
            parser.setSource(source.toCharArray());
            parser.setKind(8);
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            this.javaAnalyser.processCompilationUnit(cu);
            this.addReversedName(unit.findPrimaryType().getFullyQualifiedName('.'));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitIClassFile(IClassFile unit) {
        this.processITypeRoot((ITypeRoot)unit);
    }

    @Override
    public void visitIPackageFragment(IPackageFragment node) {
    }

    @Override
    public void visitIPackageFragmentRoot(IPackageFragmentRoot node) {
    }

    @Override
    public void visitIClasspathContainer(IClasspathContainer node) {
    }

    @Override
    public void visitIProject(IProject node) {
    }

    @Override
    public void visitIJavaProject(IJavaProject node) {
    }

    @Override
    public void postVisit() {
    }

    @Override
    public void preVisit() {
    }

    public static class Parameters {
        protected List<String> searchPaths;
        protected Package umlRootPackage;
        protected String packageName;

        public List<String> getSearchPaths() {
            return this.searchPaths;
        }

        public void setSearchPaths(List<String> searchPaths) {
            this.searchPaths = searchPaths;
        }

        public Package getUmlRootPackage() {
            return this.umlRootPackage;
        }

        public void setUmlRootPackage(Package umlModel) {
            this.umlRootPackage = umlModel;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }
}

