/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.IProjectExplorerNodeVisitor;

public class ProjectExplorerNodeWalkerWithIProgress {
    protected IProjectExplorerNodeVisitor visitor;

    public ProjectExplorerNodeWalkerWithIProgress(IProjectExplorerNodeVisitor visitor) {
        this.visitor = visitor;
    }

    public void visit(List<Object> nodes, IProgressMonitor progressMonitor) {
        this.visitor.preVisit();
        this.doSwitch(nodes, progressMonitor);
        this.visitor.postVisit();
    }

    protected void doSwitch(List<Object> nodes, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)nodes.size());
        for (Object node : nodes) {
            this.doSwitch(node, subMonitor.split(1));
        }
    }

    protected void doSwitch(Object node, SubMonitor subMonitor) {
        if (node instanceof ICompilationUnit) {
            this.visitICompilationUnit((ICompilationUnit)node, subMonitor);
        } else if (node instanceof IClassFile) {
            this.visitIClassFile((IClassFile)node, subMonitor);
        } else if (node instanceof IPackageFragment) {
            this.visitIPackageFragment((IPackageFragment)node, subMonitor);
        } else if (node instanceof IPackageFragmentRoot) {
            this.visitIPackageFragmentRoot((IPackageFragmentRoot)node, subMonitor);
        } else if (node instanceof IJavaProject) {
            this.visitIJavaProject((IJavaProject)node, subMonitor);
        } else if (node instanceof IProject) {
            this.visitIProject((IProject)node, subMonitor);
        } else if (node instanceof IClasspathContainer) {
            this.visitIClasspathContainer((IClasspathContainer)node, subMonitor);
        } else {
            System.err.println("Skip node of type " + String.valueOf(node.getClass()));
        }
    }

    private void visitIClasspathContainer(IClasspathContainer node, SubMonitor subMonitor) {
        this.visitor.visitIClasspathContainer(node);
    }

    private void visitIProject(IProject project, SubMonitor subMonitor) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                this.visitIJavaProject(javaProject, subMonitor);
            } else {
                this.visitor.visitIProject(project);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void visitIJavaProject(IJavaProject node, SubMonitor monitor) {
        monitor.setTaskName(node.getElementName());
        this.visitor.visitIJavaProject(node);
        try {
            IPackageFragmentRoot[] roots = node.getPackageFragmentRoots();
            int remaining = roots.length;
            SubMonitor loopMonitor = monitor;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot child = iPackageFragmentRootArray[n2];
                loopMonitor.setWorkRemaining(remaining--);
                switch (child.getKind()) {
                    case 1: {
                        this.doSwitch(child, loopMonitor.split(1));
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void visitIPackageFragmentRoot(IPackageFragmentRoot node, SubMonitor subMonitor) {
        this.visitor.visitIPackageFragmentRoot(node);
        try {
            IJavaElement[] nodes = node.getChildren();
            int remaining = nodes.length;
            SubMonitor loopMonitor = subMonitor.setWorkRemaining(remaining);
            IJavaElement[] iJavaElementArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.doSwitch(child, loopMonitor.split(1));
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void visitIClassFile(IClassFile node, SubMonitor subMonitor) {
        subMonitor.setTaskName(node.getElementName());
        this.visitor.visitIClassFile(node);
    }

    private void visitIPackageFragment(IPackageFragment node, SubMonitor subMonitor) {
        this.visitor.visitIPackageFragment(node);
        try {
            IJavaElement[] nodes = node.getChildren();
            int remaining = nodes.length;
            SubMonitor loopMonitor = subMonitor.setWorkRemaining(remaining);
            IJavaElement[] iJavaElementArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.doSwitch(child, loopMonitor.split(1));
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void visitICompilationUnit(ICompilationUnit node, SubMonitor subMonitor) {
        subMonitor.setTaskName(node.getElementName());
        this.visitor.visitICompilationUnit(node);
    }
}

