/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.GetOrCreateP1;
import org.eclipse.papyrus.designer.languages.cpp.reverse.GetOrCreateP2;
import org.eclipse.papyrus.designer.languages.cpp.reverse.MethodUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.PropertyUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseData;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.change.CElementChange;
import org.eclipse.papyrus.designer.languages.cpp.reverse.change.ChangeMapStore;
import org.eclipse.papyrus.designer.languages.cpp.reverse.change.CppChangeObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.change.ModelChangeObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.FileWatcher;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.ModelManagement;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ReverseCpp2Uml
extends ReverseData {
    private ConflictResolutionMode conflictResolveMode = ConflictResolutionMode.FROM_CODE;
    public static String C_LangID = "C";
    public static String Cpp_LangID = "C++";
    private String langID = "C++";
    private static final String TEMPLATE_PARAMETER_SIGNATURE_NAME = "template_paremeter_signature";
    public static final String REVERSE_FOLDER = "reversed_models";
    public static final String MODEL_POSTFIX = ".uml";
    private static final Logger LOGGER = Logger.getLogger(ReverseCpp2Uml.class.getName());
    private String path;
    private static long timestamp = 0L;
    private ReverseMode reverseMode = ReverseMode.BATCH;
    private int pass;
    private List<CppChangeObject> changeList = new ArrayList<CppChangeObject>();
    private static List<ModelChangeObject> modelChangeList = new ArrayList<ModelChangeObject>();
    private static final String projectPrefix = "org.eclipse.papyrus.cppgen";

    public static boolean addModelChange(ModelChangeObject change) {
        return modelChangeList.add(change);
    }

    public static void clearModelChange() {
        modelChangeList.clear();
    }

    public ReverseCpp2Uml(ITranslationUnit unit, IProgressMonitor monitor, String langID) {
        this(unit.getCProject(), monitor, langID);
        this.unit = unit;
    }

    public ReverseCpp2Uml(ITranslationUnit unit, IProgressMonitor monitor) {
        this(unit.getCProject(), monitor, Cpp_LangID);
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor, String langID) {
        this(project, monitor, langID, null);
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor) {
        this(project, monitor, Cpp_LangID, null);
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor, String langID, String path) {
        try {
            HashMap _hashMap_3;
            HashMap _hashMap_2;
            HashMap _hashMap_1;
            HashMap _hashMap;
            this.project = project;
            this.monitor = monitor;
            this.langID = langID;
            this.path = path;
            ReverseData.current = this;
            this.index = CCorePlugin.getIndexManager().getIndex(project);
            this.tuToASTtuMap = _hashMap = new HashMap();
            this.includesMap = _hashMap_1 = new HashMap();
            UniqueEList _uniqueEList = new UniqueEList();
            this.containers = _uniqueEList;
            this.map = _hashMap_2 = new HashMap();
            this.analyzeMap = _hashMap_3 = new HashMap();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void reverse() {
        try {
            String projectName = this.unit.getCProject().getElementName();
            BatchReverseFunctionBody iSync = new BatchReverseFunctionBody(this.unit, projectName);
            iSync.run();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSourceFolder(ICContainer container) {
        try {
            ICElement[] _children;
            ICElement[] iCElementArray = _children = container.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (true) {
                boolean _isSourceFolder;
                if (n2 >= n) {
                    return false;
                }
                ICElement child = iCElementArray[n2];
                if (child instanceof ITranslationUnit) {
                    return true;
                }
                if (child instanceof ICContainer && (_isSourceFolder = this.isSourceFolder((ICContainer)child))) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void reverseProject(boolean reset) {
        this.reverseProject(reset, null);
    }

    public void reverseProject(boolean reset, IResource fileOrFolder) {
        try {
            long _divide;
            ModelManagement _modelManagement;
            boolean _lessThan;
            Object[] sourceRoots = null;
            if (fileOrFolder != null) {
                ICElement _findElement = this.project.findElement(fileOrFolder.getFullPath());
                sourceRoots = (ICContainer[])Conversions.unwrapArray(Collections.singleton((ICContainer)_findElement), ICContainer.class);
            } else {
                Functions.Function1 _function = it -> this.isSourceFolder((ICContainer)it);
                sourceRoots = (ICContainer[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.project.getSourceRoots())), (Functions.Function1)_function), ICContainer.class);
            }
            Object[] _converted_sourceRoots = sourceRoots;
            int _size = ((List)Conversions.doWrapArray((Object)_converted_sourceRoots)).size();
            boolean bl = _lessThan = _size < 1;
            if (_lessThan) {
                throw new Exception("No source folder");
            }
            this.containers.clear();
            Object[] _converted_sourceRoots_1 = sourceRoots;
            Functions.Function1 _function_1 = it -> it.getElementName().contains(projectPrefix);
            ICContainer sourceRootGenerated = (ICContainer)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_sourceRoots_1)), (Functions.Function1)_function_1));
            if (sourceRootGenerated != null) {
                Functions.Function1 _function_2 = it -> this.isSourceFolder((ICContainer)it);
                Iterables.addAll((Collection)this.containers, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)sourceRootGenerated.getChildren())), ICContainer.class), (Functions.Function1)_function_2));
            } else {
                CollectionExtensions.addAll((Collection)this.containers, (Object[])sourceRoots);
            }
            this.modelManager = _modelManagement = new ModelManagement();
            String umlFilePath = null;
            if (this.path == null || this.path.equals("")) {
                Object fileName = this.project.getElementName();
                if (fileOrFolder != null) {
                    fileName = String.format("%s-%s", this.project.getElementName(), fileOrFolder.getName());
                }
                Object _fileName = fileName;
                fileName = (String)_fileName + MODEL_POSTFIX;
                umlFilePath = this.modelManager.getPath(this.project.getProject(), REVERSE_FOLDER, (String)fileName);
            } else {
                umlFilePath = this.path;
            }
            this.modelManager.createOrgetModel(this.project.getElementName(), umlFilePath, !reset, reset);
            this.models = this.modelManager.getModels();
            for (Model model : this.models) {
                RoundtripCppUtils.applyProfile(model, "pathmap://PapyrusC_Cpp_PROFILES/C_Cpp.profile.uml");
                RoundtripCppUtils.applyProfile(model, "pathmap://UML_PROFILES/Standard.profile.uml");
                ReverseUtils.setXmlID((NamedElement)model);
            }
            int count = 0;
            for (ICContainer container : this.containers) {
                int _count = count;
                int _countTUs = this.countTUs((IParent)container);
                count = _count + _countTUs;
            }
            this.monitor.beginTask("Reverse source files", count * 2);
            this.pass = 1;
            while (this.pass <= 2) {
                this.includesMap.clear();
                for (ICContainer container_1 : this.containers) {
                    this.reverseProject((IParent)container_1);
                }
                ++this.pass;
            }
            for (Model subModel : this.models) {
                subModel.eResource().save(ModelManagement.getDefaultSaveOptions());
            }
            long _timeStamp = ((Model)IterableExtensions.lastOrNull((Iterable)this.models)).eResource().getTimeStamp();
            timestamp = _divide = _timeStamp / 1000L;
            this.clearRawChangeList();
            this.modelManager.dispose();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void syncIncrementalProject() {
        try {
            ModelManagement _modelManagement;
            boolean _lessThan;
            this.reverseMode = ReverseMode.INCREMENTAL;
            Functions.Function1 _function = it -> this.isSourceFolder((ICContainer)it);
            Iterable sourceRoots = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.project.getSourceRoots())), (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)sourceRoots);
            boolean bl = _lessThan = _size < 1;
            if (_lessThan) {
                throw new Exception("No source folder");
            }
            this.containers.clear();
            Functions.Function1 _function_1 = it -> it.getElementName().contains(projectPrefix);
            ISourceRoot sourceRootGenerated = (ISourceRoot)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)sourceRoots, (Functions.Function1)_function_1));
            if (sourceRootGenerated != null) {
                Functions.Function1 _function_2 = it -> this.isSourceFolder((ICContainer)it);
                Iterables.addAll((Collection)this.containers, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)sourceRootGenerated.getChildren())), ICContainer.class), (Functions.Function1)_function_2));
            } else {
                Iterables.addAll((Collection)this.containers, (Iterable)sourceRoots);
            }
            this.modelManager = _modelManagement = new ModelManagement();
            String umlFilePath = null;
            if (this.path == null || this.path.equals("")) {
                IProject _project = this.project.getProject();
                String _elementName = this.project.getElementName();
                String _plus = _elementName + MODEL_POSTFIX;
                umlFilePath = this.modelManager.getPath(_project, REVERSE_FOLDER, _plus);
            } else {
                umlFilePath = this.path;
            }
            this.modelManager.createOrgetModel(this.project.getElementName(), umlFilePath, false, false);
            this.models = this.modelManager.getModels();
            Consumer<Model> _function_3 = it -> {
                RoundtripCppUtils.applyProfile(it, "pathmap://PapyrusC_Cpp_PROFILES/C_Cpp.profile.uml");
                RoundtripCppUtils.applyProfile(it, "pathmap://UML_PROFILES/Standard.profile.uml");
            };
            this.models.forEach(_function_3);
            if (this.getRawChangeList() == null || this.getRawChangeList().size() == 0) {
                long _divide;
                FileWatcher fileWatcher = new FileWatcher(this.project, timestamp);
                List<ITranslationUnit> modifiedItus = fileWatcher.getModifiledTranslationUnits((IParent)this.project);
                for (ITranslationUnit modified : modifiedItus) {
                    this.syncTranslationUnit(modified);
                }
                this.modelManager.saveModel(IterableExtensions.toList(Collections.singleton(umlFilePath)));
                long _timeStamp = ((Model)IterableExtensions.lastOrNull((Iterable)this.models)).eResource().getTimeStamp();
                timestamp = _divide = _timeStamp / 1000L;
            } else {
                this.reverseIncrementalChanges();
                this.modelManager.saveModel(IterableExtensions.toList(Collections.singleton(umlFilePath)));
            }
            this.modelManager.dispose();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private int countTUs(IParent parent) {
        try {
            int count = 0;
            if (!(parent instanceof ITranslationUnit)) {
                ICElement[] _children;
                ICElement[] iCElementArray = _children = parent.getChildren();
                int n = _children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    if (child instanceof ITranslationUnit) {
                        ++count;
                    } else if (!(child instanceof IBinary) && child instanceof IParent) {
                        int _count = count;
                        int _countTUs = this.countTUs((IParent)child);
                        count = _count + _countTUs;
                    }
                    ++n2;
                }
            }
            return count;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void reverseProject(IParent parent) {
        try {
            ICElement[] _children;
            ICElement[] iCElementArray = _children = parent.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement child = iCElementArray[n2];
                boolean _isCanceled = this.monitor.isCanceled();
                if (_isCanceled) {
                    return;
                }
                if (child instanceof ITranslationUnit) {
                    this.reverseHeader((ITranslationUnit)child);
                } else if (!(child instanceof IBinary) && child instanceof IParent) {
                    this.reverseProject((IParent)child);
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void reverseSource(ITranslationUnit unit) {
        String _elementName = this.project.getElementName();
        Model _correspondingModel = ReverseUtils.getCorrespondingModel(unit);
        BatchReverseFunctionBody sync = new BatchReverseFunctionBody(unit, _elementName, _correspondingModel);
        try {
            sync.run();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void reverseHeader(ITranslationUnit headerUnit) {
        try {
            boolean _not;
            boolean _containsKey = this.includesMap.containsKey(headerUnit.getPath().toString());
            boolean bl = _not = !_containsKey;
            if (_not) {
                this.includesMap.put(headerUnit.getPath().toString(), true);
                this.monitor.subTask(String.format("Pass %d: parsing types in %s", this.pass, headerUnit.getElementName()));
                this.monitor.worked(1);
                if (this.pass == 1) {
                    GetOrCreateP1.getOrCreateClassifiers((IParent)headerUnit);
                } else if (this.pass == 2) {
                    GetOrCreateP2.getOrCreateClassifiers((IParent)headerUnit);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ReverseCpp2Uml currentCpp2Uml() {
        return (ReverseCpp2Uml)ReverseData.current;
    }

    private void syncTranslationUnit(ITranslationUnit itu) {
        try {
            Iterable structures = Iterables.filter(ReverseUtils.getAllIStructures((IParent)itu, false, true, this.project), IStructure.class);
            for (IStructure structure : structures) {
                Type classifier = GetOrCreateP2.getClassifier((ICElement)structure);
                if (!(classifier instanceof Classifier)) continue;
                this.syncIStructureToModel((Classifier)classifier, structure);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object syncIStructureToModel(Classifier classifier, IStructure istructure) {
        try {
            Object _xblockexpression = null;
            List fields = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)istructure.getChildren())), IField.class));
            List attributes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class));
            this.mergeAttributes(classifier, attributes, fields);
            List methods = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)istructure.getChildren())), IMethodDeclaration.class));
            List operations = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Operation.class));
            this.mergeOperations(classifier, operations, methods);
            List declarations = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)istructure.getChildren())), IDeclaration.class));
            List nestedTypes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Type.class));
            _xblockexpression = this.mergeNestedTypes(classifier, nestedTypes, declarations);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void mergeAttributes(Classifier parent, List<Property> attributes, List<IField> fields) {
        try {
            UniqueEList foundFieldList = new UniqueEList();
            UniqueEList notFoundFieldList = new UniqueEList();
            UniqueEList foundAttrList = new UniqueEList();
            UniqueEList notFoundAttrList = new UniqueEList();
            for (IField field : fields) {
                boolean isModelObjectChanged;
                Functions.Function1 _function = it -> it.getName().equals(field.getElementName());
                Property attrFound = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter(attributes, (Functions.Function1)_function));
                if (attrFound == null) {
                    notFoundFieldList.add((Object)field);
                    continue;
                }
                foundAttrList.add((Object)attrFound);
                foundFieldList.add((Object)field);
                Iterator _function_1 = it -> Objects.equals(it.eObject, attrFound);
                ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_1));
                boolean bl = isModelObjectChanged = _head != null;
                if (isModelObjectChanged) {
                    this.syncAttributeWithMode(parent, attrFound, field, this.conflictResolveMode);
                    continue;
                }
                this.syncAttributeWithMode(parent, attrFound, field, ConflictResolutionMode.FROM_CODE);
            }
            for (Property attr : attributes) {
                boolean _not;
                boolean _contains = foundAttrList.contains((Object)attr);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                notFoundAttrList.add((Object)attr);
            }
            Functions.Function1 _function = it -> it.eventType == 3;
            List addChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
            UniqueEList tobeRemovedsInNotFound = new UniqueEList();
            for (Property attr_1 : notFoundAttrList) {
                Functions.Function1 _function_1 = it -> Objects.equals(it.eObject, attr_1);
                ModelChangeObject modelChangeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)addChanges, (Functions.Function1)_function_1));
                if (modelChangeObj == null) continue;
                tobeRemovedsInNotFound.add((Object)attr_1);
            }
            for (Property i : tobeRemovedsInNotFound) {
                notFoundAttrList.remove((Object)i);
            }
            UniqueEList processedFields = new UniqueEList();
            UniqueEList remainingFields = new UniqueEList();
            UniqueEList remainingAttributes = new UniqueEList();
            for (IField notFoundField : notFoundFieldList) {
                boolean _lessThan;
                boolean _not_1;
                boolean _contains_1 = processedFields.contains((Object)notFoundField);
                boolean bl = _not_1 = !_contains_1;
                if (!_not_1) continue;
                Type umlType = ReverseUtils.getUMLType(ASTUtils.getDeclSpecifier((ISourceReference)notFoundField), (ICElement)notFoundField);
                String typeName = ReverseUtils.getCppTypeName(notFoundField.getTypeName());
                Functions.Function1 _function_1 = it -> {
                    try {
                        return ReverseUtils.getCppTypeName(it.getTypeName()).equals(typeName);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                List sameTypeNameFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundFieldList, (Functions.Function1)_function_1));
                Functions.Function1 _function_2 = it -> it.getType().getName().equals(umlType.getName());
                List sameTypeAttrs = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundAttrList, (Functions.Function1)_function_2));
                int i_1 = 0;
                i_1 = 0;
                while (i_1 < sameTypeNameFields.size()) {
                    boolean _greaterEqualsThan;
                    int _size = sameTypeAttrs.size();
                    boolean bl2 = _greaterEqualsThan = i_1 >= _size;
                    if (_greaterEqualsThan) {
                        remainingFields.add((Object)((IField)sameTypeNameFields.get(i_1)));
                    } else {
                        boolean isModelObjectChanged;
                        IField tobeProcessedField = (IField)sameTypeNameFields.get(i_1);
                        Property tobeProcessedAttr = (Property)sameTypeAttrs.get(i_1);
                        Functions.Function1 _function_3 = it -> Objects.equals(it.eObject, tobeProcessedAttr);
                        ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_3));
                        boolean bl3 = isModelObjectChanged = _head != null;
                        if (isModelObjectChanged) {
                            this.syncAttributeWithMode(parent, tobeProcessedAttr, tobeProcessedField, ConflictResolutionMode.FROM_MODEL);
                        } else {
                            this.syncAttributeWithMode(parent, tobeProcessedAttr, tobeProcessedField, ConflictResolutionMode.FROM_CODE);
                        }
                        processedFields.add((Object)tobeProcessedField);
                        notFoundAttrList.remove((Object)tobeProcessedAttr);
                    }
                    ++i_1;
                }
                List _converted_sameTypeAttrs = sameTypeAttrs;
                int _length = ((Object[])Conversions.unwrapArray((Object)_converted_sameTypeAttrs, Object.class)).length;
                boolean bl4 = _lessThan = i_1 < _length;
                if (!_lessThan) continue;
                int j = i_1;
                while (j < ((Object[])Conversions.unwrapArray((Object)sameTypeAttrs, Object.class)).length) {
                    remainingAttributes.add((Object)((Property)sameTypeAttrs.get(j)));
                    ++j;
                }
            }
            for (Property notFoundAttr : notFoundAttrList) {
                boolean _not_2;
                boolean _contains_2 = remainingAttributes.contains((Object)notFoundAttr);
                boolean bl = _not_2 = !_contains_2;
                if (!_not_2) continue;
                remainingAttributes.add((Object)notFoundAttr);
            }
            for (IField remaining : remainingFields) {
                PropertyUtils.createProperty(remaining, parent);
            }
            Functions.Function1 _function_3 = it -> it.eventType == 3 || it.eventType == 1;
            List remainingChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_3));
            for (Property remaining_1 : remainingAttributes) {
                Functions.Function1 _function_4 = it -> Objects.equals(it.eObject, remaining_1);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)remainingChanges, (Functions.Function1)_function_4));
                if (!_isEmpty) continue;
                if (parent instanceof Class) {
                    EList _ownedAttributes = ((Class)parent).getOwnedAttributes();
                    _ownedAttributes.remove((Object)remaining_1);
                    continue;
                }
                if (!(parent instanceof DataType)) continue;
                EList _ownedAttributes_1 = ((DataType)parent).getOwnedAttributes();
                _ownedAttributes_1.remove((Object)remaining_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Boolean syncAttributeWithMode(Classifier parent, Property attribute, IField field, ConflictResolutionMode resolveMode) {
        Boolean _switchResult = null;
        if (resolveMode != null) {
            switch (resolveMode) {
                case FROM_MODEL: {
                    _switchResult = null;
                    break;
                }
                case FROM_CODE: {
                    boolean _xblockexpression = false;
                    Type type = ReverseUtils.getUMLType(ASTUtils.getDeclSpecifier((ISourceReference)field), (ICElement)field);
                    attribute.setType(type);
                    attribute.setName(field.getElementName());
                    PropertyUtils.updateProperty(field, attribute);
                    Functions.Function1 _function = it -> Objects.equals(it.eObject, attribute);
                    ModelChangeObject changeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
                    boolean _xifexpression = false;
                    if (changeObj != null) {
                        _xifexpression = modelChangeList.remove(changeObj);
                    }
                    _xblockexpression = _xifexpression;
                    _switchResult = _xblockexpression;
                    break;
                }
                case UI_INTERACTION: {
                    _switchResult = null;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private Boolean syncOperationWithMode(Classifier parent, Operation op, IMethodDeclaration method, ConflictResolutionMode resolveMode) {
        Boolean _switchResult = null;
        if (resolveMode != null) {
            switch (resolveMode) {
                case FROM_MODEL: {
                    _switchResult = null;
                    break;
                }
                case FROM_CODE: {
                    boolean _xblockexpression = false;
                    op.setName(method.getElementName());
                    MethodUtils.updateMethod((Class)parent, op, method);
                    Functions.Function1 _function = it -> Objects.equals(it.eObject, op);
                    ModelChangeObject changeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
                    boolean _xifexpression = false;
                    if (changeObj != null) {
                        _xifexpression = modelChangeList.remove(changeObj);
                    }
                    _xblockexpression = _xifexpression;
                    _switchResult = _xblockexpression;
                    break;
                }
                case UI_INTERACTION: {
                    _switchResult = null;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private boolean isSameOperation(Operation op, IMethodDeclaration method) {
        boolean ret = true;
        boolean _equals = op.getName().equals(method.getElementName());
        boolean _not = !_equals;
        ret = _not ? false : this.isSameSignature(op, method);
        return ret;
    }

    private boolean isSameSignature(Operation op, IMethodDeclaration method) {
        int _size;
        boolean _notEquals;
        boolean ret = true;
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
        };
        List params = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function));
        int _numberOfParameters = method.getNumberOfParameters();
        boolean bl = _notEquals = _numberOfParameters != (_size = params.size());
        if (_notEquals) {
            ret = false;
        } else {
            int i = 0;
            while (i < method.getNumberOfParameters()) {
                boolean _not;
                boolean _equals = ReverseUtils.getCppTypeName(method.getParameterTypes()[i]).equals(((Parameter)params.get(i)).getType().getName());
                boolean bl2 = _not = !_equals;
                if (_not) {
                    ret = false;
                }
                ++i;
            }
            if (ret) {
                Functions.Function1 _function_1 = it -> {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
                };
                Parameter returnParam = (Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function_1));
                if (returnParam == null) {
                    boolean _not;
                    boolean _equals = ReverseUtils.getCppTypeName(method.getReturnType()).equals("void");
                    boolean bl3 = _not = !_equals;
                    if (_not) {
                        ret = false;
                    }
                } else if (returnParam.getType() != null && !ReverseUtils.getCppTypeName(method.getReturnType()).equals(returnParam.getType().getName())) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private boolean isSameMethodDeclaration(IMethodDeclaration method1, IMethodDeclaration method2) {
        try {
            boolean result = true;
            result = result && method1.getSignature().equals(method2.getSignature());
            result = result && Objects.equals(ASTUtils.convertVisibility(method1.getVisibility()), ASTUtils.convertVisibility(method2.getVisibility()));
            result = result && method1.isStatic() == method2.isStatic();
            result = result && method1.isVirtual() == method2.isVirtual();
            result = result && method1.isVirtual() == method2.isVirtual();
            result = result && method1.isInline() == method2.isInline();
            result = result && method1.isFriend() == method2.isFriend();
            result = result && method1.isVolatile() == method2.isVolatile();
            result = result && method1.isConstructor() == method2.isConstructor();
            result = result && method1.isDestructor() == method2.isDestructor();
            boolean bl = result = result && method1.getReturnType() != null && method2.getReturnType() != null;
            if (method1.getReturnType() != null && method2.getReturnType() != null) {
                result = result && method1.getReturnType().equals(method2.getReturnType());
            }
            boolean bl2 = result = result && method1.getNumberOfParameters() == method2.getNumberOfParameters();
            if (!result) {
                return result;
            }
            try {
                IASTStandardFunctionDeclarator declarator1 = ASTUtils.getDeclarator((ISourceReference)method1);
                IASTStandardFunctionDeclarator declarator2 = ASTUtils.getDeclarator((ISourceReference)method2);
                result = result && declarator1.getRawSignature().equals(declarator2.getRawSignature());
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    return result;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private int getNumberOfSameParameters(Operation op, IMethodDeclaration method) {
        int ret = 0;
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
        };
        List params = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function));
        int i = 0;
        while (i < method.getNumberOfParameters()) {
            boolean _lessEqualsThan;
            int _size = params.size();
            boolean bl = _lessEqualsThan = i <= _size;
            if (_lessEqualsThan && ((Parameter)params.get(i)).getType() != null && ReverseUtils.getCppTypeName(method.getParameterTypes()[i]).equals(((Parameter)params.get(i)).getType().getName())) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    private Operation findMostSameOperation(List<Operation> ops, IMethodDeclaration method) {
        boolean _isEmpty = ops.isEmpty();
        if (_isEmpty) {
            return null;
        }
        Operation ret = (Operation)IterableExtensions.head(ops);
        for (Operation op : ops) {
            int _numberOfSameParameters_1;
            boolean _greaterThan;
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equals(ret, op);
            if (!_notEquals) continue;
            int _numberOfSameParameters = this.getNumberOfSameParameters(op, method);
            boolean bl2 = _greaterThan = _numberOfSameParameters > (_numberOfSameParameters_1 = this.getNumberOfSameParameters(ret, method));
            if (!_greaterThan) continue;
            ret = op;
        }
        return ret;
    }

    private void mergeOperations(Classifier parent, List<Operation> operations, List<IMethodDeclaration> methods) {
        UniqueEList foundMethodList = new UniqueEList();
        UniqueEList notFoundMethodList = new UniqueEList();
        UniqueEList foundOperationList = new UniqueEList();
        UniqueEList notFoundOperationList = new UniqueEList();
        for (IMethodDeclaration method : methods) {
            boolean bl;
            Functions.Function1 _function = it -> this.isSameOperation((Operation)it, method);
            Operation opFound = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter(operations, (Functions.Function1)_function));
            if (opFound == null) {
                notFoundMethodList.add((Object)method);
                continue;
            }
            foundOperationList.add((Object)opFound);
            foundMethodList.add((Object)method);
            Iterator _function_1 = it -> Objects.equals(it.eObject, opFound);
            ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_1));
            boolean bl2 = bl = _head != null;
        }
        for (Operation op : operations) {
            boolean _not;
            boolean _contains = foundOperationList.contains((Object)op);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            notFoundOperationList.add((Object)op);
        }
        Functions.Function1 _function = it -> it.eventType == 3;
        List addChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
        UniqueEList tobeRemovedsInNotFound = new UniqueEList();
        for (Operation op_1 : notFoundOperationList) {
            Functions.Function1 _function_1 = it -> Objects.equals(it.eObject, op_1);
            ModelChangeObject modelChangeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)addChanges, (Functions.Function1)_function_1));
            if (modelChangeObj == null) continue;
            tobeRemovedsInNotFound.add((Object)op_1);
        }
        for (Operation i : tobeRemovedsInNotFound) {
            notFoundOperationList.remove((Object)i);
        }
        UniqueEList processedMethods = new UniqueEList();
        UniqueEList remainingMethods = new UniqueEList();
        UniqueEList remainingOperations = new UniqueEList();
        for (IMethodDeclaration notFoundMethod : notFoundMethodList) {
            boolean isModelObjectChanged_1;
            boolean _greaterThan;
            boolean _not_1;
            boolean _contains_1 = processedMethods.contains((Object)notFoundMethod);
            boolean bl = _not_1 = !_contains_1;
            if (!_not_1) continue;
            String functionName = (String)IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)notFoundMethod.getElementName().split("::"))));
            Functions.Function1 _function_1 = it -> this.isSameSignature((Operation)it, notFoundMethod);
            Operation sameSignatureOperation = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)notFoundOperationList, (Functions.Function1)_function_1));
            if (sameSignatureOperation != null) {
                boolean isModelObjectChanged;
                Functions.Function1 _function_2 = it -> Objects.equals(it.eObject, sameSignatureOperation);
                ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_2));
                boolean bl3 = isModelObjectChanged = _head != null;
                if (isModelObjectChanged) {
                    this.syncOperationWithMode(parent, sameSignatureOperation, notFoundMethod, ConflictResolutionMode.FROM_MODEL);
                } else {
                    this.syncOperationWithMode(parent, sameSignatureOperation, notFoundMethod, ConflictResolutionMode.FROM_CODE);
                }
                notFoundOperationList.remove((Object)sameSignatureOperation);
                processedMethods.add((Object)notFoundMethod);
                continue;
            }
            Functions.Function1 _function_3 = it -> it.getElementName().equals(functionName);
            List sameNameMethods = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundMethodList, (Functions.Function1)_function_3));
            Functions.Function1 _function_4 = it -> it.getName().equals(functionName);
            List sameNameOperations = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundOperationList, (Functions.Function1)_function_4));
            int _size = sameNameOperations.size();
            boolean bl4 = _greaterThan = _size > 0;
            if (_greaterThan) {
                boolean _lessThan;
                int i_1 = 0;
                i_1 = 0;
                while (i_1 < sameNameMethods.size()) {
                    boolean _greaterEqualsThan;
                    int _size_1 = sameNameOperations.size();
                    boolean bl5 = _greaterEqualsThan = i_1 >= _size_1;
                    if (_greaterEqualsThan) {
                        remainingMethods.add((Object)((IMethodDeclaration)sameNameMethods.get(i_1)));
                    } else {
                        boolean isModelObjectChanged_12;
                        IMethodDeclaration tobeProcessedMethod = (IMethodDeclaration)sameNameMethods.get(i_1);
                        Operation tobeProcessedOp = (Operation)sameNameOperations.get(i_1);
                        Functions.Function1 _function_5 = it -> Objects.equals(it.eObject, tobeProcessedOp);
                        ModelChangeObject _head_1 = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_5));
                        boolean bl6 = isModelObjectChanged_12 = _head_1 != null;
                        if (isModelObjectChanged_12) {
                            this.syncOperationWithMode(parent, tobeProcessedOp, tobeProcessedMethod, ConflictResolutionMode.FROM_MODEL);
                        } else {
                            this.syncOperationWithMode(parent, tobeProcessedOp, tobeProcessedMethod, ConflictResolutionMode.FROM_CODE);
                        }
                        processedMethods.add((Object)tobeProcessedMethod);
                        notFoundOperationList.remove((Object)tobeProcessedOp);
                    }
                    ++i_1;
                }
                int _length = ((Object[])Conversions.unwrapArray((Object)sameNameOperations, Object.class)).length;
                boolean bl7 = _lessThan = i_1 < _length;
                if (!_lessThan) continue;
                int j = i_1;
                while (j < ((Object[])Conversions.unwrapArray((Object)sameNameOperations, Object.class)).length) {
                    remainingOperations.add((Object)((Operation)sameNameOperations.get(j)));
                    ++j;
                }
                continue;
            }
            Operation mostSameOp = this.findMostSameOperation((List<Operation>)notFoundOperationList, notFoundMethod);
            if (mostSameOp == null) continue;
            Functions.Function1 _function_5 = it -> Objects.equals(it.eObject, mostSameOp);
            ModelChangeObject _head_1 = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_5));
            boolean bl8 = isModelObjectChanged_1 = _head_1 != null;
            if (isModelObjectChanged_1) {
                this.syncOperationWithMode(parent, mostSameOp, notFoundMethod, ConflictResolutionMode.FROM_MODEL);
            } else {
                this.syncOperationWithMode(parent, mostSameOp, notFoundMethod, ConflictResolutionMode.FROM_CODE);
            }
            processedMethods.add((Object)notFoundMethod);
            notFoundOperationList.remove((Object)mostSameOp);
        }
        for (Operation notFoundOp : notFoundOperationList) {
            boolean _not_2;
            boolean _contains_2 = remainingOperations.contains((Object)notFoundOp);
            boolean bl = _not_2 = !_contains_2;
            if (!_not_2) continue;
            remainingOperations.add((Object)notFoundOp);
        }
        for (IMethodDeclaration remaining : remainingMethods) {
            MethodUtils.createMethod(remaining, (Class)parent);
        }
        Functions.Function1 _function_6 = it -> it.eventType == 3 || it.eventType == 1;
        List remainingChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_6));
        for (Operation remaining_1 : remainingOperations) {
            Functions.Function1 _function_7 = it -> Objects.equals(it.eObject, remaining_1);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)remainingChanges, (Functions.Function1)_function_7));
            if (!_isEmpty) continue;
            if (parent instanceof Class) {
                EList _ownedOperations = ((Class)parent).getOwnedOperations();
                _ownedOperations.remove((Object)remaining_1);
                continue;
            }
            if (!(parent instanceof DataType)) continue;
            EList _ownedOperations_1 = ((DataType)parent).getOwnedOperations();
            _ownedOperations_1.remove((Object)remaining_1);
        }
    }

    private Object mergeNestedTypes(Classifier parent, List<Type> nestedTypes, List<IDeclaration> declarations) {
        return null;
    }

    private void reverseIncrementalChanges() {
        this.changeList.clear();
        this.optimizeChangeList();
        for (CppChangeObject change : this.changeList) {
            int _switchValue = change.changeKind;
            switch (_switchValue) {
                case 1: {
                    this.addToModel(change);
                    break;
                }
                case 4: {
                    this.updateToModel(change);
                    break;
                }
                case 2: {
                    this.removeFromModel(change);
                }
            }
        }
        this.changeList.clear();
    }

    private List<CElementChange> getRawChangeList() {
        if (ChangeMapStore.changesMap != null && ChangeMapStore.changesMap.get(this.project.getElementName()) != null && ChangeMapStore.changesMap.get(this.project.getElementName()).size() > 0) {
            return ChangeMapStore.changesMap.get(this.project.getElementName());
        }
        return null;
    }

    private void clearRawChangeList() {
        if (ChangeMapStore.changesMap != null && this.project != null && ChangeMapStore.changesMap.get(this.project.getElementName()) != null) {
            ChangeMapStore.changesMap.get(this.project.getElementName()).clear();
        }
    }

    private void optimizeChangeList() {
        List<CElementChange> rawChangeList = this.getRawChangeList();
        this.changeList.clear();
        UniqueEList processedList = new UniqueEList();
        UniqueEList remainList = new UniqueEList();
        int i = 0;
        while (i < rawChangeList.size()) {
            CElementChange change = rawChangeList.get(i);
            boolean _isInSourceContainers = this.isInSourceContainers(change.getElement());
            if (_isInSourceContainers) {
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                boolean _contains = processedList.contains(change);
                boolean bl = _not = !_contains;
                if (_not) {
                    int _changeKind = change.getChangeKind();
                    switch (_changeKind) {
                        case 1: {
                            boolean _greaterThan;
                            List<CElementChange> inter = this.findIntermediateEvent(rawChangeList, i, change);
                            int _size = inter.size();
                            boolean bl2 = _greaterThan = _size > 0;
                            if (!_greaterThan) break;
                            processedList.add(change);
                            processedList.addAll(inter);
                            break;
                        }
                        case 4: {
                            boolean _greaterThan_1;
                            List<CElementChange> inter_1 = this.findIntermediateEvent(rawChangeList, i, change);
                            int _size_1 = inter_1.size();
                            boolean bl3 = _greaterThan_1 = _size_1 > 0;
                            if (!_greaterThan_1) break;
                            processedList.addAll(inter_1);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            processedList.add(change);
                        }
                    }
                }
                boolean bl4 = _not_1 = !(_contains_1 = processedList.contains(change));
                if (_not_1) {
                    remainList.add(change);
                }
            }
            ++i;
        }
        HashMap doubtChangeListMap = new HashMap();
        int i2 = 0;
        while (i2 < remainList.size()) {
            CElementChange change = (CElementChange)remainList.get(i2);
            CppChangeObject cppChangeObject = null;
            int _changeKind = change.getChangeKind();
            switch (_changeKind) {
                case 1: {
                    CppChangeObject _cppChangeObject;
                    boolean found = false;
                    int j = i2 + 1;
                    while (j < remainList.size() && !found) {
                        if (((CElementChange)remainList.get(j)).getChangeKind() == 2 && change.getElement().getElementType() == ((CElementChange)remainList.get(j)).getElement().getElementType() && Objects.equals(((CElementChange)remainList.get(j)).getParent(), change.getParent())) {
                            boolean _tripleEquals;
                            CppChangeObject _cppChangeObject2;
                            ICElement _element = ((CElementChange)remainList.get(j)).getElement();
                            ICElement _element_1 = change.getElement();
                            ITranslationUnit _translationUnitFromElement = ReverseUtils.getTranslationUnitFromElement(change.getElement());
                            ICElement _parent = change.getParent();
                            cppChangeObject = _cppChangeObject2 = new CppChangeObject(_element, _element_1, _translationUnitFromElement, _parent, 4);
                            List _get = (List)doubtChangeListMap.get(change.getParent());
                            boolean bl = _tripleEquals = _get == null;
                            if (_tripleEquals) {
                                ICElement _parent_1 = change.getParent();
                                ArrayList _arrayList = new ArrayList();
                                doubtChangeListMap.put(_parent_1, _arrayList);
                            }
                            if (change.getElement() instanceof IField || change.getElement() instanceof IMethodDeclaration || change.getElement() instanceof IEnumerator) {
                                ((List)doubtChangeListMap.get(change.getParent())).add(cppChangeObject);
                            }
                            remainList.remove(j);
                            --j;
                            found = true;
                        }
                        ++j;
                    }
                    if (found) break;
                    ICElement _element = change.getElement();
                    ITranslationUnit _translationUnitFromElement = ReverseUtils.getTranslationUnitFromElement(change.getElement());
                    ICElement _parent = change.getParent();
                    cppChangeObject = _cppChangeObject = new CppChangeObject(null, _element, _translationUnitFromElement, _parent, 1);
                    break;
                }
                case 4: {
                    CppChangeObject _cppChangeObject_1;
                    ICElement _element_1 = ((CElementChange)remainList.get(i2)).getElement();
                    ICElement _element_2 = change.getElement();
                    ITranslationUnit _translationUnitFromElement_1 = ReverseUtils.getTranslationUnitFromElement(change.getElement());
                    ICElement _parent_1 = change.getParent();
                    cppChangeObject = _cppChangeObject_1 = new CppChangeObject(_element_1, _element_2, _translationUnitFromElement_1, _parent_1, 4);
                    break;
                }
                case 2: {
                    CppChangeObject _cppChangeObject_2;
                    ICElement _element_3;
                    boolean found_1 = false;
                    int j_1 = i2 + 1;
                    while (j_1 < remainList.size() && !found_1) {
                        if (((CElementChange)remainList.get(j_1)).getChangeKind() == 1 && change.getElement().getElementType() == ((CElementChange)remainList.get(j_1)).getElement().getElementType()) {
                            boolean _tripleEquals;
                            CppChangeObject _cppChangeObject_22;
                            _element_3 = change.getElement();
                            ICElement _element_4 = ((CElementChange)remainList.get(j_1)).getElement();
                            ITranslationUnit _translationUnitFromElement_2 = ReverseUtils.getTranslationUnitFromElement(change.getElement());
                            ICElement _parent_2 = change.getParent();
                            cppChangeObject = _cppChangeObject_22 = new CppChangeObject(_element_3, _element_4, _translationUnitFromElement_2, _parent_2, 4);
                            List _get = (List)doubtChangeListMap.get(change.getParent());
                            boolean bl = _tripleEquals = _get == null;
                            if (_tripleEquals) {
                                ICElement _parent_3 = change.getParent();
                                ArrayList _arrayList = new ArrayList();
                                doubtChangeListMap.put(_parent_3, _arrayList);
                            }
                            if (change.getElement() instanceof IField || change.getElement() instanceof IMethodDeclaration || change.getElement() instanceof IEnumerator) {
                                ((List)doubtChangeListMap.get(change.getParent())).add(cppChangeObject);
                            }
                            remainList.remove(j_1);
                            --j_1;
                            found_1 = true;
                        }
                        ++j_1;
                    }
                    if (found_1) break;
                    _element_3 = change.getElement();
                    ITranslationUnit _translationUnitFromElement_2 = ReverseUtils.getTranslationUnitFromElement(change.getElement());
                    ICElement _parent_2 = change.getParent();
                    cppChangeObject = _cppChangeObject_2 = new CppChangeObject(null, _element_3, _translationUnitFromElement_2, _parent_2, 2);
                }
            }
            if (cppChangeObject != null) {
                this.changeList.add(cppChangeObject);
            }
            ++i2;
        }
        Set _entrySet = doubtChangeListMap.entrySet();
        for (Map.Entry doubtMap : _entrySet) {
            boolean _greaterThan;
            int _size = ((List)doubtMap.getValue()).size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            this.alignChangedElements((ICElement)doubtMap.getKey(), (List)doubtMap.getValue());
        }
        this.clearRawChangeList();
    }

    private void alignChangedElements(ICElement parent, List<CppChangeObject> changes) {
        try {
            int _size_1;
            int _size;
            boolean _equals;
            ArrayList oldNamedElementsList = new ArrayList();
            HashMap oldNamedElementToChangeMap = new HashMap();
            Consumer<CppChangeObject> _function = it -> {
                NamedElement oldNamedElement = this.getNamedElement(it.parent, it.oldElement);
                oldNamedElementToChangeMap.put(oldNamedElement, it);
                oldNamedElementsList.add(oldNamedElement);
            };
            changes.forEach(_function);
            EObject namedElementParent = ((NamedElement)IterableExtensions.head(oldNamedElementsList)).eContainer();
            ArrayList alignedOldNamedElements = new ArrayList();
            Consumer<NamedElement> _function_1 = it -> {
                boolean _contains = oldNamedElementsList.contains(it);
                if (_contains) {
                    alignedOldNamedElements.add(it);
                }
            };
            Iterables.filter((Iterable)namedElementParent.eContents(), NamedElement.class).forEach(_function_1);
            ArrayList newICElements = new ArrayList();
            if (parent instanceof IParent) {
                Consumer<ICElement> _function_2 = it -> {
                    ICElement childInParent = it;
                    Functions.Function1 _function_3 = it_1 -> Objects.equals(it_1.newElement, childInParent);
                    CppChangeObject founded = (CppChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)changes, (Functions.Function1)_function_3));
                    if (founded != null) {
                        newICElements.add(founded.newElement);
                    }
                };
                ((List)Conversions.doWrapArray((Object)((IParent)parent).getChildren())).forEach(_function_2);
            }
            boolean bl = _equals = (_size = alignedOldNamedElements.size()) == (_size_1 = newICElements.size());
            if (_equals) {
                int i = 0;
                while (i < alignedOldNamedElements.size()) {
                    boolean _notEquals;
                    CppChangeObject change = (CppChangeObject)oldNamedElementToChangeMap.get(alignedOldNamedElements.get(i));
                    ICElement _get = (ICElement)newICElements.get(i);
                    boolean bl2 = _notEquals = !Objects.equals(change.newElement, _get);
                    if (_notEquals) {
                        boolean sameElementType = change.newElement instanceof IField && newICElements.get(i) instanceof IField;
                        sameElementType = sameElementType || change.newElement instanceof IMethodDeclaration && newICElements.get(i) instanceof IMethodDeclaration;
                        boolean bl3 = sameElementType = sameElementType || change.newElement instanceof IEnumerator && newICElements.get(i) instanceof IEnumerator;
                        if (sameElementType) {
                            change.newElement = (ICElement)newICElements.get(i);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private NamedElement getNamedElement(ICElement parent, ICElement child) {
        try {
            Property ret = null;
            boolean _matched = false;
            if (child instanceof IField) {
                boolean _isExist;
                IStructure parentStructure;
                Type classifier;
                _matched = true;
                if (parent instanceof IStructure && (classifier = GetOrCreateP2.getClassifier((ICElement)(parentStructure = (IStructure)parent))) != null && (_isExist = this.isExist((NamedElement)classifier, child.getElementName()))) {
                    Property prop;
                    Functions.Function1 _function = it -> it.getName().equals(child.getElementName());
                    ret = prop = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class), (Functions.Function1)_function));
                }
            }
            if (!_matched && child instanceof IMethodDeclaration) {
                boolean _isExist_1;
                IStructure parentStructure_1;
                Type classifier_1;
                _matched = true;
                if (parent instanceof IStructure && (classifier_1 = GetOrCreateP2.getClassifier((ICElement)(parentStructure_1 = (IStructure)parent))) != null && (_isExist_1 = this.isExist((NamedElement)classifier_1, child.getElementName()))) {
                    IMethodDeclaration oldMethod;
                    Functions.Function1 _function_2;
                    Functions.Function1 _function_1 = it -> it.getName().equals(child.getElementName());
                    List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier_1.getOwnedElements(), Operation.class), (Functions.Function1)_function_1));
                    Operation op = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)(_function_2 = arg_0 -> this.lambda$39(oldMethod = (IMethodDeclaration)child, arg_0))));
                    if (op != null) {
                        ret = op;
                    }
                }
            }
            if (!_matched && child instanceof IEnumerator) {
                _matched = true;
                IEnumeration cppEnumeration = (IEnumeration)parent;
                Type enumeration = GetOrCreateP2.getClassifier((ICElement)cppEnumeration);
                if (enumeration != null && enumeration instanceof Enumeration) {
                    Functions.Function1 _function_3 = it -> {
                        String _name = it.getName();
                        String _elementName = child.getElementName();
                        return Objects.equals(_name, _elementName);
                    };
                    EnumerationLiteral enumerator = (EnumerationLiteral)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Enumeration)enumeration).getOwnedLiterals(), EnumerationLiteral.class), (Functions.Function1)_function_3));
                    if (enumerator != null) {
                        ret = enumerator;
                    }
                }
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isInSourceContainers(ICElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ICContainer && this.containers.contains(element)) {
            return true;
        }
        return this.isInSourceContainers(element.getParent());
    }

    private List<CElementChange> findIntermediateEvent(List<CElementChange> list, int position, CElementChange change) {
        boolean _greaterThan;
        UniqueEList ret = new UniqueEList();
        int i = position + 1;
        while (i < list.size()) {
            if (change.getChangeKind() == 1 && list.get(i).getChangeKind() == 2 && this.isSameICElement(change.getElement(), list.get(i).getElement())) {
                if (change.getElement() instanceof IMethodDeclaration && list.get(i).getElement() instanceof IMethodDeclaration) {
                    ICElement _element_1;
                    ICElement _element = change.getElement();
                    IMethodDeclaration method = (IMethodDeclaration)_element;
                    boolean _isSameMethodDeclaration = this.isSameMethodDeclaration(method, (IMethodDeclaration)(_element_1 = list.get(i).getElement()));
                    if (_isSameMethodDeclaration) {
                        ret.add(list.get(i));
                    }
                } else {
                    ret.add(list.get(i));
                }
            } else if (change.getChangeKind() == 4 && this.isSameICElement(change.getElement(), list.get(i).getElement())) {
                ret.add(list.get(i));
            }
            ++i;
        }
        Functions.Function1 _function = it -> {
            int _changeKind = it.getChangeKind();
            return _changeKind == 4;
        };
        List changed = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ret, (Functions.Function1)_function));
        int _size = changed.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            ret.remove(IterableExtensions.lastOrNull((Iterable)changed));
        }
        return ret;
    }

    private boolean isSameICElement(ICElement e1, ICElement e2) {
        boolean ret = false;
        if (e1.getElementName().equals(e2.getElementName()) && e1.getElementType() == e2.getElementType() && e1.getParent().getElementName().equals(e2.getParent().getElementName())) {
            ret = true;
        }
        return ret;
    }

    private boolean isExist(NamedElement parent, String childName) {
        Functions.Function1 _function = it -> it.getName().equals(childName);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)parent.getOwnedElements(), NamedElement.class), (Functions.Function1)_function));
        return !_isEmpty;
    }

    private Object addToModel(CppChangeObject change) {
        try {
            Type _switchResult = null;
            ICElement _switchValue = change.newElement;
            boolean _matched = false;
            if (change.newElement instanceof IField) {
                ICElement _parent_1;
                IStructure parentStructure;
                Type classifier;
                _matched = true;
                IField field = (IField)change.newElement;
                ICElement _parent = field.getParent();
                if (_parent instanceof IStructure && (classifier = GetOrCreateP2.getClassifier((ICElement)(parentStructure = (IStructure)(_parent_1 = field.getParent())))) != null) {
                    boolean _not;
                    boolean _isExist = this.isExist((NamedElement)classifier, field.getElementName());
                    boolean bl = _not = !_isExist;
                    if (_not) {
                        PropertyUtils.createProperty(field, (Classifier)classifier);
                    }
                }
            }
            if (!_matched && change.newElement instanceof IMethodDeclaration) {
                _matched = true;
                Object _xblockexpression = null;
                IMethodDeclaration method = (IMethodDeclaration)change.newElement;
                Object _xifexpression = null;
                ICElement _parent_2 = method.getParent();
                if (_parent_2 instanceof IStructure) {
                    Object _xblockexpression_1 = null;
                    ICElement _parent_3 = method.getParent();
                    IStructure parentStructure_1 = (IStructure)_parent_3;
                    Type classifier_1 = GetOrCreateP2.getClassifier((ICElement)parentStructure_1);
                    Object _xifexpression_1 = null;
                    if (classifier_1 != null) {
                        Object _xblockexpression_2 = null;
                        Functions.Function1 _function = it -> it.getName().equals(method.getElementName());
                        List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier_1.getOwnedElements(), Operation.class), (Functions.Function1)_function));
                        Object _xifexpression_2 = null;
                        Functions.Function1 _function_1 = it -> this.isSameSignature((Operation)it, method);
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)_function_1));
                        if (_isEmpty) {
                            _xifexpression_2 = MethodUtils.createMethod(method, (Class)classifier_1);
                        }
                        _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_1 = _xifexpression_1;
                } else {
                    Object _xifexpression_1 = null;
                    ICElement _parent_3 = method.getParent();
                    if (_parent_3 instanceof ITranslationUnit) {
                        _xifexpression_1 = null;
                    }
                    _xifexpression = _xifexpression_1;
                }
                _xblockexpression = _xifexpression;
                _switchResult = _xblockexpression;
            }
            if (!_matched) {
                if (change.newElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.newElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.newElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    Type _xblockexpression_1 = null;
                    IDeclaration declaration = (IDeclaration)change.newElement;
                    _switchResult = _xblockexpression_1 = GetOrCreateP1.getOrCreateClassifier((ICElement)declaration);
                }
            }
            if (!_matched && change.newElement instanceof IEnumerator) {
                _matched = true;
                IEnumerator enumerator = (IEnumerator)change.newElement;
                IPath _path = enumerator.getPath();
                IEnumeration cppEnumeration = (IEnumeration)_path;
                Type enumeration = GetOrCreateP2.getClassifier((ICElement)cppEnumeration);
                if (enumeration instanceof Enumeration) {
                    ReverseUtils.setXmlID((NamedElement)((Enumeration)enumeration).createOwnedLiteral(enumerator.getElementName()));
                }
            }
            if (!_matched && change.newElement instanceof ITranslationUnit) {
                _matched = true;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                GetOrCreateP1.getOrCreateClassifiers((IParent)itu);
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object updateToModel(CppChangeObject change) {
        try {
            Object _switchResult = null;
            ICElement _switchValue = change.newElement;
            boolean _matched = false;
            if (change.oldElement instanceof IField) {
                boolean _isExist;
                ICElement _parent_1;
                IStructure parentStructure;
                Type classifier;
                _matched = true;
                IField field = (IField)change.newElement;
                ICElement _parent = field.getParent();
                if (_parent instanceof IStructure && (classifier = GetOrCreateP2.getClassifier((ICElement)(parentStructure = (IStructure)(_parent_1 = field.getParent())))) != null && (_isExist = this.isExist((NamedElement)classifier, change.oldElement.getElementName()))) {
                    Functions.Function1 _function = it -> it.getName().equals(cppChangeObject.oldElement.getElementName());
                    Property prop = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class), (Functions.Function1)_function));
                    if (prop != null) {
                        PropertyUtils.updateProperty((IField)change.newElement, prop);
                    }
                }
            }
            if (!_matched && change.oldElement instanceof IMethodDeclaration) {
                _matched = true;
                Object _xblockexpression = null;
                IMethodDeclaration method = (IMethodDeclaration)change.newElement;
                Object _xifexpression = null;
                ICElement _parent_2 = method.getParent();
                if (_parent_2 instanceof IStructure) {
                    Object _xblockexpression_1 = null;
                    ICElement _parent_3 = method.getParent();
                    IStructure parentStructure_1 = (IStructure)_parent_3;
                    Type classifier_1 = GetOrCreateP2.getClassifier((ICElement)parentStructure_1);
                    Object _xifexpression_1 = null;
                    if (classifier_1 != null) {
                        Object _xifexpression_2 = null;
                        boolean _isExist_1 = this.isExist((NamedElement)classifier_1, change.oldElement.getElementName());
                        if (_isExist_1) {
                            Object _xblockexpression_2 = null;
                            Functions.Function1 _function_1 = it -> it.getName().equals(cppChangeObject.oldElement.getElementName());
                            List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier_1.getOwnedElements(), Operation.class), (Functions.Function1)_function_1));
                            IMethodDeclaration oldMethod = (IMethodDeclaration)change.oldElement;
                            Functions.Function1 _function_2 = it -> this.isSameSignature((Operation)it, oldMethod);
                            Operation op = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)_function_2));
                            Object _xifexpression_3 = null;
                            if (op != null) {
                                _xifexpression_3 = MethodUtils.updateMethod((Class)classifier_1, op, (IMethodDeclaration)change.newElement);
                            }
                            _xifexpression_2 = _xblockexpression_2 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_1 = _xifexpression_1;
                } else {
                    ICElement _parent_3 = method.getParent();
                    if (_parent_3 instanceof ITranslationUnit) {
                        ICElement _parent_4 = method.getParent();
                        this.reverseSource((ITranslationUnit)_parent_4);
                    }
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched) {
                if (change.oldElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    IDeclaration declaration = (IDeclaration)change.newElement;
                    Type umlClassifier = GetOrCreateP2.getClassifier((ICElement)((IDeclaration)change.oldElement));
                    if (umlClassifier != null) {
                        umlClassifier.setName(declaration.getElementName());
                    }
                }
            }
            if (!_matched && change.oldElement instanceof IEnumerator) {
                _matched = true;
                IEnumerator cppEnumerator = (IEnumerator)change.newElement;
                ICElement _parent_2 = cppEnumerator.getParent();
                IEnumeration cppEnumeration = (IEnumeration)_parent_2;
                Type enumeration = GetOrCreateP2.getClassifier((ICElement)cppEnumeration);
                if (enumeration != null && enumeration instanceof Enumeration) {
                    Functions.Function1 _function_1 = it -> {
                        String _name = it.getName();
                        String _elementName = cppChangeObject.oldElement.getElementName();
                        return Objects.equals(_name, _elementName);
                    };
                    EnumerationLiteral enumerator = (EnumerationLiteral)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Enumeration)enumeration).getOwnedLiterals(), EnumerationLiteral.class), (Functions.Function1)_function_1));
                    if (enumerator != null) {
                        enumerator.setName(cppEnumerator.getElementName());
                    }
                }
            }
            if (!_matched && change.oldElement instanceof ITranslationUnit) {
                _matched = true;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                boolean _isSourceUnit = itu.isSourceUnit();
                if (_isSourceUnit) {
                    this.reverseSource(itu);
                } else {
                    boolean _isHeaderUnit = itu.isHeaderUnit();
                    if (_isHeaderUnit) {
                        this.reverseHeader(itu);
                    }
                }
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Boolean removeFromModel(CppChangeObject change) {
        try {
            Functions.Function1 _function;
            boolean _isExist;
            boolean _xifexpression_2;
            boolean _xifexpression_1;
            Type classifier;
            IStructure parentStructure;
            ICElement _parent_1;
            ICElement _parent;
            boolean _xifexpression;
            boolean _switchResult = false;
            ICElement _switchValue = change.oldElement;
            boolean _matched = false;
            if (change.oldElement instanceof IField) {
                _matched = true;
                boolean _xblockexpression = false;
                IField field = (IField)change.oldElement;
                _xifexpression = false;
                _parent = field.getParent();
                if (_parent instanceof IStructure) {
                    boolean _xblockexpression_1 = false;
                    _parent_1 = field.getParent();
                    parentStructure = (IStructure)_parent_1;
                    classifier = GetOrCreateP2.getClassifier((ICElement)parentStructure);
                    _xifexpression_1 = false;
                    if (classifier != null) {
                        _xifexpression_2 = false;
                        _isExist = this.isExist((NamedElement)classifier, change.oldElement.getElementName());
                        if (_isExist) {
                            boolean _xblockexpression_2 = false;
                            _function = it -> it.getName().equals(cppChangeObject.oldElement.getElementName());
                            Property prop = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class), (Functions.Function1)_function));
                            boolean _xifexpression_3 = false;
                            if (prop != null) {
                                boolean _xifexpression_4 = false;
                                if (classifier instanceof Class) {
                                    EList _ownedAttributes = ((Class)classifier).getOwnedAttributes();
                                    _xifexpression_4 = _ownedAttributes.remove((Object)prop);
                                } else {
                                    boolean _xifexpression_5 = false;
                                    if (classifier instanceof DataType) {
                                        EList _ownedAttributes_1 = ((DataType)classifier).getOwnedAttributes();
                                        _xifexpression_5 = _ownedAttributes_1.remove((Object)prop);
                                    }
                                    _xifexpression_4 = _xifexpression_5;
                                }
                                _xifexpression_3 = _xifexpression_4;
                            }
                            _xifexpression_2 = _xblockexpression_2 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_1 = _xifexpression_1;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched && change.oldElement instanceof IMethodDeclaration) {
                _matched = true;
                boolean _xblockexpression_1 = false;
                IMethodDeclaration method = (IMethodDeclaration)change.oldElement;
                _xifexpression = false;
                _parent = method.getParent();
                if (_parent instanceof IStructure) {
                    boolean _xblockexpression_2 = false;
                    _parent_1 = method.getParent();
                    parentStructure = (IStructure)_parent_1;
                    classifier = GetOrCreateP2.getClassifier((ICElement)parentStructure);
                    _xifexpression_1 = false;
                    if (classifier != null) {
                        _xifexpression_2 = false;
                        _isExist = this.isExist((NamedElement)classifier, change.oldElement.getElementName());
                        if (_isExist) {
                            boolean _xblockexpression_3 = false;
                            _function = it -> it.getName().equals(method.getElementName());
                            List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Operation.class), (Functions.Function1)_function));
                            Functions.Function1 _function_1 = it -> this.isSameSignature((Operation)it, method);
                            Operation op = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)_function_1));
                            boolean _xifexpression_3 = false;
                            if (op != null) {
                                boolean _xifexpression_4 = false;
                                if (classifier instanceof Class) {
                                    EList _ownedOperations = ((Class)classifier).getOwnedOperations();
                                    _xifexpression_4 = _ownedOperations.remove((Object)op);
                                }
                                _xifexpression_3 = _xifexpression_4;
                            }
                            _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_2 = _xifexpression_1;
                }
                _switchResult = _xblockexpression_1 = _xifexpression;
            }
            if (!_matched) {
                if (change.oldElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    boolean _xblockexpression_2 = false;
                    IDeclaration declaration = (IDeclaration)change.oldElement;
                    _xifexpression = false;
                    if (change.parent instanceof IStructure) {
                        boolean _xblockexpression_3 = false;
                        IStructure parentStructure2 = (IStructure)change.parent;
                        Type parentClassifier = GetOrCreateP2.getClassifier((ICElement)parentStructure2);
                        Functions.Function1 _function2 = it -> {
                            String _name = it.getName();
                            String _elementName = declaration.getElementName();
                            return Objects.equals(_name, _elementName);
                        };
                        Type childClassifier = (Type)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)parentClassifier.getOwnedElements(), Type.class), (Functions.Function1)_function2));
                        _xifexpression_1 = false;
                        if (childClassifier != null && parentClassifier instanceof Class) {
                            EList _nestedClassifiers = ((Class)parentClassifier).getNestedClassifiers();
                            _xifexpression_1 = _nestedClassifiers.remove((Object)((Classifier)childClassifier));
                        }
                        _xifexpression = _xblockexpression_3 = _xifexpression_1;
                    } else {
                        boolean _xblockexpression_4 = false;
                        Model containerPackage = ReverseUtils.getCorrespondingModel(declaration.getTranslationUnit());
                        Functions.Function1 _function3 = it -> {
                            String _name = it.getName();
                            String _elementName = declaration.getElementName();
                            return Objects.equals(_name, _elementName);
                        };
                        Type childClassifier = (Type)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)containerPackage.getOwnedElements(), Type.class), (Functions.Function1)_function3));
                        EList _ownedTypes = containerPackage.getOwnedTypes();
                        _xifexpression = _xblockexpression_4 = _ownedTypes.remove((Object)childClassifier);
                    }
                    _switchResult = _xblockexpression_2 = _xifexpression;
                }
            }
            if (!_matched && change.oldElement instanceof IEnumerator) {
                _matched = true;
                boolean _xblockexpression_3 = false;
                IEnumerator cppEnumerator = (IEnumerator)change.oldElement;
                IPath _path = cppEnumerator.getPath();
                IEnumeration cppEnumeration = (IEnumeration)_path;
                Type enumeration = GetOrCreateP2.getClassifier((ICElement)cppEnumeration);
                boolean _xifexpression2 = false;
                if (enumeration != null && enumeration instanceof Enumeration) {
                    boolean _xblockexpression_4 = false;
                    EnumerationLiteral enumerator = ((Enumeration)enumeration).getOwnedLiteral(change.oldElement.getElementName());
                    _xifexpression_1 = false;
                    if (enumerator != null) {
                        EList _ownedLiterals = ((Enumeration)enumeration).getOwnedLiterals();
                        _xifexpression_1 = _ownedLiterals.remove((Object)enumerator);
                    }
                    _xifexpression2 = _xblockexpression_4 = _xifexpression_1;
                }
                _switchResult = _xblockexpression_3 = _xifexpression2;
            }
            if (!_matched && change.oldElement instanceof ITranslationUnit) {
                _matched = true;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                GetOrCreateP1.getOrCreateClassifiers((IParent)itu);
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private /* synthetic */ Boolean lambda$39(IMethodDeclaration iMethodDeclaration, Operation it) {
        return this.isSameSignature(it, iMethodDeclaration);
    }

    public static enum ConflictResolutionMode {
        FROM_MODEL,
        FROM_CODE,
        UI_INTERACTION;

    }

    public static enum ReverseMode {
        BATCH,
        INCREMENTAL;

    }
}

