/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppClassUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Union;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Ansgar Radermacher (ansgar.radermacher@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassifierGenerator {
  public static CharSequence generateBindHeaderCode(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef ");
    String _fullNameUC = GenUtils.getFullNameUC(classifier);
    _builder.append(_fullNameUC);
    _builder.append("_H");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _fullNameUC_1 = GenUtils.getFullNameUC(classifier);
    _builder.append(_fullNameUC_1);
    _builder.append("_H");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    String _name = classifier.getName();
    _builder.append(_name, "              ");
    _builder.append(" template binding header");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    _builder.newLine();
    String _includeDirective = CppIncludeUtil.includeDirective(CppClassIncludeClassDeclaration.cppOwnerPackageIncludePath(classifier.getPackage()));
    _builder.append(_includeDirective);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _CppIncludeHeader = CppIncludeUtil.CppIncludeHeader(classifier);
    _builder.append(_CppIncludeHeader);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    TemplateBinding tb = GenUtils.getTemplateBinding(classifier);
    _builder.newLineIfNotEmpty();
    Element templateElement = tb.getTargets().get(0);
    _builder.newLineIfNotEmpty();
    String _fullPath = GenUtils.getFullPath(classifier.getPackage());
    String _plus = (_fullPath + "/");
    Element _owner = templateElement.getOwner();
    String _name_1 = ((NamedElement) _owner).getName();
    String _plus_1 = (_plus + _name_1);
    String _plus_2 = (_plus_1 + ".");
    String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
    String _plus_3 = (_plus_2 + _headerSuffix);
    String _includeDirective_1 = CppIncludeUtil.includeDirective(_plus_3);
    _builder.append(_includeDirective_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      List<String> _sortedDeclarePathList = CppClassifierGenerator.getSortedDeclarePathList(classifier);
      for(final String path : _sortedDeclarePathList) {
        String _declareDirective = CppIncludeUtil.declareDirective(path);
        _builder.append(_declareDirective);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _usingNamespaces = CppCodeGenUtils.getUsingNamespaces();
      if (_usingNamespaces) {
        _builder.append("// derived using directives");
        _builder.newLine();
        {
          List<String> _sort = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllUsings(classifier, CppClassUtils.Position.FOR_HEADER));
          for(final String path_1 : _sort) {
            String _usingDirective = CppIncludeUtil.usingDirective(path_1);
            _builder.append(_usingDirective);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    String _openNS = CppGenUtils.openNS(classifier);
    _builder.append(_openNS);
    _builder.newLineIfNotEmpty();
    _builder.append("/************************************************************/");
    _builder.newLine();
    _builder.append("typedef ");
    Element _owner_1 = templateElement.getOwner();
    String _name_2 = ((NamedElement) _owner_1).getName();
    _builder.append(_name_2);
    _builder.append("<");
    {
      EList<TemplateParameterSubstitution> _parameterSubstitutions = tb.getParameterSubstitutions();
      boolean _hasElements = false;
      for(final TemplateParameterSubstitution ps : _parameterSubstitutions) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        Object _CppTemplateBindingParameter = CppTemplates.CppTemplateBindingParameter(ps);
        _builder.append(_CppTemplateBindingParameter);
      }
    }
    _builder.append("> ");
    String _name_3 = classifier.getName();
    _builder.append(_name_3);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _closeNS = CppGenUtils.closeNS(classifier);
    _builder.append(_closeNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("End of ");
    String _name_4 = classifier.getName();
    _builder.append(_name_4, "              ");
    _builder.append(" template binding header");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }

  public static List<String> getSortedIncludePathList(final Classifier classifier) {
    List<String> includePathList = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllIncludes(classifier));
    return includePathList;
  }

  public static List<String> getSortedDeclarePathList(final Classifier classifier) {
    List<String> declarePathList = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllDeclares(classifier));
    return declarePathList;
  }

  public static CharSequence generateBindBodyCode(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#define ");
    String _fullNameUC = GenUtils.getFullNameUC(classifier);
    _builder.append(_fullNameUC);
    _builder.append("_BODY");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    String _name = classifier.getName();
    _builder.append(_name, "              ");
    _builder.append(" template binding body");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    _builder.newLine();
    String _CppIncludePreBody = CppIncludeUtil.CppIncludePreBody(classifier);
    _builder.append(_CppIncludePreBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include associated header file");
    _builder.newLine();
    String _fullPath = GenUtils.getFullPath(classifier.getPackage());
    String _plus = (_fullPath + "/");
    String _name_1 = classifier.getName();
    String _plus_1 = (_plus + _name_1);
    String _plus_2 = (_plus_1 + ".");
    String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
    String _plus_3 = (_plus_2 + _headerSuffix);
    String _includeDirective = CppIncludeUtil.includeDirective(_plus_3);
    _builder.append(_includeDirective);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    _builder.append("// Derived includes directives");
    _builder.newLine();
    {
      List<String> _sort = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllIncludesDeclarationBody(classifier));
      for(final String path : _sort) {
        String _includeDirective_1 = CppIncludeUtil.includeDirective(path);
        _builder.append(_includeDirective_1);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    String _CppIncludeBody = CppIncludeUtil.CppIncludeBody(classifier);
    _builder.append(_CppIncludeBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _openNS = CppGenUtils.openNS(classifier);
    _builder.append(_openNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************/");
    _builder.newLine();
    TemplateBinding tb = GenUtils.getTemplateBinding(classifier);
    _builder.newLineIfNotEmpty();
    Element templateElement = tb.getTargets().get(0);
    _builder.newLineIfNotEmpty();
    _builder.append("template class ");
    Element _owner = templateElement.getOwner();
    String _name_2 = ((NamedElement) _owner).getName();
    _builder.append(_name_2);
    _builder.append("<");
    {
      EList<TemplateParameterSubstitution> _parameterSubstitutions = tb.getParameterSubstitutions();
      boolean _hasElements = false;
      for(final TemplateParameterSubstitution ps : _parameterSubstitutions) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        Object _CppTemplateBindingParameter = CppTemplates.CppTemplateBindingParameter(ps);
        _builder.append(_CppTemplateBindingParameter);
      }
    }
    _builder.append(">;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _closeNS = CppGenUtils.closeNS(classifier);
    _builder.append(_closeNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("End of ");
    String _name_3 = classifier.getName();
    _builder.append(_name_3, "              ");
    _builder.append(" template binding body");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence generateClassHeaderCode(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef ");
    String _fullNameUC = GenUtils.getFullNameUC(classifier);
    _builder.append(_fullNameUC);
    _builder.append("_H");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _fullNameUC_1 = GenUtils.getFullNameUC(classifier);
    _builder.append(_fullNameUC_1);
    _builder.append("_H");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    String _name = classifier.getName();
    _builder.append(_name, "              ");
    _builder.append(" class header");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    _builder.newLine();
    String _includeDirective = CppIncludeUtil.includeDirective(CppClassIncludeClassDeclaration.cppOwnerPackageIncludePath(classifier.getPackage()));
    _builder.append(_includeDirective);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      List<String> _sortedIncludePathList = CppClassifierGenerator.getSortedIncludePathList(classifier);
      for(final String path : _sortedIncludePathList) {
        String _includeDirective_1 = CppIncludeUtil.includeDirective(path);
        _builder.append(_includeDirective_1);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    String _CppIncludeHeader = CppIncludeUtil.CppIncludeHeader(classifier);
    _builder.append(_CppIncludeHeader);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      List<String> _sortedDeclarePathList = CppClassifierGenerator.getSortedDeclarePathList(classifier);
      for(final String path_1 : _sortedDeclarePathList) {
        String _declareDirective = CppIncludeUtil.declareDirective(path_1);
        _builder.append(_declareDirective);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _usingNamespaces = CppCodeGenUtils.getUsingNamespaces();
      if (_usingNamespaces) {
        _builder.append("// derived using directives");
        _builder.newLine();
        {
          List<String> _sort = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllUsings(classifier, CppClassUtils.Position.FOR_HEADER));
          for(final String path_2 : _sort) {
            String _usingDirective = CppIncludeUtil.usingDirective(path_2);
            _builder.append(_usingDirective);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    String _openNS = CppGenUtils.openNS(classifier);
    _builder.append(_openNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************/");
    _builder.newLine();
    CharSequence _CppElementDoc = CppDocumentation.CppElementDoc(classifier);
    _builder.append(_CppElementDoc);
    _builder.newLineIfNotEmpty();
    String _prePragma = CppPragma.prePragma(classifier);
    _builder.append(_prePragma);
    _builder.newLineIfNotEmpty();
    CharSequence _templateSignature = CppTemplates.templateSignature(classifier);
    _builder.append(_templateSignature);
    String _classUnionOrStruct = CppClassifierGenerator.classUnionOrStruct(classifier);
    _builder.append(_classUnionOrStruct);
    _builder.append(" ");
    String _name_1 = classifier.getName();
    _builder.append(_name_1);
    CharSequence _CppClassInheritedDeclarations = CppClassInheritedDeclarations.CppClassInheritedDeclarations(classifier);
    _builder.append(_CppClassInheritedDeclarations);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CppClassFriendDeclaration.CppClassIncludeFriendDeclaration(classifier);
    String _CppClassTypeAndEnum = CppClassTypeAndEnum.CppClassTypeAndEnum(classifier);
    _builder.append(_CppClassTypeAndEnum, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    VisibilityKind publicVisibility = VisibilityKind.PUBLIC_LITERAL;
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section = CppGenUtils.cgu(classifier).getSection(publicVisibility, CppClassifierGenerator.defaultInitializer(classifier));
    _builder.append(_section, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section_1 = CppGenUtils.cgu(classifier).getSection(publicVisibility, 
      CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, publicVisibility).toString());
    _builder.append(_section_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section_2 = CppGenUtils.cgu(classifier).getSection(publicVisibility, 
      CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, publicVisibility).toString());
    _builder.append(_section_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    VisibilityKind protectedVisibility = VisibilityKind.PROTECTED_LITERAL;
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section_3 = CppGenUtils.cgu(classifier).getSection(protectedVisibility, 
      CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, protectedVisibility).toString());
    _builder.append(_section_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section_4 = CppGenUtils.cgu(classifier).getSection(protectedVisibility, 
      CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, protectedVisibility).toString());
    _builder.append(_section_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    VisibilityKind privateVisibility = VisibilityKind.PRIVATE_LITERAL;
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section_5 = CppGenUtils.cgu(classifier).getSection(privateVisibility, 
      CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, privateVisibility).toString());
    _builder.append(_section_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _section_6 = CppGenUtils.cgu(classifier).getSection(privateVisibility, 
      CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, privateVisibility).toString());
    _builder.append(_section_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    String _postPragma = CppPragma.postPragma(classifier);
    _builder.append(_postPragma);
    _builder.newLineIfNotEmpty();
    _builder.append("/************************************************************/");
    _builder.newLine();
    _builder.append("/* External declarations (package visibility)               */");
    _builder.newLine();
    VisibilityKind packageVisibility = VisibilityKind.PACKAGE_LITERAL;
    _builder.newLineIfNotEmpty();
    CharSequence _CppClassAttributesDeclaration = CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, packageVisibility);
    _builder.append(_CppClassAttributesDeclaration);
    _builder.newLineIfNotEmpty();
    CharSequence _CppClassOperationsDeclaration = CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, packageVisibility);
    _builder.append(_CppClassOperationsDeclaration);
    _builder.newLineIfNotEmpty();
    _builder.append("/************************************************************/");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _isTemplate = CppTemplates.isTemplate(classifier);
      if (_isTemplate) {
        _builder.append("/************************************************************/");
        _builder.newLine();
        _builder.append("/* Template functions                                       */");
        _builder.newLine();
        CharSequence _CppClassOperationsImplementation = CppClassOperationsImplementation.CppClassOperationsImplementation(classifier, false);
        _builder.append(_CppClassOperationsImplementation);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("/* Inline functions                                         */");
    _builder.newLine();
    CharSequence _CppClassOperationsImplementation_1 = CppClassOperationsImplementation.CppClassOperationsImplementation(classifier, true);
    _builder.append(_CppClassOperationsImplementation_1);
    _builder.newLineIfNotEmpty();
    String _closeNS = CppGenUtils.closeNS(classifier);
    _builder.append(_closeNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("End of ");
    String _name_2 = classifier.getName();
    _builder.append(_name_2, "              ");
    _builder.append(" class header");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }

  public static String classUnionOrStruct(final Classifier classifier) {
    boolean _hasStereotype = GenUtils.hasStereotype(classifier, Union.class);
    if (_hasStereotype) {
      return "union";
    } else {
      if ((classifier instanceof DataType)) {
        CppGenUtils.cgu(classifier).resetVisibility(VisibilityKind.PUBLIC_LITERAL);
        return "struct";
      } else {
        CppGenUtils.cgu(classifier).resetVisibility(VisibilityKind.PRIVATE_LITERAL);
        return "class";
      }
    }
  }

  /**
   * default initializer for non-static attributes with a default value
   * Currently disabled, since non-static members can be initialized directly in C++ 011
   */
  public static String defaultInitializer(final Classifier classifier) {
    return "";
  }

  public static CharSequence generateClassBodyCode(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#define ");
    String _fullName = GenUtils.getFullName(classifier);
    _builder.append(_fullName);
    _builder.append("_BODY");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    String _name = classifier.getName();
    _builder.append(_name, "              ");
    _builder.append(" class body");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    _builder.newLine();
    String _CppIncludePreBody = CppIncludeUtil.CppIncludePreBody(classifier);
    _builder.append(_CppIncludePreBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include associated header file");
    _builder.newLine();
    String _fullPath = GenUtils.getFullPath(classifier.getNearestPackage());
    String _plus = (_fullPath + "/");
    String _name_1 = classifier.getName();
    String _plus_1 = (_plus + _name_1);
    String _plus_2 = (_plus_1 + ".");
    String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
    String _plus_3 = (_plus_2 + _headerSuffix);
    String _includeDirective = CppIncludeUtil.includeDirective(_plus_3);
    _builder.append(_includeDirective);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// Derived includes directives");
    _builder.newLine();
    {
      List<String> _sort = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllIncludesDeclarationBody(classifier));
      for(final String path : _sort) {
        String _includeDirective_1 = CppIncludeUtil.includeDirective(path);
        _builder.append(_includeDirective_1);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    String _CppIncludeBody = CppIncludeUtil.CppIncludeBody(classifier);
    _builder.append(_CppIncludeBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _usingNamespaces = CppCodeGenUtils.getUsingNamespaces();
      if (_usingNamespaces) {
        _builder.append("// Derived using namespaces");
        _builder.newLine();
        {
          List<String> _sort_1 = IterableExtensions.<String>sort(CppClassIncludeClassDeclaration.CppClassAllUsings(classifier, CppClassUtils.Position.FOR_BODY));
          for(final String path_1 : _sort_1) {
            String _usingDirective = CppIncludeUtil.usingDirective(path_1);
            _builder.append(_usingDirective);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    String _openNS = CppGenUtils.openNS(classifier);
    _builder.append(_openNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _CppStaticAttributes = CppAttribute.CppStaticAttributes(classifier);
    _builder.append(_CppStaticAttributes);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _isTemplate = classifier.isTemplate();
      boolean _not = (!_isTemplate);
      if (_not) {
        CharSequence _CppClassOperationsImplementation = CppClassOperationsImplementation.CppClassOperationsImplementation(classifier, false);
        _builder.append(_CppClassOperationsImplementation);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    String _closeNS = CppGenUtils.closeNS(classifier);
    _builder.append(_closeNS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/************************************************************");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("End of ");
    String _name_2 = classifier.getName();
    _builder.append(_name_2, "              ");
    _builder.append(" class body");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("************************************************************/");
    _builder.newLine();
    return _builder;
  }
}
