/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassFriendDeclaration {
  public static CharSequence CppClassFriendDeclaration(final Classifier hostingClass, final Classifier friend) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("friend class ");
    String _cppQualifiedName = CppGenUtils.cgu(hostingClass).cppQualifiedName(friend);
    _builder.append(_cppQualifiedName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static void CppClassIncludeFriendDeclaration(final Classifier clazz) {
    EList<Classifier> _usedClassifiers = GenUtils.getUsedClassifiers(clazz);
    for (final Classifier uc : _usedClassifiers) {
      if ((GenUtils.hasStereotype(uc, Friend.class) && (!GenUtils.hasStereotype(uc, NoCodeGen.class)))) {
        CppClassFriendDeclaration.CppClassFriendDeclaration(clazz, uc);
      }
    }
  }
}
