/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.edit.policies;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.utlis.CommandsUtils;
import org.eclipse.papyrus.uml.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.Utils;
import org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;

public class CreateInGroupEditPolicy
extends CreationEditPolicy {
    private List<IGraphicalEditPart> graphicalParents;
    private List<IGraphicalEditPart> modelParents;

    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        TransactionalEditingDomain editingDomain = ((GraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeCommand handleChildren = null;
        View view = (View)this.getHost().getModel();
        EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
        if (hostElement == null && view.getElement() == null) {
            hostElement = view;
        }
        if (hostElement == null) {
            return null;
        }
        EditPart currentEditPart = this.getHost();
        if (currentEditPart instanceof IGraphicalEditPart) {
            DiagramEditPart diagramPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)currentEditPart);
            this.graphicalParents = new ArrayList<IGraphicalEditPart>();
            this.modelParents = new ArrayList<IGraphicalEditPart>();
            Utils.createComputedListsOfParents(this.graphicalParents, this.modelParents, request, (IGraphicalEditPart)diagramPart, createElementRequest.getElementType().getEClass());
            CommandsUtils.setRequestParentsParameters((Request)request, this.graphicalParents, this.modelParents, this.getHost());
            Command relocatedCommand = CommandsUtils.sendRequestSuitableHost(request, createElementRequest, (IGraphicalEditPart)this.getHost(), this.modelParents);
            if (relocatedCommand != null) {
                return relocatedCommand;
            }
            Set<AbstractContainerNodeDescriptor> descriptors = GroupContainmentRegistry.getDescriptorsWithContainerEClass(createElementRequest.getElementType().getEClass());
            handleChildren = CommandsUtils.getHandleChildrenCommand(descriptors, (Request)request, diagramPart, editingDomain, (IAdaptable)requestAdapter, this.modelParents, (IGraphicalEditPart)this.getHost());
            Command createElementCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class)), request.getExtendedData()));
            if (createElementCommand == null || !createElementCommand.canExecute()) {
                return UnexecutableCommand.INSTANCE;
            }
            Command viewCommand = this.getCreateCommand((CreateViewRequest)request);
            Command refreshConnectionCommand = this.getHost().getCommand((Request)new RefreshConnectionsRequest((List)request.getNewObject()));
            CompositeCommand semanticCommand = CommandsUtils.getSemanticCommand(requestAdapter, editingDomain, createElementRequest, createElementCommand, this.graphicalParents);
            CompositeCommand choiceCommand = CommandsUtils.getChooseParentNotification(editingDomain, request, this.graphicalParents, this.modelParents, (IGraphicalEditPart)this.getHost());
            CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
            cc.compose((IUndoableOperation)semanticCommand);
            cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
            if (choiceCommand != null) {
                cc.compose((IUndoableOperation)choiceCommand);
            }
            if (handleChildren != null) {
                cc.compose((IUndoableOperation)handleChildren);
            }
            if (refreshConnectionCommand != null) {
                cc.compose((IUndoableOperation)new CommandProxy(refreshConnectionCommand));
            }
            return new ICommandProxy((ICommand)cc);
        }
        return super.getCreateElementAndViewCommand(request);
    }

    public Command getCreateCommand(CreateViewRequest request) {
        Object parentPart;
        IGraphicalEditPart newParentPart = (IGraphicalEditPart)this.getHost();
        Object graphicalParents = request.getExtendedData().get("GROUP_GRAPHICAL_CONTAINERS");
        if (graphicalParents instanceof List && !((List)graphicalParents).isEmpty() && (parentPart = ((List)graphicalParents).get(0)) instanceof IGraphicalEditPart) {
            newParentPart = (IGraphicalEditPart)parentPart;
        }
        request.getExtendedData().put("Graphical_parent", newParentPart);
        View parent = (View)newParentPart.getModel();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            CreateCommand createCommand = new CreateCommand(editingDomain, descriptor, parent);
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }
}

