/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.model.xwt.modisco;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.papyrus.views.properties.model.xwt.Activator;
import org.eclipse.papyrus.views.properties.model.xwt.modisco.GenericXMLHandler;
import org.eclipse.papyrus.views.properties.model.xwt.modisco.GenericXMLWriter;
import org.eclipse.papyrus.views.properties.model.xwt.xwtxml.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GenericXMLResourceImpl
extends ResourceImpl {
    public GenericXMLResourceImpl(URI uri) {
        super(uri);
    }

    protected final void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(false);
            SAXParser p = f.newSAXParser();
            GenericXMLHandler handler = new GenericXMLHandler((Resource)this, options);
            XMLReader reader = p.getXMLReader();
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXNotRecognizedException e) {
                String message = "Default XML sax parser does not support lexical handling.\nDTDs and comment informations will not be available.";
                Activator.log.warn(message);
            }
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException e) {
                Activator.log.warn(e.getMessage());
            }
            p.parse(inputStream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected final void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        GenericXMLWriter writer = new GenericXMLWriter(outputStream);
        for (EObject topLevelObject : this.getContents()) {
            writer.serialize((Element)topLevelObject);
        }
        writer.flush();
        writer.close();
    }
}

