/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattabletester.AbstractTableTester;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getIconPath <em>Icon Path</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getCreationTester <em>Creation Tester</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getCellEditorDeclaration <em>Cell Editor Declaration</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getRowHeaderAxisConfiguration <em>Row Header Axis Configuration</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getColumnHeaderAxisConfiguration <em>Column Header Axis Configuration</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getColumnAxisProviders <em>Column Axis Providers</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getRowAxisProviders <em>Row Axis Providers</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getDefaultRowAxisProvider <em>Default Row Axis Provider</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getDefaultColumnAxisProvider <em>Default Column Axis Provider</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableConfigurationImpl#getOwnedCellEditorConfigurations <em>Owned Cell Editor Configurations</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TableConfigurationImpl extends TableNamedElementImpl implements TableConfiguration {

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getIconPath() <em>Icon Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIconPath()
	 * @generated
	 * @ordered
	 */
	protected static final String ICON_PATH_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getCellEditorDeclaration() <em>Cell Editor Declaration</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCellEditorDeclaration()
	 * @generated
	 * @ordered
	 */
	protected static final CellEditorDeclaration CELL_EDITOR_DECLARATION_EDEFAULT = CellEditorDeclaration.COLUMN;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattableconfigurationPackage.Literals.TABLE_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getType() {
		return (String)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__TYPE - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__TYPE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(String newType) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__TYPE - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__TYPE, newType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getIconPath() {
		return (String)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__ICON_PATH - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__ICON_PATH, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIconPath(String newIconPath) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__ICON_PATH - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__ICON_PATH, newIconPath);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractTableTester getCreationTester() {
		return (AbstractTableTester)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__CREATION_TESTER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCreationTester(AbstractTableTester newCreationTester, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newCreationTester, NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCreationTester(AbstractTableTester newCreationTester) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__CREATION_TESTER, newCreationTester);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CellEditorDeclaration getCellEditorDeclaration() {
		return (CellEditorDeclaration)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCellEditorDeclaration(CellEditorDeclaration newCellEditorDeclaration) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION, newCellEditorDeclaration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TableHeaderAxisConfiguration getRowHeaderAxisConfiguration() {
		return (TableHeaderAxisConfiguration)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRowHeaderAxisConfiguration(TableHeaderAxisConfiguration newRowHeaderAxisConfiguration, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newRowHeaderAxisConfiguration, NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRowHeaderAxisConfiguration(TableHeaderAxisConfiguration newRowHeaderAxisConfiguration) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION, newRowHeaderAxisConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TableHeaderAxisConfiguration getColumnHeaderAxisConfiguration() {
		return (TableHeaderAxisConfiguration)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetColumnHeaderAxisConfiguration(TableHeaderAxisConfiguration newColumnHeaderAxisConfiguration, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newColumnHeaderAxisConfiguration, NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setColumnHeaderAxisConfiguration(TableHeaderAxisConfiguration newColumnHeaderAxisConfiguration) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION, newColumnHeaderAxisConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<AbstractAxisProvider> getColumnAxisProviders() {
		return (EList<AbstractAxisProvider>)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<AbstractAxisProvider> getRowAxisProviders() {
		return (EList<AbstractAxisProvider>)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractAxisProvider getDefaultRowAxisProvider() {
		return (AbstractAxisProvider)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AbstractAxisProvider basicGetDefaultRowAxisProvider() {
		return (AbstractAxisProvider)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefaultRowAxisProvider(AbstractAxisProvider newDefaultRowAxisProvider) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER, newDefaultRowAxisProvider);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractAxisProvider getDefaultColumnAxisProvider() {
		return (AbstractAxisProvider)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AbstractAxisProvider basicGetDefaultColumnAxisProvider() {
		return (AbstractAxisProvider)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefaultColumnAxisProvider(AbstractAxisProvider newDefaultColumnAxisProvider) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER, newDefaultColumnAxisProvider);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICellEditorConfiguration getOwnedCellEditorConfigurations() {
		return (ICellEditorConfiguration)eDynamicGet(NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwnedCellEditorConfigurations(ICellEditorConfiguration newOwnedCellEditorConfigurations, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newOwnedCellEditorConfigurations, NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnedCellEditorConfigurations(ICellEditorConfiguration newOwnedCellEditorConfigurations) {
		eDynamicSet(NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS - ESTATIC_FEATURE_COUNT, NattableconfigurationPackage.Literals.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS, newOwnedCellEditorConfigurations);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER:
				return basicSetCreationTester(null, msgs);
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION:
				return basicSetRowHeaderAxisConfiguration(null, msgs);
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION:
				return basicSetColumnHeaderAxisConfiguration(null, msgs);
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS:
				return ((InternalEList<?>)getColumnAxisProviders()).basicRemove(otherEnd, msgs);
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS:
				return ((InternalEList<?>)getRowAxisProviders()).basicRemove(otherEnd, msgs);
			case NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS:
				return basicSetOwnedCellEditorConfigurations(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NattableconfigurationPackage.TABLE_CONFIGURATION__TYPE:
				return getType();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ICON_PATH:
				return getIconPath();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER:
				return getCreationTester();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION:
				return getCellEditorDeclaration();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION:
				return getRowHeaderAxisConfiguration();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION:
				return getColumnHeaderAxisConfiguration();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS:
				return getColumnAxisProviders();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS:
				return getRowAxisProviders();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER:
				if (resolve) return getDefaultRowAxisProvider();
				return basicGetDefaultRowAxisProvider();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER:
				if (resolve) return getDefaultColumnAxisProvider();
				return basicGetDefaultColumnAxisProvider();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS:
				return getOwnedCellEditorConfigurations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NattableconfigurationPackage.TABLE_CONFIGURATION__TYPE:
				setType((String)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ICON_PATH:
				setIconPath((String)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER:
				setCreationTester((AbstractTableTester)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION:
				setCellEditorDeclaration((CellEditorDeclaration)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION:
				setRowHeaderAxisConfiguration((TableHeaderAxisConfiguration)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION:
				setColumnHeaderAxisConfiguration((TableHeaderAxisConfiguration)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS:
				getColumnAxisProviders().clear();
				getColumnAxisProviders().addAll((Collection<? extends AbstractAxisProvider>)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS:
				getRowAxisProviders().clear();
				getRowAxisProviders().addAll((Collection<? extends AbstractAxisProvider>)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER:
				setDefaultRowAxisProvider((AbstractAxisProvider)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER:
				setDefaultColumnAxisProvider((AbstractAxisProvider)newValue);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS:
				setOwnedCellEditorConfigurations((ICellEditorConfiguration)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NattableconfigurationPackage.TABLE_CONFIGURATION__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ICON_PATH:
				setIconPath(ICON_PATH_EDEFAULT);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER:
				setCreationTester((AbstractTableTester)null);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION:
				setCellEditorDeclaration(CELL_EDITOR_DECLARATION_EDEFAULT);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION:
				setRowHeaderAxisConfiguration((TableHeaderAxisConfiguration)null);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION:
				setColumnHeaderAxisConfiguration((TableHeaderAxisConfiguration)null);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS:
				getColumnAxisProviders().clear();
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS:
				getRowAxisProviders().clear();
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER:
				setDefaultRowAxisProvider((AbstractAxisProvider)null);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER:
				setDefaultColumnAxisProvider((AbstractAxisProvider)null);
				return;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS:
				setOwnedCellEditorConfigurations((ICellEditorConfiguration)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NattableconfigurationPackage.TABLE_CONFIGURATION__TYPE:
				return TYPE_EDEFAULT == null ? getType() != null : !TYPE_EDEFAULT.equals(getType());
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ICON_PATH:
				return ICON_PATH_EDEFAULT == null ? getIconPath() != null : !ICON_PATH_EDEFAULT.equals(getIconPath());
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CREATION_TESTER:
				return getCreationTester() != null;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__CELL_EDITOR_DECLARATION:
				return getCellEditorDeclaration() != CELL_EDITOR_DECLARATION_EDEFAULT;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_HEADER_AXIS_CONFIGURATION:
				return getRowHeaderAxisConfiguration() != null;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_HEADER_AXIS_CONFIGURATION:
				return getColumnHeaderAxisConfiguration() != null;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__COLUMN_AXIS_PROVIDERS:
				return !getColumnAxisProviders().isEmpty();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__ROW_AXIS_PROVIDERS:
				return !getRowAxisProviders().isEmpty();
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_ROW_AXIS_PROVIDER:
				return basicGetDefaultRowAxisProvider() != null;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__DEFAULT_COLUMN_AXIS_PROVIDER:
				return basicGetDefaultColumnAxisProvider() != null;
			case NattableconfigurationPackage.TABLE_CONFIGURATION__OWNED_CELL_EDITOR_CONFIGURATIONS:
				return getOwnedCellEditorConfigurations() != null;
		}
		return super.eIsSet(featureID);
	}
} // TableConfigurationImpl
