/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards;

import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusCDOEditorInput;
import org.eclipse.papyrus.cdo.uml.diagram.internal.ui.wizards.NewModelPage;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.papyrus.uml.diagram.wizards.providers.AbstractNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.InitModelWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;

public class CDONewModelStorageProvider
extends AbstractNewModelStorageProvider {
    private final EventBus bus = new EventBus("NewCDOModelWizard");
    private CreateModelWizard wizard;
    private SelectArchitectureContextPage newDiagramCategoryPage;
    private NewModelPage newModelPage;

    public boolean canHandle(IStructuredSelection initialSelection) {
        for (Object next : initialSelection.toList()) {
            if (CDOUtils.isCDOObject((EObject)((EObject)WizardsHelper.adapt(next, EObject.class)))) {
                return true;
            }
            if (WizardsHelper.adapt(next, CDOCheckout.class) == null) continue;
            return true;
        }
        return false;
    }

    public void init(CreateModelWizard wizard, IStructuredSelection selection) {
        super.init(wizard, selection);
        this.wizard = wizard;
        this.newModelPage = this.createNewModelPage(selection);
        this.createSelectProviderPart();
        CDOCheckout checkout = CDONewModelStorageProvider.getRepository(selection);
        if (checkout != null) {
            this.bus.post((Object)checkout);
        }
        this.newDiagramCategoryPage = this.createNewArchitectureContextPage(selection);
    }

    static CDOCheckout getRepository(IStructuredSelection selection) {
        CDOCheckout result = null;
        if (!selection.isEmpty() && (result = (CDOCheckout)WizardsHelper.adapt((Object)selection.getFirstElement(), CDOCheckout.class)) == null) {
            CDOObject cdo;
            EObject object;
            CDOResourceNode node = (CDOResourceNode)WizardsHelper.adapt((Object)selection.getFirstElement(), CDOResourceNode.class);
            if (node == null && (object = (EObject)WizardsHelper.adapt((Object)selection.getFirstElement(), EObject.class)) != null && (cdo = CDOUtils.getCDOObject((EObject)object)) != null) {
                node = cdo.cdoResource();
            }
            if (node != null) {
                result = CDOExplorerUtil.getCheckout((Object)node.getURI());
            }
        }
        return result;
    }

    public List<? extends IWizardPage> createPages() {
        if (this.newModelPage == null && this.newDiagramCategoryPage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(new WizardPage[]{this.newDiagramCategoryPage, this.newModelPage});
    }

    public SelectArchitectureContextPage getArchitectureContextPage() {
        return this.newDiagramCategoryPage;
    }

    protected NewModelPage createNewModelPage(IStructuredSelection selection) {
        URI uri;
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard()) {
            return null;
        }
        if (this.isCreateFromExistingDomainModel() && (uri = WizardsHelper.getSelectedResourceURI((IStructuredSelection)selection)) != null) {
            uri = uri.trimFileExtension().appendFileExtension(this.wizard.getDiagramFileExtension(null));
            return new NewDiagramForExistingModelPage(selection, this.wizard.getModelKindName(), this.bus, uri.lastSegment());
        }
        return new NewModelPage(selection, this.bus, this.wizard.getModelKindName());
    }

    protected boolean isCreateFromExistingDomainModel() {
        return this.wizard.isInitModelWizard() && ((InitModelWizard)this.wizard).isCreateFromExistingDomainModel();
    }

    public URI createNewModelURI(String categoryId) {
        return this.newModelPage.createNewModelResourceURI();
    }

    public IEditorInput createEditorInput(URI uri) {
        return new PapyrusCDOEditorInput(uri, uri.trimFileExtension().lastSegment());
    }

    private SelectArchitectureContextPage createNewArchitectureContextPage(IStructuredSelection selection) {
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard() || !this.wizard.isPapyrusRootWizard()) {
            return null;
        }
        return new SelectArchitectureContextPage();
    }

    protected static class NewDiagramForExistingModelPage
    extends NewModelPage {
        private final String myDiagramResourceName;

        public NewDiagramForExistingModelPage(IStructuredSelection selection, String modelKindName, EventBus bus, String defaultResourceName) {
            super(selection, bus, modelKindName);
            this.myDiagramResourceName = defaultResourceName;
            this.setTitle(Messages.InitModelWizard_init_papyrus_model);
            this.setDescription(Messages.InitModelWizard_init_papyrus_model_desc);
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setNewResourceName(this.myDiagramResourceName);
        }

        @Override
        protected void validatePage() {
            super.validatePage();
            if (this.getMessageType() < 3 && !this.myDiagramResourceName.equals(this.getNewResourceName())) {
                this.setMessage(NLS.bind((String)Messages.InitModelWizard_diagram_name_is_different_from_domain_model, (Object)this.myDiagramResourceName), 3);
                this.setPageComplete(false);
            }
        }
    }
}

