/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.statushandlers.StatusManager;

public class CheckoutSelectionBlock {
    private final EventBus bus;
    private final Supplier<? extends IRunnableContext> runnableContext;
    private TreeViewer checkoutList;
    private CDOCheckout selectedCheckout;

    public CheckoutSelectionBlock(EventBus bus, Supplier<? extends IRunnableContext> runnableContext) {
        this.bus = bus;
        this.runnableContext = runnableContext;
    }

    public Control createControl(Composite parent) {
        this.checkoutList = CDOCheckoutContentProvider.createTreeViewer((Composite)parent, (Predicate)new Predicate<Object>(){

            @Override
            public boolean test(Object child) {
                if (child instanceof CDOCheckout) {
                    CDOCheckout checkout = (CDOCheckout)child;
                    return !checkout.isReadOnly();
                }
                return false;
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.checkoutList.getControl());
        if (this.selectedCheckout != null) {
            this.checkoutList.setSelection((ISelection)new StructuredSelection((Object)this.selectedCheckout));
            this.selected(this.selectedCheckout);
        }
        this.checkoutList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    if (CheckoutSelectionBlock.this.selectedCheckout != null) {
                        CheckoutSelectionBlock.this.checkoutList.setSelection((ISelection)new StructuredSelection((Object)CheckoutSelectionBlock.this.selectedCheckout));
                    }
                } else {
                    CheckoutSelectionBlock.this.selected((CDOCheckout)sel.getFirstElement());
                }
            }
        });
        CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckout next = cDOCheckoutArray[n2];
            if (next.isOpen()) {
                this.selected(next);
                this.checkoutList.setSelection((ISelection)new StructuredSelection((Object)next));
                break;
            }
            ++n2;
        }
        return this.checkoutList.getControl();
    }

    public void dispose() {
    }

    public void setEnabled(boolean enabled) {
        if (this.checkoutList != null) {
            this.checkoutList.getControl().setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.checkoutList != null && this.checkoutList.getControl().isEnabled();
    }

    void selected(final CDOCheckout checkout) {
        this.selectedCheckout = checkout;
        if (!checkout.isOpen()) {
            try {
                ((IRunnableContext)this.runnableContext.get()).run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CheckoutSelectionBlock_0, (Object)checkout.getLabel()), (int)-1);
                        try {
                            checkout.open();
                            long deadline = System.currentTimeMillis() + 5000L;
                            while (!checkout.isOpen()) {
                                Thread.sleep(250L);
                                if (System.currentTimeMillis() >= deadline) break;
                            }
                            CheckoutSelectionBlock.this.checkoutList.getControl().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!(this).CheckoutSelectionBlock.this.checkoutList.getControl().isDisposed()) {
                                        (this).CheckoutSelectionBlock.this.checkoutList.update((Object)checkout, null);
                                        (this).CheckoutSelectionBlock.this.bus.post((Object)checkout);
                                        CheckoutSelectionBlock.this.selectionChanged();
                                    }
                                }
                            });
                        }
                        finally {
                            sub.done();
                        }
                    }
                });
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.cdo.ui", Messages.CheckoutSelectionBlock_1, (Throwable)e), 2);
            }
        }
        this.bus.post((Object)checkout);
        this.selectionChanged();
    }

    protected void selectionChanged() {
    }

    public void setSelectedCheckout(CDOCheckout checkout) {
        this.selectedCheckout = checkout;
        if (this.checkoutList != null) {
            this.checkoutList.setSelection((ISelection)new StructuredSelection((Object)this.selectedCheckout));
            this.selected(this.selectedCheckout);
        }
    }

    public CDOCheckout getSelectedCheckout() {
        return this.selectedCheckout;
    }
}

