/*****************************************************************************
 * Copyright (c) 2013, 2017 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.cdo.internal.ui.editors;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.om.pref.OMPreference;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IPapyrusPageInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

/**
 * This is the PapyrusCDOEditorInput type. Enjoy.
 */
public class PapyrusCDOEditorInput extends URIEditorInput {

	@SuppressWarnings("restriction")
	private static final OMPreference<Boolean> PREF_REMEMBER_OPEN_EDITORS = org.eclipse.emf.cdo.explorer.ui.bundle.OM.PREF_REMEMBER_OPEN_EDITORS;

	public PapyrusCDOEditorInput(URI uri) {
		this(uri, uri.trimFileExtension().lastSegment());
	}

	public PapyrusCDOEditorInput(URI uri, String name) {
		super(uri, name);
	}
	
	public PapyrusCDOEditorInput(IMemento memento) {
		super(memento);
	}

	@Override
	public URI getURI() {
		return super.getURI();
	}

	@Override
	protected String getBundleSymbolicName() {
		return Activator.PLUGIN_ID;
	}
	
	@Override
	public IPersistableElement getPersistable() {
	    if (PREF_REMEMBER_OPEN_EDITORS.getValue() == Boolean.TRUE)
	    {
	      return this;
	    }

	    return null;
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") Class adapter) {
		if (adapter == URI.class) {
			return getURI();
		}

		return super.getAdapter(adapter);
	}

	/**
	 * A specialization of the CDO editor input that supports specifying editor pages to open in addition.
	 */
	public static class PageInput extends PapyrusCDOEditorInput implements IPapyrusPageInput {

		private static final URI[] NO_URIS = {};

		private final URI[] pageURIs;

		private final boolean closeOtherPages;

		public PageInput(URI uri) {
			this(uri, NO_URIS, false);
		}

		public PageInput(URI uri, URI[] pageURIs, boolean closeOtherPages) {
			super(uri);

			this.pageURIs = pageURIs;
			this.closeOtherPages = closeOtherPages;
		}


		@Override
		public URI[] getPages() {
			return pageURIs;
		}

		@Override
		public boolean closeOtherPages() {
			return closeOtherPages;
		}
	}
}
