/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.hyperlink;

import com.google.common.base.Objects;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.cdo.internal.ui.dialogs.CheckoutBrowseDialog;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CDOResourceHyperlink;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.Messages;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkShell;
import org.eclipse.swt.widgets.Shell;

public class CDOResourceHyperlinkEditorShell
extends AbstractEditHyperlinkShell {
    private boolean usedefaultTooltip = true;
    private CDOResourceHyperlink hyperlink;

    public CDOResourceHyperlinkEditorShell(Shell parentShell) {
        super(parentShell, true);
    }

    public CDOResourceHyperlink getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(CDOResourceHyperlink hyperlink) {
        this.hyperlink = hyperlink;
        this.updateFields();
    }

    protected void contentsCreated() {
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getObjectLabelText().setEditable(false);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        }
        this.updateFields();
    }

    private void updateFields() {
        if (this.hyperlink != null) {
            if (this.getObjectLabelText() != null) {
                this.getObjectLabelText().setText(this.hyperlink.getHyperlink().toString());
            }
            if (this.getTooltipInputText() != null) {
                this.getTooltipInputText().setText(this.hyperlink.getTooltipText());
            }
            if (this.getObjectLabelText() != null && this.getTooltipInputText() != null) {
                this.usedefaultTooltip = Objects.equal((Object)this.getObjectLabelText().getText(), (Object)this.getTooltipInputText().getText());
                this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
                this.getTooltipInputText().setEditable(!this.usedefaultTooltip);
            }
        }
    }

    protected void onSearch() {
        CheckoutBrowseDialog browse = new CheckoutBrowseDialog(this.getShell(), Messages.CDOResourceHyperlinkEditorShell_title, Messages.CDOResourceHyperlinkEditorShell_message, null, 4096);
        browse.setBlockOnOpen(true);
        String initialURIString = this.getObjectLabelText().getText().trim();
        if (!initialURIString.isEmpty()) {
            browse.setInitialURI(URI.createURI((String)initialURIString));
        }
        browse.setNodeTypeFilter(EresourcePackage.Literals.CDO_RESOURCE_LEAF);
        if (browse.open() == 0) {
            URI selected = browse.getSelectedURI();
            if (selected != null) {
                this.getObjectLabelText().setText(selected.toString());
            }
            if (this.usedefaultTooltip) {
                this.getTooltipInputText().setText(selected.toString());
            }
        }
    }

    protected void onUseDefaultTooltip() {
        this.usedefaultTooltip = this.getUseDefaultCheckBox().getSelection();
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        } else {
            this.getTooltipInputText().setEditable(true);
        }
    }

    protected void cancelPressed() {
        this.hyperlink = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.hyperlink == null) {
            this.hyperlink = new CDOResourceHyperlink();
        }
        this.hyperlink.setHyperlink(URI.createURI((String)this.getObjectLabelText().getText().trim()));
        this.hyperlink.setTooltipText(this.getTooltipInputText().getText().trim());
        super.okPressed();
    }
}

