/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.internal.ValidationRegistry;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.validation.ValidationDescriptor;
import org.eclipse.papyrus.moka.ui.validation.ValidationDiagnosticDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public class ValidationUtil {
    private static boolean dialogResult;
    private static Map<String, Boolean> storePreferenceValue;
    private static Set<String> valideRules;

    static {
        storePreferenceValue = new HashMap<String, Boolean>();
        valideRules = new HashSet<String>();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    public static boolean validateModel(EngineConfiguration<?> engineConfiguration, IProgressMonitor monitor, String engineID) {
        Set validationDescriptors = org.eclipse.papyrus.moka.kernel.validation.ValidationRegistry.getInstance().getValidationDescriptors(engineID);
        dialogResult = true;
        if (validationDescriptors != null) {
            Diagnostic diagnostic = ValidationUtil.validate(monitor, (EObject)((Element)engineConfiguration.getExecutionSource()).getModel(), engineID, validationDescriptors);
            List<Object> filteredConstraints = new ArrayList(diagnostic.getChildren());
            filteredConstraints = filteredConstraints.stream().filter(d -> valideRules.contains(d.getSource())).collect(Collectors.toList());
            BasicDiagnostic filteredDiagnostics = new BasicDiagnostic(diagnostic.getSource(), diagnostic.getCode(), filteredConstraints, diagnostic.getMessage(), diagnostic.getData().toArray());
            boolean isThereErrors = filteredDiagnostics.getChildren().stream().anyMatch(d -> d.getSeverity() == 4);
            if (isThereErrors) {
                Display.getDefault().syncExec(new Runnable((Diagnostic)filteredDiagnostics){
                    private final /* synthetic */ Diagnostic val$filteredDiagnostics;
                    {
                        this.val$filteredDiagnostics = diagnostic;
                    }

                    @Override
                    public void run() {
                        ValidationDiagnosticDialog dialog = new ValidationDiagnosticDialog(Display.getCurrent().getActiveShell(), "Moka Validation", "The moka validation detect errors on the model. Do you still want to launch the simulation ?", this.val$filteredDiagnostics, 4);
                        dialogResult = dialog.open() == 0;
                    }
                });
            }
        }
        return dialogResult;
    }

    protected static Diagnostic validate(IProgressMonitor progressMonitor, EObject validateElement, String engineID, Set<ValidationDescriptor> validationDescriptors) {
        ValidationUtil.clear();
        ValidationUtil.setValidationPreferencesForMokaSimulation(engineID, validationDescriptors);
        int validationSteps = 0;
        TreeIterator i = validateElement.eAllContents();
        while (i.hasNext()) {
            ++validationSteps;
            i.next();
        }
        progressMonitor.beginTask("Validate Model", validationSteps);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)validateElement);
        AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
        IPapyrusDiagnostician diagnostician = ValidationRegistry.getDiagnostician((EObject)validateElement);
        diagnostician.initialize(adapterFactory, progressMonitor);
        BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic(validateElement);
        Map context = diagnostician.createDefaultContext();
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(validateElement)}));
        diagnostician.validate(validateElement, (DiagnosticChain)diagnostic, context);
        if (progressMonitor.isCanceled()) {
            return null;
        }
        ValidationUtil.restoreOldPreferences();
        return diagnostic;
    }

    protected static void setValidationPreferencesForMokaSimulation(String engineID, Set<ValidationDescriptor> validationDescriptors) {
        SortedSet categories = CategoryManager.getInstance().getTopLevelCategories();
        for (Category category : categories) {
            ValidationUtil.checkCategory(category, validationDescriptors);
        }
    }

    protected static void checkCategory(Category category, Set<ValidationDescriptor> validDescriptors) {
        boolean categoryFound = false;
        for (ValidationDescriptor validationDescriptor : validDescriptors) {
            if (!validationDescriptor.getCategory().equals(category.getId())) continue;
            for (IConstraintDescriptor constraintDescriptor : category.getConstraints()) {
                ValidationUtil.checkConstraint(constraintDescriptor, validationDescriptor);
            }
            for (Category subCategory : category.getChildren()) {
                if (!ValidationUtil.shouldExcludeSubCategory(subCategory, validationDescriptor)) continue;
                ValidationUtil.excludeCategory(subCategory);
            }
            categoryFound = true;
        }
        if (!categoryFound) {
            ValidationUtil.excludeCategory(category);
        }
    }

    protected static boolean shouldExcludeSubCategory(Category subCategory, ValidationDescriptor validationDescriptor) {
        for (String categoryID : validationDescriptor.getExcludedCategories()) {
            if (!categoryID.equals(subCategory.getId())) continue;
            return true;
        }
        return false;
    }

    protected static void excludeCategory(Category category) {
        for (IConstraintDescriptor constraintDescriptor : category.getConstraints()) {
            ValidationUtil.excludeConstraint(constraintDescriptor);
        }
        for (Category subCategory : category.getChildren()) {
            ValidationUtil.excludeCategory(subCategory);
        }
    }

    protected static void checkConstraint(IConstraintDescriptor constraintDescriptor, ValidationDescriptor validationDescriptor) {
        if (validationDescriptor.getExcludedConstrains().contains(constraintDescriptor.getId())) {
            ValidationUtil.excludeConstraint(constraintDescriptor);
        } else {
            valideRules.add(constraintDescriptor.getId());
        }
    }

    protected static void excludeConstraint(IConstraintDescriptor constraintDescriptor) {
        storePreferenceValue.put(constraintDescriptor.getId(), EMFModelValidationPreferences.isConstraintDisabled((String)constraintDescriptor.getId()));
        EMFModelValidationPreferences.setConstraintDisabled((String)constraintDescriptor.getId(), (boolean)true);
    }

    protected static void restoreOldPreferences() {
        for (Map.Entry<String, Boolean> entry : storePreferenceValue.entrySet()) {
            EMFModelValidationPreferences.setConstraintDisabled((String)entry.getKey(), (boolean)entry.getValue());
        }
    }

    protected static void clear() {
        storePreferenceValue.clear();
        valideRules.clear();
    }
}

