/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.service;

import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.papyrus.moka.debug.communication.MessagesReader;
import org.eclipse.papyrus.moka.debug.messages.DebugRequest;
import org.eclipse.papyrus.moka.debug.messages.ThreadRequest;
import org.eclipse.papyrus.moka.debug.service.DebugService;

public class DebugServiceClientListener
implements IMqttMessageListener {
    protected DebugService<?, ?> debugService;

    public DebugServiceClientListener(DebugService<?, ?> service) {
        assert (service != null);
        this.debugService = service;
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        if (topic.equals("debug-target/thread")) {
            ThreadRequest request = MessagesReader.getThreadRequest(message);
            switch (request.getEventKind()) {
                case 2: {
                    this.debugService.requestSuspendThread(request.getThreadId());
                    break;
                }
                case 1: {
                    this.debugService.requestResumeThread(request.getThreadId());
                    break;
                }
                case 8: {
                    this.debugService.requestTerminateThread(request.getThreadId());
                }
            }
        } else if (topic.equals("debug-target/engine")) {
            DebugRequest request = MessagesReader.getDebugRequest(message);
            switch (request.getEventKind()) {
                case 1: {
                    this.debugService.requestResumeEngine();
                    break;
                }
                case 2: {
                    this.debugService.requestSuspendEngine();
                    break;
                }
                case 8: {
                    this.debugService.requestTerminateEngine();
                }
            }
        }
    }
}

