/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.actions.OutputPinActivation;
import org.eclipse.papyrus.moka.fuml.activities.ActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.ActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.ControlToken;
import org.eclipse.papyrus.moka.fuml.activities.ForkNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IObjectToken;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.activities.ObjectToken;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.actions.AcceptEventActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityEdgeInstanceProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.CallActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ObjectNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.debug.NullTokenPropagationProfiler;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.BooleanValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.ILink;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class ActionActivation
extends ActivityNodeActivation
implements IActionActivation {
    public List<IPinActivation> pinActivations = new ArrayList<IPinActivation>();
    public Boolean firing;

    @Override
    public void run() {
        super.run();
        if (this.outgoingEdges.size() > 0) {
            ((IActivityEdgeInstance)this.outgoingEdges.get(0)).getTarget().run();
        }
        this.firing = false;
    }

    @Override
    public List<IToken> takeOfferedTokens() {
        this.firing = !((Action)this.node).isLocallyReentrant();
        ArrayList<IToken> offeredTokens = new ArrayList<IToken>();
        List incomingEdges = this.incomingEdges;
        int i = 0;
        while (i < incomingEdges.size()) {
            IActivityEdgeInstance incomingEdge;
            IActivityEdgeInstance iActivityEdgeInstance = incomingEdge = (IActivityEdgeInstance)incomingEdges.get(i);
            List list = iActivityEdgeInstance.takeOfferedTokens();
            ActivityEdgeInstanceProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$2$2af4857d(iActivityEdgeInstance, list);
            List tokens = list;
            int j = 0;
            while (j < tokens.size()) {
                IToken token = (IToken)tokens.get(j);
                token.withdraw();
                offeredTokens.add(token);
                ++j;
            }
            ++i;
        }
        Action action = (Action)this.node;
        List<InputPin> inputPins = ActionActivation.getInputs(action);
        for (InputPin pin : inputPins) {
            List tokens;
            IPinActivation pinActivation = this.getPinActivation((Pin)pin);
            List list = tokens = pinActivation.takeOfferedTokens();
            IPinActivation iPinActivation = pinActivation;
            ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityNodeActivationProfiler$1$e1c57393((IActivityNodeActivation)iPinActivation, list);
            iPinActivation.fire(list);
            int j = 0;
            while (j < tokens.size()) {
                IToken token = (IToken)tokens.get(j);
                offeredTokens.add(token);
                ++j;
            }
        }
        return offeredTokens;
    }

    @Override
    public void fire(List<IToken> incomingTokens) {
        do {
            Debug.println("[fire] Action " + this.node.getName() + "...");
            Debug.println("[event] Fire activity=" + this.getActivityExecution().getBehavior().getName() + " action=" + this.node.getName());
            this.doAction();
        } while ((incomingTokens = this.completeAction()).size() > 0);
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.outgoingEdges.size() > 0) {
            ((IActivityEdgeInstance)this.outgoingEdges.get(0)).getTarget().terminate();
        }
    }

    public List<IToken> completeAction() {
        this.sendOffers();
        Debug.println("[fire] Checking if " + this.node.getName() + " should fire again...");
        ActionActivation actionActivation = this;
        ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(actionActivation);
        ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(actionActivation);
        ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(actionActivation);
        PinActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(actionActivation);
        AcceptEventActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(actionActivation);
        CallActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(actionActivation);
        actionActivation._beginIsolation();
        List<Object> incomingTokens = new ArrayList();
        this.firing = false;
        if (this.isReady().booleanValue()) {
            incomingTokens = this.takeOfferedTokens();
            this.firing = this.isFiring() & incomingTokens.size() > 0;
        }
        ActionActivation actionActivation2 = this;
        try {
            try {
                try {
                    try {
                        try {
                            try {
                                actionActivation2._endIsolation();
                            }
                            finally {
                                ActivityEdgeInstanceProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(actionActivation2);
                            }
                        }
                        finally {
                            ActivityNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(actionActivation2);
                        }
                    }
                    finally {
                        ObjectNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(actionActivation2);
                    }
                }
                finally {
                    PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(actionActivation2);
                }
            }
            finally {
                AcceptEventActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(actionActivation2);
            }
        }
        finally {
            CallActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(actionActivation2);
        }
        return incomingTokens;
    }

    @Override
    public Boolean isReady() {
        boolean ready = super.isReady() & (((Action)this.node).isLocallyReentrant() | this.isFiring() == false);
        int i = 1;
        while (ready & i <= this.incomingEdges.size()) {
            ready = ((IActivityEdgeInstance)this.incomingEdges.get(i - 1)).hasOffer();
            ++i;
        }
        List<InputPin> inputPins = ActionActivation.getInputs((Action)this.node);
        int j = 1;
        while (ready & j <= inputPins.size()) {
            ready = this.getPinActivation((Pin)inputPins.get(j - 1)).isReady();
            ++j;
        }
        return ready;
    }

    public Boolean isFiring() {
        return this.firing == null ? false : this.firing;
    }

    public abstract void doAction();

    public void sendOffers() {
        Action action = (Action)this.node;
        List<OutputPin> outputPins = ActionActivation.getOutputs(action);
        for (OutputPin outputPin : outputPins) {
            IPinActivation pinActivation = this.getPinActivation((Pin)outputPin);
            pinActivation.sendUnofferedTokens();
        }
        if (this.outgoingEdges.size() > 0) {
            ArrayList<IToken> tokens = new ArrayList<IToken>();
            tokens.add(new ControlToken());
            ArrayList<IToken> arrayList = tokens;
            ActionActivation actionActivation = this;
            try {
                actionActivation.addTokens(arrayList);
            }
            finally {
                if (actionActivation instanceof IPinActivation) {
                    PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$1$44250678((IPinActivation)actionActivation, arrayList);
                }
            }
            ArrayList<IToken> arrayList2 = tokens;
            IActivityEdgeInstance iActivityEdgeInstance = (IActivityEdgeInstance)this.outgoingEdges.get(0);
            ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$1$49177e35(iActivityEdgeInstance, arrayList2);
            iActivityEdgeInstance.sendOffer(arrayList2);
        }
    }

    @Override
    public void createNodeActivations() {
        Action action = (Action)this.node;
        ArrayList<InputPin> inputPinNodes = new ArrayList<InputPin>();
        List<InputPin> inputPins = ActionActivation.getInputs(action);
        int i = 0;
        while (i < inputPins.size()) {
            InputPin inputPin = inputPins.get(i);
            inputPinNodes.add(inputPin);
            ++i;
        }
        this.group.createNodeActivations(inputPinNodes);
        i = 0;
        while (i < inputPinNodes.size()) {
            ActivityNode node = (ActivityNode)inputPinNodes.get(i);
            this.addPinActivation((IPinActivation)this.group.getNodeActivation(node));
            ++i;
        }
        ArrayList<OutputPin> outputPinNodes = new ArrayList<OutputPin>();
        List<OutputPin> outputPins = ActionActivation.getOutputs(action);
        int i2 = 0;
        while (i2 < outputPins.size()) {
            OutputPin outputPin = outputPins.get(i2);
            outputPinNodes.add(outputPin);
            ++i2;
        }
        this.group.createNodeActivations(outputPinNodes);
        i2 = 0;
        while (i2 < outputPinNodes.size()) {
            ActivityNode node = (ActivityNode)outputPinNodes.get(i2);
            this.addPinActivation((IPinActivation)this.group.getNodeActivation(node));
            ++i2;
        }
    }

    @Override
    public void addOutgoingEdge(IActivityEdgeInstance edge) {
        ForkNodeActivation forkNodeActivation;
        if (this.outgoingEdges.size() == 0) {
            forkNodeActivation = new ForkNodeActivation();
            forkNodeActivation.setRunning(false);
            ActivityEdgeInstance newEdge = new ActivityEdgeInstance();
            super.addOutgoingEdge(newEdge);
            forkNodeActivation.addIncomingEdge(newEdge);
        } else {
            forkNodeActivation = ((IActivityEdgeInstance)this.outgoingEdges.get(0)).getTarget();
        }
        forkNodeActivation.addOutgoingEdge(edge);
    }

    public void addPinActivation(IPinActivation pinActivation) {
        this.pinActivations.add(pinActivation);
        pinActivation.setActionActivation((IActionActivation)this);
    }

    public IPinActivation getPinActivation(Pin pin) {
        IPinActivation pinActivation = null;
        int i = 1;
        while (pinActivation == null & i <= this.pinActivations.size()) {
            IPinActivation thisPinActivation = this.pinActivations.get(i - 1);
            if (thisPinActivation.getNode() == pin) {
                pinActivation = thisPinActivation;
            }
            ++i;
        }
        return pinActivation;
    }

    public void putToken(OutputPin pin, IValue value) {
        Debug.println("[putToken] node = " + this.node.getName());
        ObjectToken token = new ObjectToken();
        token.setValue(value);
        IPinActivation pinActivation = this.getPinActivation((Pin)pin);
        pinActivation.addToken((IToken)token);
    }

    public void putTokens(OutputPin pin, List<IValue> values) {
        int i = 0;
        while (i < values.size()) {
            IValue value = values.get(i);
            this.putToken(pin, value);
            ++i;
        }
    }

    public List<IValue> getTokens(InputPin pin) {
        IPinActivation pinActivation;
        Debug.println("[getTokens] node = " + this.node.getName() + ", pin = " + pin.getName());
        IPinActivation iPinActivation = pinActivation = this.getPinActivation((Pin)pin);
        List list = iPinActivation.getUnofferedTokens();
        if (iPinActivation instanceof OutputPinActivation) {
            NullTokenPropagationProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_debug_NullTokenPropagationProfiler$1$83831986((OutputPinActivation)iPinActivation, list);
        }
        List tokens = list;
        ArrayList<IValue> values = new ArrayList<IValue>();
        int i = 0;
        while (i < tokens.size()) {
            IToken token = (IToken)tokens.get(i);
            IValue value = ((IObjectToken)token).getValue();
            if (value != null) {
                values.add(value);
            }
            ++i;
        }
        return values;
    }

    public List<IValue> takeTokens(InputPin pin) {
        Debug.println("[takeTokens] node = " + this.node.getName() + ", pin = " + pin.getName());
        IPinActivation pinActivation = this.getPinActivation((Pin)pin);
        List tokens = pinActivation.takeUnofferedTokens();
        ArrayList<IValue> values = new ArrayList<IValue>();
        int i = 0;
        while (i < tokens.size()) {
            IToken token = (IToken)tokens.get(i);
            IValue value = ((IObjectToken)token).getValue();
            if (value != null) {
                values.add(value);
            }
            ++i;
        }
        return values;
    }

    @Override
    public Boolean isSourceFor(IActivityEdgeInstance edgeInstance) {
        boolean isSource = false;
        if (this.outgoingEdges.size() > 0) {
            isSource = ((IActivityEdgeInstance)this.outgoingEdges.get(0)).getTarget().isSourceFor(edgeInstance);
        }
        return isSource;
    }

    public Boolean valueParticipatesInLink(IValue value, ILink link) {
        List linkFeatureValues = link.getFeatureValues();
        boolean participates = false;
        int i = 1;
        while (!participates & i <= linkFeatureValues.size()) {
            participates = ((IValue)((IFeatureValue)linkFeatureValues.get(i - 1)).getValues().get(0)).equals(value);
            ++i;
        }
        return participates;
    }

    public BooleanValue makeBooleanValue(Boolean value) {
        LiteralBoolean booleanLiteral = UMLFactory.eINSTANCE.createLiteralBoolean();
        booleanLiteral.setValue(value.booleanValue());
        return (BooleanValue)this.getExecutionLocus().getExecutor().evaluate((ValueSpecification)booleanLiteral);
    }

    @Override
    public void initialize(ActivityNode node, IActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.firing = false;
    }

    protected static List<InputPin> getInputs(Action action) {
        return action instanceof LoopNode ? ((LoopNode)action).getLoopVariableInputs() : action.getInputs();
    }

    protected static List<OutputPin> getOutputs(Action action) {
        return action instanceof LoopNode ? ((LoopNode)action).getResults() : (action instanceof ConditionalNode ? ((ConditionalNode)action).getResults() : action.getOutputs());
    }
}

