/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.papyrus.infra.emf.expressions.ExpressionsPackage;

import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsPackage;

import org.eclipse.papyrus.model2doc.core.author.AuthorPackage;

import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesPackage;

import org.eclipse.papyrus.model2doc.core.generatorconfiguration.GeneratorConfigurationPackage;

import org.eclipse.papyrus.model2doc.core.styles.StylesPackage;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;

import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage;

import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.MarkupUMLDocumentStructureTemplateFactory;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.MarkupUMLDocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.StereotypePropertyAttributeInMarkupToFile;

import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.UMLDocumentStructureTemplatePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 *
 * @generated
 */
public class MarkupUMLDocumentStructureTemplatePackageImpl extends EPackageImpl implements MarkupUMLDocumentStructureTemplatePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EClass stereotypePropertyAttributeInMarkupToFileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EClass iMarkupUMLBodyPartTemplateTitleEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EClass commentInMarkupToFileEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.MarkupUMLDocumentStructureTemplatePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MarkupUMLDocumentStructureTemplatePackageImpl() {
		super(eNS_URI, MarkupUMLDocumentStructureTemplateFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link MarkupUMLDocumentStructureTemplatePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MarkupUMLDocumentStructureTemplatePackage init() {
		if (isInited) {
			return (MarkupUMLDocumentStructureTemplatePackage) EPackage.Registry.INSTANCE.getEPackage(MarkupUMLDocumentStructureTemplatePackage.eNS_URI);
		}

		// Obtain or create and register package
		Object registeredMarkupUMLDocumentStructureTemplatePackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		MarkupUMLDocumentStructureTemplatePackageImpl theMarkupUMLDocumentStructureTemplatePackage = registeredMarkupUMLDocumentStructureTemplatePackage instanceof MarkupUMLDocumentStructureTemplatePackageImpl
				? (MarkupUMLDocumentStructureTemplatePackageImpl) registeredMarkupUMLDocumentStructureTemplatePackage
				: new MarkupUMLDocumentStructureTemplatePackageImpl();

		isInited = true;

		// Initialize simple dependencies
		AuthorPackage.eINSTANCE.eClass();
		BuiltInTypesPackage.eINSTANCE.eClass();
		DocumentStructureTemplatePackage.eINSTANCE.eClass();
		EcorePackage.eINSTANCE.eClass();
		GeneratorConfigurationPackage.eINSTANCE.eClass();
		MarkupEMFDocumentStructureTemplatePackage.eINSTANCE.eClass();
		StylesPackage.eINSTANCE.eClass();
		UMLDocumentStructureTemplatePackage.eINSTANCE.eClass();
		BooleanExpressionsPackage.eINSTANCE.eClass();
		ExpressionsPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theMarkupUMLDocumentStructureTemplatePackage.createPackageContents();

		// Initialize created meta-data
		theMarkupUMLDocumentStructureTemplatePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theMarkupUMLDocumentStructureTemplatePackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(MarkupUMLDocumentStructureTemplatePackage.eNS_URI, theMarkupUMLDocumentStructureTemplatePackage);
		return theMarkupUMLDocumentStructureTemplatePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EClass getStereotypePropertyAttributeInMarkupToFile() {
		return stereotypePropertyAttributeInMarkupToFileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EClass getIMarkupUMLBodyPartTemplateTitle() {
		return iMarkupUMLBodyPartTemplateTitleEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EClass getCommentInMarkupToFile() {
		return commentInMarkupToFileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getCommentInMarkupToFile_CommentChoice() {
		return (EAttribute) commentInMarkupToFileEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EOperation getCommentInMarkupToFile__GetMatchingComments__EObject() {
		return commentInMarkupToFileEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public MarkupUMLDocumentStructureTemplateFactory getMarkupUMLDocumentStructureTemplateFactory() {
		return (MarkupUMLDocumentStructureTemplateFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		stereotypePropertyAttributeInMarkupToFileEClass = createEClass(STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE);

		iMarkupUMLBodyPartTemplateTitleEClass = createEClass(IMARKUP_UML_BODY_PART_TEMPLATE_TITLE);

		commentInMarkupToFileEClass = createEClass(COMMENT_IN_MARKUP_TO_FILE);
		createEAttribute(commentInMarkupToFileEClass, COMMENT_IN_MARKUP_TO_FILE__COMMENT_CHOICE);
		createEOperation(commentInMarkupToFileEClass, COMMENT_IN_MARKUP_TO_FILE___GET_MATCHING_COMMENTS__EOBJECT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		UMLDocumentStructureTemplatePackage theUMLDocumentStructureTemplatePackage = (UMLDocumentStructureTemplatePackage) EPackage.Registry.INSTANCE.getEPackage(UMLDocumentStructureTemplatePackage.eNS_URI);
		DocumentStructureTemplatePackage theDocumentStructureTemplatePackage = (DocumentStructureTemplatePackage) EPackage.Registry.INSTANCE.getEPackage(DocumentStructureTemplatePackage.eNS_URI);
		MarkupEMFDocumentStructureTemplatePackage theMarkupEMFDocumentStructureTemplatePackage = (MarkupEMFDocumentStructureTemplatePackage) EPackage.Registry.INSTANCE.getEPackage(MarkupEMFDocumentStructureTemplatePackage.eNS_URI);
		EcorePackage theEcorePackage = (EcorePackage) EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		stereotypePropertyAttributeInMarkupToFileEClass.getESuperTypes().add(theUMLDocumentStructureTemplatePackage.getStereotypePropertyTemplate());
		stereotypePropertyAttributeInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getITemplatePartView());
		stereotypePropertyAttributeInMarkupToFileEClass.getESuperTypes().add(theUMLDocumentStructureTemplatePackage.getStereotypePropertyAttribute());
		stereotypePropertyAttributeInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getILeafBodyPartTemplate());
		stereotypePropertyAttributeInMarkupToFileEClass.getESuperTypes().add(this.getIMarkupUMLBodyPartTemplateTitle());
		iMarkupUMLBodyPartTemplateTitleEClass.getESuperTypes().add(theMarkupEMFDocumentStructureTemplatePackage.getIMarkupToFileBodyPartTemplate());
		iMarkupUMLBodyPartTemplateTitleEClass.getESuperTypes().add(theUMLDocumentStructureTemplatePackage.getIUMLBodyPartTemplateTitle());
		commentInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getITemplatePartView());
		commentInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getILeafBodyPartTemplate());
		commentInMarkupToFileEClass.getESuperTypes().add(this.getIMarkupUMLBodyPartTemplateTitle());

		// Initialize classes, features, and operations; add parameters
		initEClass(stereotypePropertyAttributeInMarkupToFileEClass, StereotypePropertyAttributeInMarkupToFile.class, "StereotypePropertyAttributeInMarkupToFile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

		initEClass(iMarkupUMLBodyPartTemplateTitleEClass, IMarkupUMLBodyPartTemplateTitle.class, "IMarkupUMLBodyPartTemplateTitle", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

		initEClass(commentInMarkupToFileEClass, CommentInMarkupToFile.class, "CommentInMarkupToFile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
		initEAttribute(getCommentInMarkupToFile_CommentChoice(), theUMLDocumentStructureTemplatePackage.getCommentChoice(), "commentChoice", "FIRST_OWNED_COMMENT", 1, 1, CommentInMarkupToFile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, //$NON-NLS-1$ //$NON-NLS-2$
				!IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		EOperation op = initEOperation(getCommentInMarkupToFile__GetMatchingComments__EObject(), theUMLDocumentStructureTemplatePackage.getComment(), "getMatchingComments", 0, -1, IS_UNIQUE, !IS_ORDERED); //$NON-NLS-1$
		addEParameter(op, theEcorePackage.getEObject(), "element", 1, 1, IS_UNIQUE, !IS_ORDERED); //$NON-NLS-1$

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/uml2/2.0.0/UML
		createUMLAnnotations();
		// duplicates
		createDuplicatesAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/uml2/2.0.0/UML</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void createUMLAnnotations() {
		String source = "http://www.eclipse.org/uml2/2.0.0/UML"; //$NON-NLS-1$
		addAnnotation(this,
				source,
				new String[] {
						"originalName", "markupumldocumentstructuretemplate" //$NON-NLS-1$ //$NON-NLS-2$
				});
	}

	/**
	 * Initializes the annotations for <b>duplicates</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void createDuplicatesAnnotations() {
		String source = "duplicates"; //$NON-NLS-1$
		addAnnotation(iMarkupUMLBodyPartTemplateTitleEClass,
				source,
				new String[] {
				});
	}

} // MarkupUMLDocumentStructureTemplatePackageImpl
