/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.markup.uml.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.InsertedGeneratedFile;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.markup.emf.template2structure.mapping.AbstractMarkdownToHtmlFileMapper;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.MarkupUMLDocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.StereotypePropertyAttributeInMarkupToFile;

public class StereotypePropertyAttributeInMarkupToHtmlFileMapper
extends AbstractMarkdownToHtmlFileMapper<StereotypePropertyAttributeInMarkupToFile> {
    public StereotypePropertyAttributeInMarkupToHtmlFileMapper() {
        super(MarkupUMLDocumentStructureTemplatePackage.eINSTANCE.getStereotypePropertyAttributeInMarkupToFile(), BodyPart.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, StereotypePropertyAttributeInMarkupToFile documentTemplateElement, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        if (!documentTemplateElement.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!documentTemplateElement.isGenerate() || !(semanticModelElement instanceof EObject)) {
            return Collections.emptyList();
        }
        EList eAttributeValues = documentTemplateElement.getStereotypePropertyValues(semanticModelElement);
        ArrayList<T> generatedElements = new ArrayList<T>();
        String elementID = StereotypePropertyAttributeInMarkupToHtmlFileMapper.getXMIID((EObject)semanticModelElement);
        String eattributeName = documentTemplateElement.getPropertyName();
        int index = 0;
        Iterator eAttributeValuesIter = eAttributeValues.iterator();
        while (eAttributeValuesIter.hasNext()) {
            InsertedGeneratedFile generatedFile = STRUCTURE_EFACTORY.createInsertedGeneratedFile();
            Object value = eAttributeValuesIter.next();
            if (value == null) {
                value = "";
            }
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(elementID).append("_").append(eattributeName);
            if (eAttributeValues.size() > 1) {
                fileNameBuilder.append("_");
                fileNameBuilder.append(index++);
            }
            generatedFile.setFilePath(this.createHTMLFile((IBodySectionPartTemplate)documentTemplateElement, value.toString(), fileNameBuilder.toString()));
            generatedElements.add(expectedReturnedClass.cast(generatedFile));
        }
        return this.buildMapperResult((IBodySectionPartTemplate)documentTemplateElement, semanticModelElement, expectedReturnedClass, generatedElements);
    }
}

