/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.requirementsextension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VerificationMethodKind implements Enumerator
{
    ANALYSIS(0, "Analysis", "Analysis"),
    DEMONSTRATION(1, "Demonstration", "Demonstration"),
    INSPECTION(2, "Inspection", "Inspection"),
    TEST(3, "Test", "Test");

    public static final int ANALYSIS_VALUE = 0;
    public static final int DEMONSTRATION_VALUE = 1;
    public static final int INSPECTION_VALUE = 2;
    public static final int TEST_VALUE = 3;
    private static final VerificationMethodKind[] VALUES_ARRAY;
    public static final List<VerificationMethodKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VerificationMethodKind[]{ANALYSIS, DEMONSTRATION, INSPECTION, TEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VerificationMethodKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerificationMethodKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerificationMethodKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerificationMethodKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerificationMethodKind get(int value) {
        switch (value) {
            case 0: {
                return ANALYSIS;
            }
            case 1: {
                return DEMONSTRATION;
            }
            case 2: {
                return INSPECTION;
            }
            case 3: {
                return TEST;
            }
        }
        return null;
    }

    private VerificationMethodKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

