/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.matrix.cell.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsFactory;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.IBooleanEObjectExpression;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IGenericMatrixRelationshipCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.MatrixRelationShipDirection;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.IWrapper;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.ui.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.uml.nattable.matrix.Activator;
import org.eclipse.papyrus.uml.nattable.matrix.messages.Messages;
import org.eclipse.papyrus.uml.nattable.matrix.validator.RelationshipOwnerValidator;
import org.eclipse.papyrus.uml.tools.helper.UMLRelationshipHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractUMLGenericMatrixRelationshipCellManager
extends AbstractCellManager
implements IGenericMatrixRelationshipCellManager {
    private EClass managedElement;
    protected UMLRelationshipHelper helper;
    private IBooleanEObjectExpression defaultFilter = BooleanExpressionsFactory.eINSTANCE.createLiteralTrueExpression();

    public AbstractUMLGenericMatrixRelationshipCellManager(EClass managedElement) {
        this.managedElement = managedElement;
        this.helper = this.getOrCreateUMLRelationshipHelper();
    }

    protected UMLRelationshipHelper getOrCreateUMLRelationshipHelper() {
        if (this.helper == null) {
            this.helper = new UMLRelationshipHelper();
        }
        return this.helper;
    }

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager manager) {
        boolean handle;
        boolean bl = handle = manager instanceof IMatrixTableWidgetManager && this.isMatchingEditedElement(manager.getTable()) && manager.getTable().getContext() instanceof Element;
        if (handle) {
            boolean bl2 = handle = this.getElementTypeToCreate(this.getCellEditorConfiguration((IMatrixTableWidgetManager)manager)) != null;
        }
        if (handle) {
            Object realColumn = AxisUtils.getRepresentedElement((Object)columnElement);
            Object realRow = AxisUtils.getRepresentedElement((Object)rowElement);
            handle = realColumn instanceof Element && realRow instanceof Element;
        }
        return handle;
    }

    public final boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager manager) {
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        boolean isEditable = this.isCellEditableIgnoringCurrentValue(columnElement, rowElement, manager);
        if (isEditable) {
            List<Element> currentValues = this.getMatchingRelationships(realColumn, realRow, manager);
            boolean bl = isEditable = currentValues.size() < 2;
            if (currentValues.size() == 1 && this.canHaveMoreThan2Ends()) {
                boolean bl2 = isEditable = this.getNumberOfEnds(currentValues.get(0)) == 2;
            }
        }
        if (isEditable) {
            Command cmd = this.getSetValueCommand(TableEditingDomainUtils.getTableContextEditingDomain((Table)manager.getTable()), columnElement, rowElement, (Object)Boolean.TRUE, manager, true);
            isEditable = cmd == null ? false : cmd.canExecute();
        }
        return isEditable;
    }

    protected final boolean isCellEditableIgnoringCurrentValue(Object columnElement, Object rowElement, INattableModelManager manager) {
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        IMatrixTableWidgetManager matrixManager = (IMatrixTableWidgetManager)manager;
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration(matrixManager);
        boolean isEditable = false;
        switch (conf.getDirection()) {
            case NONE: {
                if (this.isDirectedRelationship()) {
                    isEditable = false;
                    break;
                }
                isEditable = this.matchingSourceFeatureType(realRow) && this.matchingTargetFeatureType(realColumn) && this.matchingSourceFeatureType(realColumn) && this.matchingTargetFeatureType(realRow);
                break;
            }
            case FROM_ROW_TO_COLUMN: {
                isEditable = this.matchingSourceFeatureType(realRow) && this.matchingTargetFeatureType(realColumn);
                break;
            }
            case FROM_COLUMN_TO_ROW: {
                isEditable = this.matchingSourceFeatureType(realColumn) && this.matchingTargetFeatureType(realRow);
                break;
            }
        }
        return isEditable;
    }

    protected boolean matchingSourceFeatureType(Object element) {
        return this.getRelationshipSourceFeature().getEType().isInstance(element);
    }

    protected boolean matchingTargetFeatureType(Element element) {
        return this.getRelationshipTargetFeature().getEType().isInstance((Object)element);
    }

    private final Element getBestOwner(IMatrixTableWidgetManager tableManager, ElementTypeConfiguration elementTypeConfiguration, Element source, Element target, EObject context) {
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration(tableManager);
        if (conf != null) {
            switch (conf.getRelationshipOwnerStrategy()) {
                case ROW_AS_OWNER: {
                    return source;
                }
                case ROW_OWNER: {
                    return source.getOwner();
                }
                case COLUMN_AS_OWNER: {
                    return target;
                }
                case COLUMN_OWNER: {
                    return target.getOwner();
                }
                case TABLE_CONTEXT: {
                    return (Element)context;
                }
                case OTHER: {
                    IWrapper wrapper = conf.getRelationshipOwner();
                    if (wrapper != null && wrapper.getElement() instanceof Element) {
                        return (Element)wrapper.getElement();
                    }
                    return null;
                }
            }
        }
        return this.helper.getBestOwner(elementTypeConfiguration, source, target, (Element)context);
    }

    protected Element getBestOwner(ElementTypeConfiguration elementTypeConfiguration, Element source, Element target, EObject context) {
        return this.helper.getBestOwner(elementTypeConfiguration, source, target, (Element)context);
    }

    protected IElementType getElementTypeToCreate(GenericRelationshipMatrixCellEditorConfiguration configuration) {
        ElementTypeConfiguration editedElement = configuration.getEditedElement();
        if (editedElement != null) {
            return ElementTypeRegistry.getInstance().getType(editedElement.getIdentifier());
        }
        return null;
    }

    protected IElementMatcher getElementTypeMatcher(GenericRelationshipMatrixCellEditorConfiguration configuration) {
        IElementType elementType = this.getElementTypeToCreate(configuration);
        return elementType instanceof ISpecializationType ? ((ISpecializationType)elementType).getMatcher() : null;
    }

    protected boolean canHaveMoreThan2Ends() {
        return this.helper.canHaveMoreThan2Ends(this.managedElement);
    }

    protected boolean isDirectedRelationship() {
        return this.helper.isDirectedRelationship(this.managedElement);
    }

    protected final boolean isMatchingEditedElement(Table table) {
        ElementTypeConfiguration elTypeConf = this.getEditedElementKind(table);
        return this.handles(elTypeConf);
    }

    protected final boolean handles(ElementTypeConfiguration elTypeConf) {
        if (elTypeConf instanceof MetamodelTypeConfiguration) {
            return ((MetamodelTypeConfiguration)elTypeConf).getEClass() == this.managedElement;
        }
        if (elTypeConf instanceof SpecializationTypeConfiguration && ((SpecializationTypeConfiguration)elTypeConf).getSpecializedTypes().size() == 1) {
            return this.handles((ElementTypeConfiguration)((SpecializationTypeConfiguration)elTypeConf).getSpecializedTypes().get(0));
        }
        return false;
    }

    protected final boolean hasGenericRelationshipMatrixCellEditorConfiguration(IMatrixTableWidgetManager manager) {
        return this.getCellEditorConfiguration(manager) != null;
    }

    protected final GenericRelationshipMatrixCellEditorConfiguration getCellEditorConfiguration(IMatrixTableWidgetManager manager) {
        ICellEditorConfiguration conf = manager.getTable().getOwnedCellEditorConfigurations();
        if (conf instanceof GenericRelationshipMatrixCellEditorConfiguration) {
            return (GenericRelationshipMatrixCellEditorConfiguration)conf;
        }
        return null;
    }

    protected ElementTypeConfiguration getEditedElementKind(Table table) {
        ICellEditorConfiguration conf = table.getOwnedCellEditorConfigurations();
        if (conf instanceof GenericRelationshipMatrixCellEditorConfiguration) {
            return ((GenericRelationshipMatrixCellEditorConfiguration)conf).getEditedElement();
        }
        return null;
    }

    protected EStructuralFeature getRelationshipSourceFeature() {
        return this.helper.getRelationshipSourceFeature(this.managedElement);
    }

    protected EStructuralFeature getRelationshipTargetFeature() {
        return this.helper.getRelationshipTargetFeature(this.managedElement);
    }

    protected Collection<? extends Element> getSources(Element relationship) {
        return this.helper.getSources(relationship);
    }

    protected Collection<? extends Element> getTargets(Element relationship) {
        return this.helper.getTargets(relationship);
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.isCellEditableIgnoringCurrentValue(columnElement, rowElement, tableManager)) {
            return this.getMatchingRelationships((Element)AxisUtils.getRepresentedElement((Object)columnElement), (Element)AxisUtils.getRepresentedElement((Object)rowElement), tableManager);
        }
        return CellHelper.getUnsupportedCellContentsText();
    }

    protected List<Element> getMatchingRelationships(Element columnElement, Element rowElement, INattableModelManager tableManager) {
        Object realColumn = AxisUtils.getRepresentedElement((Object)columnElement);
        Object realRow = AxisUtils.getRepresentedElement((Object)rowElement);
        IMatrixTableWidgetManager matrixManager = (IMatrixTableWidgetManager)tableManager;
        ArrayList<Object> combined = new ArrayList<Object>();
        combined.add(realColumn);
        combined.add(realRow);
        Map refs = EcoreUtil.CrossReferencer.find(combined);
        ArrayList<Element> matchingRelationships = new ArrayList<Element>();
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration(matrixManager);
        MatrixRelationShipDirection dir = conf.getDirection();
        IBooleanEObjectExpression cellContentFilter = conf.getCellContentsFilter();
        if (cellContentFilter == null) {
            cellContentFilter = this.defaultFilter;
        }
        for (Element current : refs.keySet().stream().filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList())) {
            boolean isValid;
            IElementMatcher matcher = this.getElementTypeMatcher(conf);
            boolean bl = isValid = matcher != null ? matcher.matches((EObject)current) : true;
            if (isValid) {
                boolean bl2 = isValid = current.eClass() == this.getManagedRelationship() && (Boolean)cellContentFilter.evaluate((Object)current) != false;
            }
            if (isValid) {
                switch (dir) {
                    case NONE: {
                        break;
                    }
                    case FROM_ROW_TO_COLUMN: {
                        isValid = this.getSources(current).contains(realRow) && this.getTargets(current).contains(realColumn);
                        break;
                    }
                    case FROM_COLUMN_TO_ROW: {
                        isValid = this.getSources(current).contains(realColumn) && this.getTargets(current).contains(realRow);
                        break;
                    }
                }
            }
            if (!isValid) continue;
            matchingRelationships.add(current);
        }
        return matchingRelationships;
    }

    protected int getNumberOfEnds(Element relationship) {
        return this.helper.getNumberOfEnds(relationship);
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Element owner;
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration((IMatrixTableWidgetManager)tableManager);
        MatrixRelationShipDirection dir = conf.getDirection();
        EObject tableContext = tableManager.getTable().getContext();
        switch (dir) {
            case FROM_ROW_TO_COLUMN: {
                owner = this.getBestOwner((IMatrixTableWidgetManager)tableManager, conf.getEditedElement(), realRow, realColumn, tableContext);
                break;
            }
            case FROM_COLUMN_TO_ROW: {
                owner = this.getBestOwner((IMatrixTableWidgetManager)tableManager, conf.getEditedElement(), realColumn, realRow, tableContext);
                break;
            }
            default: {
                owner = null;
            }
        }
        return this.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager, (EObject)owner);
    }

    private final Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager, boolean usePapyrusDefaultOwner) {
        Element owner;
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration((IMatrixTableWidgetManager)tableManager);
        MatrixRelationShipDirection dir = conf.getDirection();
        EObject tableContext = tableManager.getTable().getContext();
        switch (dir) {
            case FROM_ROW_TO_COLUMN: {
                owner = usePapyrusDefaultOwner ? this.getBestOwner(conf.getEditedElement(), realRow, realColumn, tableContext) : this.getBestOwner((IMatrixTableWidgetManager)tableManager, conf.getEditedElement(), realRow, realColumn, tableContext);
                break;
            }
            case FROM_COLUMN_TO_ROW: {
                owner = usePapyrusDefaultOwner ? this.getBestOwner(conf.getEditedElement(), realColumn, realRow, tableContext) : this.getBestOwner((IMatrixTableWidgetManager)tableManager, conf.getEditedElement(), realColumn, realRow, tableContext);
                break;
            }
            default: {
                owner = null;
            }
        }
        return this.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager, (EObject)owner);
    }

    private final Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager, EObject owner) {
        List<Element> r;
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        if (Boolean.FALSE.equals(newValue) && (r = this.getMatchingRelationships(realColumn, realRow, tableManager)).size() == 1) {
            DestroyElementRequest request = new DestroyElementRequest((EObject)r.get(0), false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)((EObject)r.get(0)));
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            if (cmd != null && cmd.canExecute()) {
                return new GMFtoEMFCommandWrapper(cmd);
            }
        }
        if (Boolean.TRUE.equals(newValue)) {
            CreateRelationshipRequest request;
            IMatrixTableWidgetManager matrixManager = (IMatrixTableWidgetManager)tableManager;
            GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration(matrixManager);
            MatrixRelationShipDirection dir = conf.getDirection();
            IElementType elementType = this.getElementTypeToCreate(conf);
            switch (dir) {
                case FROM_ROW_TO_COLUMN: {
                    request = new CreateRelationshipRequest(owner, (EObject)realRow, (EObject)realColumn, elementType);
                    break;
                }
                case FROM_COLUMN_TO_ROW: {
                    request = new CreateRelationshipRequest(owner, (EObject)realColumn, (EObject)realRow, elementType);
                    break;
                }
                default: {
                    request = null;
                }
            }
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)owner);
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            RelationshipOwnerValidator validator = new RelationshipOwnerValidator(matrixManager);
            IStatus validationStatus = validator.validate(owner);
            if (!validationStatus.isOK()) {
                ILabelProvider labelProvider = this.getLabelProvider((EObject)realRow);
                String rowLabel = labelProvider != null ? labelProvider.getText((Object)realRow) : realRow.toString();
                String columnLabel = labelProvider != null ? labelProvider.getText((Object)realColumn) : realColumn.toString();
                String ownerLabel = labelProvider != null ? labelProvider.getText((Object)owner) : owner.toString();
                String str = NLS.bind((String)Messages.AbstractUMLGenericMatrixRelationshipCellManager_RelationshipCanBeCreated, (Object[])new String[]{elementType.getDisplayName(), rowLabel, columnLabel, ownerLabel, validationStatus.getMessage()});
                return new GMFtoEMFCommandWrapper((ICommand)new OpenMessageDialogCommand(domain, Messages.AbstractUMLGenericMatrixRelationshipCellManager_CreateRelationshipMessageDialogTitle, str, 1));
            }
            if (cmd != null && cmd.canExecute()) {
                return new GMFtoEMFCommandWrapper(cmd);
            }
        }
        return null;
    }

    private final ILabelProvider getLabelProvider(EObject eobject) {
        LabelProviderService lpSvc = null;
        try {
            lpSvc = eobject.eResource() != null ? (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)eobject) : (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)NestedEditingDialogContext.getInstance().getResourceSet());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (lpSvc != null) {
            return lpSvc.getLabelProvider();
        }
        return null;
    }

    public EClass getManagedRelationship() {
        return this.managedElement;
    }

    private static final class OpenMessageDialogCommand
    extends AbstractTransactionalCommand {
        private final String dialogTitle;
        private final String message;
        private final int dialogType;

        public OpenMessageDialogCommand(TransactionalEditingDomain domain, String dialogTitle, String message, int dialogType) {
            super(domain, null, null);
            this.message = message;
            this.dialogTitle = dialogTitle;
            this.dialogType = dialogType;
            switch (this.dialogType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    Assert.isLegal((boolean)false, (String)NLS.bind((String)"The value {0} is not supported as iconType by this dialog", (Object)this.dialogType));
                }
            }
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Shell shell = Display.getDefault().getActiveShell();
            switch (this.dialogType) {
                case 0: {
                    break;
                }
                case 1: {
                    MessageDialog.openError((Shell)shell, (String)this.dialogTitle, (String)this.message);
                    return CommandResult.newErrorCommandResult((String)this.message);
                }
                case 2: {
                    MessageDialog.openInformation((Shell)shell, (String)this.dialogTitle, (String)this.message);
                    return CommandResult.newOKCommandResult();
                }
                case 3: {
                    boolean res = MessageDialog.openQuestion((Shell)shell, (String)this.dialogTitle, (String)this.message);
                    return CommandResult.newOKCommandResult((Object)res);
                }
                case 4: {
                    MessageDialog.openWarning((Shell)shell, (String)this.dialogTitle, (String)this.message);
                    return CommandResult.newOKCommandResult();
                }
                case 5: {
                    boolean res = MessageDialog.openConfirm((Shell)shell, (String)this.dialogTitle, (String)this.message);
                    if (res) {
                        return CommandResult.newOKCommandResult();
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            }
            return new CommandResult(Status.OK_STATUS);
        }
    }
}

