/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ForestRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.AbsoluteBendpointsConvention;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.editparts.OverridableConnectionNodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies.LinksLFConnectionBendpointEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies.LinksLFConnectionEndPointEditPolicy;

public abstract class LinkLFConnectionNodeEditPart
extends OverridableConnectionNodeEditPart {
    private boolean myLinkLFEnabled;
    private EditPolicy myOriginalEndPointsEditPolicy;

    public LinkLFConnectionNodeEditPart(View view) {
        super(view);
    }

    public void setLinkLFEnabled(boolean enabled) {
        if (enabled != this.myLinkLFEnabled) {
            this.myLinkLFEnabled = enabled;
            this.refreshRouterChange();
            this.refreshEndPointsEditPolicy();
        }
    }

    protected void refreshEndPointsEditPolicy() {
        if (this.myOriginalEndPointsEditPolicy == null) {
            this.myOriginalEndPointsEditPolicy = this.getEditPolicy("Connection Endpoint Policy");
        }
        EditPolicy endPoints = this.myLinkLFEnabled ? this.createEndPointsEditPolicy() : this.myOriginalEndPointsEditPolicy;
        this.installEditPolicy("Connection Endpoint Policy", endPoints);
    }

    protected EditPolicy createEndPointsEditPolicy() {
        return new LinksLFConnectionEndPointEditPolicy();
    }

    protected void refreshBendpoints() {
        if (!this.myLinkLFEnabled) {
            super.refreshBendpoints();
            return;
        }
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.getEdge().getBendpoints();
        List modelConstraint = bendpoints.getPoints();
        ArrayList<Bendpoint> figureConstraint = new ArrayList<Bendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            RelativeBendpoint wbp = (RelativeBendpoint)modelConstraint.get(i);
            float weight = modelConstraint.size() == 1 ? 0.5f : (float)i / ((float)modelConstraint.size() - 1.0f);
            Bendpoint bp = AbsoluteBendpointsConvention.getInstance().d2dBendpoint(wbp, this.getConnectionFigure(), weight);
            figureConstraint.add(bp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    @Override
    protected final void installBendpointEditPolicy() {
        if (!this.myLinkLFEnabled) {
            super.installBendpointEditPolicy();
            return;
        }
        if (this.getConnectionFigure().getConnectionRouter() instanceof ForestRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new LinksLFConnectionBendpointEditPolicy(LineMode.ORTHOGONAL_CONSTRAINED));
        } else if (this.getConnectionFigure().getConnectionRouter() instanceof OrthogonalRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new LinksLFConnectionBendpointEditPolicy(LineMode.ORTHOGONAL_FREE));
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new LinksLFConnectionBendpointEditPolicy(LineMode.OBLIQUE));
        }
        this.refreshConnectionCursor();
    }
}

