/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.swt.widgets.Composite;

class WelcomeTab
implements Comparable<WelcomeTab> {
    private String id;
    private Set<String> allTabIDs;
    private String label;
    private Set<Tab> tabs = new HashSet<Tab>();
    private final List<Section> sections;
    private final Map<Section, View> views;
    private int priority;

    WelcomeTab(Tab tab) {
        this.id = tab.getId();
        this.allTabIDs = new LinkedHashSet<String>(Collections.singleton(tab.getId()));
        this.label = tab.getLabel();
        this.sections = new ArrayList<Section>((Collection<Section>)tab.getSections());
        this.views = new HashMap<Section, View>();
        this.priority = tab.getPriority();
        this.tabs.add(tab);
    }

    public String getID() {
        return this.id;
    }

    public Set<String> getAllTabIDs() {
        return this.allTabIDs;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    void filterSections(Set<View> views) {
        Iterator<Section> iter = this.sections.iterator();
        while (iter.hasNext()) {
            Section section = iter.next();
            Optional<View> view = views.stream().filter(v -> v.getSections().contains((Object)section)).findFirst();
            if (view.isPresent()) {
                this.views.put(section, view.get());
                continue;
            }
            iter.remove();
        }
    }

    View getView(Section section) {
        return this.views.get(section);
    }

    @Override
    public int compareTo(WelcomeTab o) {
        int result;
        int n = o.precedes(this) ? 1 : (result = this.precedes(o) ? -1 : 0);
        if (result == 0) {
            result = o.priority - this.priority;
        }
        return result;
    }

    boolean precedes(WelcomeTab other) {
        long myAntecedents;
        long otherAntecedents = other.tabs.stream().filter(tab -> this.tabs.contains(tab.getAfterTab())).count();
        return otherAntecedents > (myAntecedents = this.tabs.stream().filter(tab -> welcomeTab.tabs.contains(tab.getAfterTab())).count());
    }

    void merge(Tab tab) {
        if (this.tabs.add(tab)) {
            this.allTabIDs.add(tab.getId());
            if (tab.getPriority() > this.priority) {
                this.priority = tab.getPriority();
                this.id = tab.getId();
                this.sections.addAll(0, (Collection<Section>)tab.getSections());
            } else {
                this.sections.addAll((Collection<Section>)tab.getSections());
            }
        }
    }

    void register(Composite composite, Map<? super Tab, ? super Composite> tabControls) {
        this.tabs.forEach(tab -> {
            Composite composite2 = tabControls.put((Tab)tab, (Composite)composite);
        });
    }
}

