/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.labels;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.labels.AbstractLabelGenerator;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;

public final class EObjectLabelGenerator
extends AbstractLabelGenerator<EObject> {
    public static void initialize(@NonNull ILabelGenerator.Registry registry) {
        registry.install(EObject.class, new EObjectLabelGenerator());
    }

    public EObjectLabelGenerator() {
        super(EObject.class);
    }

    @Override
    public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull EObject object) {
        EClass eClass;
        EAttribute eidAttribute;
        if (object.eIsProxy()) {
            labelBuilder.appendObject(EcoreUtil.getURI((EObject)object));
            return;
        }
        if (!labelBuilder.hasOption(ILabelGenerator.Builder.SHOW_QUALIFIER) && object.eContainer() != null) {
            labelBuilder.appendObject(object.eContainer());
            labelBuilder.appendString("/");
        }
        if ((eidAttribute = (eClass = object.eClass()).getEIDAttribute()) != null) {
            labelBuilder.appendString(String.valueOf(object.eGet((EStructuralFeature)eidAttribute)));
            return;
        }
        labelBuilder.appendString(eClass.getName());
    }
}

