/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.emf.appearance.style.AnnotationStyleProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.ThemeInitializerManager;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class PreferenceInitializerForElementHelper {
    public static boolean usePreferenceInitializer(View view) {
        return ThemeInitializerManager.instance.usePreferenceInitializer(view);
    }

    public static String getpreferenceKey(View view, String elementName, int pref) {
        return PreferencesConstantsHelper.getElementConstant((String)(String.valueOf(view.getDiagram().getType()) + "_" + elementName), (int)pref);
    }

    public static void initBackgroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        EditingDomain domain;
        if (!PreferenceInitializerForElementHelper.usePreferenceInitializer(view)) {
            return;
        }
        String fillColorConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 0);
        String gradientColorConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 4);
        String gradientPolicyConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 5);
        String shadowConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 13);
        String elementIcon = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 14);
        String qualifiedName = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 15);
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fillColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
        fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        if (store.getBoolean(gradientPolicyConstant)) {
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(gradientColorConstant));
            fillStyle.setGradient(gradientPreferenceConverter.getGradientData());
            fillStyle.setTransparency(gradientPreferenceConverter.getTransparency());
        }
        if ((domain = EMFHelper.resolveEditingDomain((EObject)view)) instanceof TransactionalEditingDomain) {
            RecordingCommand qualifiedNameCommand;
            RecordingCommand namelabelIconCommand;
            TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)domain;
            RecordingCommand shadowcommand = AnnotationStyleProvider.getSetShadowCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (boolean)store.getBoolean(shadowConstant));
            if (shadowcommand.canExecute()) {
                shadowcommand.execute();
            }
            if ((namelabelIconCommand = AnnotationStyleProvider.getSetElementIconCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (boolean)store.getBoolean(elementIcon))).canExecute()) {
                namelabelIconCommand.execute();
            }
            if (!store.getBoolean(qualifiedName) && (qualifiedNameCommand = AnnotationStyleProvider.getSetQualifiedNameDepthCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (int)1000)).canExecute()) {
                qualifiedNameCommand.execute();
            }
        }
    }

    public static void initFontStyleFromPrefs(View view, IPreferenceStore store, String elementName) {
        if (!PreferenceInitializerForElementHelper.usePreferenceInitializer(view)) {
            return;
        }
        String fontConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 1);
        String fontColorConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 2);
        FontStyle viewFontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (viewFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontConstant);
            viewFontStyle.setFontName(fontData.getName());
            viewFontStyle.setFontHeight(fontData.getHeight());
            viewFontStyle.setBold((fontData.getStyle() & 1) != 0);
            viewFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fontColorConstant);
            viewFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    public static void initForegroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        if (!PreferenceInitializerForElementHelper.usePreferenceInitializer(view)) {
            return;
        }
        String lineColorConstant = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 3);
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)lineColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
    }

    @Deprecated
    public static void initRountingFromPrefs(View view, IPreferenceStore store, String elementName) {
        if (!PreferenceInitializerForElementHelper.usePreferenceInitializer(view)) {
            return;
        }
        PreferenceInitializerForElementHelper.initRoutingFromPrefs(view, store, elementName);
    }

    public static void initRoutingFromPrefs(View view, IPreferenceStore store, String elementName) {
        if (!PreferenceInitializerForElementHelper.usePreferenceInitializer(view)) {
            return;
        }
        Routing routing = Routing.get((int)store.getInt(PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 11)));
        if (routing != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing(), (Object)routing);
        }
        Smoothness smoothness = Smoothness.get((int)store.getInt(PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 12)));
        if (routing != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Smoothness(), (Object)smoothness);
        }
        JumpLinkStatus jumpLinkStatus = JumpLinkStatus.get((String)PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 6));
        if (routing != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkStatus(), (Object)jumpLinkStatus);
        }
        JumpLinkType jumpLinkType = JumpLinkType.get((String)PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 8));
        if (routing != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkType(), (Object)jumpLinkType);
        }
        boolean jumpLinksReverse = store.getBoolean(PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 7));
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinksReverse(), (Object)jumpLinksReverse);
        boolean routingObstruction = store.getBoolean(PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 10));
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_AvoidObstructions(), (Object)routingObstruction);
        boolean routingDistance = store.getBoolean(PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 9));
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_ClosestDistance(), (Object)routingDistance);
    }

    public static void initCompartmentsStatusFromPrefs(View view, IPreferenceStore store, String elementName) {
        if (!ThemeInitializerManager.instance.usePreferenceInitializer(view)) {
            return;
        }
        EList children = view.getPersistedChildren();
        if (children != null) {
            for (Object object : children) {
                String compartmentName;
                IGraphicalEditPart dummyEP = EditPartService.getInstance().createGraphicEditPart((View)object);
                IGraphicalEditPart epp = dummyEP;
                IFigure fig1 = epp.getFigure();
                if (fig1 instanceof ResizableCompartmentFigure && (compartmentName = ((ResizableCompartmentFigure)fig1).getCompartmentTitle()) != null) {
                    String diagramKind = view.getDiagram().getType();
                    String preferenceKey = PreferencesConstantsHelper.getCompartmentElementConstant((String)(String.valueOf(diagramKind) + "_" + elementName), (String)compartmentName, (int)18);
                    boolean value = store.getBoolean(preferenceKey);
                    if (!value) {
                        ENamedElement namedElement = PackageUtil.getElement((String)"notation.View.visible");
                        ViewUtil.setStructuralFeatureValue((View)((View)object), (EStructuralFeature)((EStructuralFeature)namedElement), (Object)value);
                    }
                    String compartmentNameVisibilityPreference = PreferencesConstantsHelper.getCompartmentElementConstant((String)(String.valueOf(diagramKind) + "_" + elementName), (String)compartmentName, (int)19);
                    boolean showCompartmentName = store.getBoolean(compartmentNameVisibilityPreference);
                    View childView = (View)object;
                    TitleStyle style = (TitleStyle)childView.getStyle(NotationPackage.eINSTANCE.getTitleStyle());
                    if (style != null) {
                        style.setShowTitle(showCompartmentName);
                    }
                }
                dummyEP = null;
            }
        }
    }

    public static void initLabelVisibilityFromPrefs(View view, IPreferenceStore store, String elementName) {
        if (!ThemeInitializerManager.instance.usePreferenceInitializer(view)) {
            return;
        }
        EList children = view.getPersistedChildren();
        if (children != null) {
            for (Object object : children) {
                IGraphicalEditPart dummyEP = EditPartService.getInstance().createGraphicEditPart((View)object);
                if (dummyEP instanceof ILabelRoleProvider) {
                    String role = ((ILabelRoleProvider)dummyEP).getLabelRole();
                    String diagramKind = view.getDiagram().getType();
                    String key = PreferencesConstantsHelper.getLabelElementConstant((String)(String.valueOf(diagramKind) + "_" + elementName), (String)role, (int)20);
                    ((View)object).setVisible(store.getBoolean(key));
                }
                dummyEP = null;
            }
        }
    }

    public static Dimension getDimensionFromPref(View view, IPreferenceStore store, String elementName) {
        Dimension dim = new Dimension();
        String width = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 17);
        String height = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 16);
        dim = new Dimension(store.getInt(width), store.getInt(height));
        return dim;
    }

    public static void initLabelLocationFromPrefs(View view, IPreferenceStore store, String elementName) {
        assert (view instanceof Node);
        Node label = (Node)view;
        Location location = (Location)label.getLayoutConstraint();
        String xKey = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 21);
        String yKey = PreferenceInitializerForElementHelper.getpreferenceKey(view, elementName, 22);
        location.setX(store.getInt(xKey));
        location.setY(store.getInt(yKey));
        label.setLayoutConstraint((LayoutConstraint)location);
    }
}

