/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElementFactory;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;

public class MessageStyleElementFactory
extends AbstractModelElementFactory<MessageStyleModelElement> {
    protected MessageStyleModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        View view = NotationHelper.findView((Object)sourceElement);
        if (view != null && view instanceof Edge) {
            return new MessageStyleModelElement((Edge)view, context);
        }
        return null;
    }

    protected void updateModelElement(MessageStyleModelElement modelElement, Object newSourceElement) {
        View view = NotationHelper.findView((Object)newSourceElement);
        if (!(view instanceof Edge)) {
            throw new IllegalArgumentException("Cannot resolve Edge selection: " + newSourceElement);
        }
        modelElement.source = (Edge)view;
    }

    static class MessageStyleModelElement
    extends AbstractModelElement {
        protected DataContextElement context;
        protected Edge source;

        public MessageStyleModelElement(Edge source, DataContextElement context) {
            this.context = context;
            this.source = source;
        }

        protected IObservable doGetObservable(String propertyPath) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.source);
            Style style = null;
            if (this.context.getName().equals("LineStyle")) {
                style = this.source.getStyle(NotationPackage.Literals.LINE_STYLE);
            } else if (this.context.getName().equals("FontStyle")) {
                style = this.source.getStyle(NotationPackage.Literals.FONT_STYLE);
            }
            if (style != null) {
                EStructuralFeature feature = style.eClass().getEStructuralFeature(propertyPath);
                return new PapyrusObservableValue((EObject)style, feature, domain);
            }
            return null;
        }
    }
}

