/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TypeId;

public class TemplateParameterIdImpl
implements TemplateParameterId {
    private final int index;
    private final @NonNull String name;
    private final int hashCode;

    public TemplateParameterIdImpl(@NonNull IdManager idManager, int index) {
        this.index = index;
        this.name = "$" + Integer.toString(index);
        this.hashCode = IdHash.createGlobalHash(TemplateParameterId.class, this.name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTemplateParameterId(this);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        if (!(that instanceof TemplateParameterId)) {
            return false;
        }
        if (this.index != ((TemplateParameterId)that).getIndex()) {
            return false;
        }
        assert (false);
        return true;
    }

    @Override
    public @NonNull String getDisplayName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public @Nullable String getLiteralName() {
        if (this == TypeId.T_1) {
            return "T_1";
        }
        if (this == TypeId.T_2) {
            return "T_2";
        }
        if (this == TypeId.T_3) {
            return "T_3";
        }
        return null;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull OperationId getOperationId(int templateParameters, @NonNull String name, @NonNull ParametersId parametersId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull PropertyId getPropertyId(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull TemplateParameterId getTemplateParameterId(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTemplateParameters() {
        throw new UnsupportedOperationException();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public @NonNull ElementId specialize(@NonNull BindingsId templateBindings) {
        ElementId elementId = (ElementId)templateBindings.get(this.index);
        assert (elementId != null);
        return elementId;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

