/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.gmf.command.CheckedOperationHistory;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.paste.IValueSetter;
import org.eclipse.papyrus.infra.nattable.paste.PastePostActionRegistry;
import org.eclipse.papyrus.infra.nattable.provider.PasteNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteModeEnumeration;
import org.eclipse.papyrus.infra.nattable.utils.TableClipboardUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.ui.progress.UIJob;

@Deprecated
public class PasteEObjectAxisInTableCommandProvider
implements PasteNattableCommandProvider {
    private static final int MIN_AXIS_FOR_PROGRESS_MONITOR = 5;
    private EStructuralFeature containmentFeature;
    private IElementType typeToCreate;
    private INattableModelManager tableManager;
    private PasteModeEnumeration pasteMode;
    private boolean detachedMode;
    private List<String> postActions;
    private final Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters;
    private static final String PASTE_ACTION_TASK_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteAction;
    private static final String PASTE_ROWS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteRows;
    private static final String PASTE_COLUMNS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteColumns;
    private static final String PASTE_COMMAND_HAS_BEEN_CANCELLED = Messages.PasteEObjectAxisInTableCommandProvider_CommandCreationHasBeenCancelled;
    private static final String PASTE_COMMAND_CANT_BE_EXECUTED = "The Paste command can't be executed";
    private static final String PASTE_COMMAND_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteFromStringCommand;
    private static final String CREATING_ELEMENT_A_NUMBER_X_Y = Messages.PasteEObjectAxisInTableCommandProvider_CreatingAnumberXonY;

    public PasteEObjectAxisInTableCommandProvider(INattableModelManager tableManager, PasteModeEnumeration pasteMode) {
        this.tableManager = tableManager;
        this.pasteMode = pasteMode;
        this.existingConverters = new HashMap<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter>();
        this.init();
    }

    private void init() {
        if (this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_ROW_OR_COLUMN) {
            this.pasteMode = this.askWhichPasteModeDo();
        }
        Assert.isTrue((this.pasteMode != PasteModeEnumeration.CANT_PASTE ? 1 : 0) != 0, (String)"The paste can't be done");
        PasteEObjectConfiguration configuration = null;
        switch (this.pasteMode) {
            case PASTE_EOBJECT_COLUMN: {
                configuration = (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), true);
                break;
            }
            case PASTE_EOBJECT_ROW: {
                configuration = (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
                break;
            }
        }
        if (configuration != null) {
            this.containmentFeature = configuration.getPasteElementContainementFeature();
            this.typeToCreate = ElementTypeRegistry.getInstance().getType(configuration.getPastedElementId());
            this.postActions = configuration.getPostActions();
            this.detachedMode = configuration.isDetachedMode();
        }
    }

    @Override
    public IStatus executePasteFromStringCommand(boolean useProgressMonitor, boolean openDialog) {
        IStatus resultStatus = Status.OK_STATUS;
        String pasteJobName = this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_COLUMN ? PASTE_COLUMNS_JOB_NAME : PASTE_ROWS_JOB_NAME;
        if (this.detachedMode) {
            this.executePasteFromStringCommandInDetachedMode(useProgressMonitor, pasteJobName);
        } else {
            this.executePasteFromStringCommandInAttachedMode(useProgressMonitor, pasteJobName);
        }
        return resultStatus;
    }

    protected void executePasteFromStringCommandInDetachedMode(boolean useProgressMonitor, String pasteJobName) {
        Table table = this.tableManager.getTable();
        final TransactionalEditingDomain tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(table);
        final TransactionalEditingDomain contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(table);
        final HashMap<Object, Object> sharedMap = new HashMap<Object, Object>();
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromFromStringCommandInDetachedMode(contextEditingDomain, tableEditingDomain, (IProgressMonitor)new NullProgressMonitor(), sharedMap);
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
            sharedMap.clear();
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommand pasteCommand = PasteEObjectAxisInTableCommandProvider.this.getPasteFromFromStringCommandInDetachedMode(contextEditingDomain, tableEditingDomain, monitor, sharedMap);
                    if (pasteCommand == null) {
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            try {
                                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                            }
                            catch (ExecutionException e) {
                                Status status = new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                                sharedMap.clear();
                                return status;
                            }
                        }
                        finally {
                            sharedMap.clear();
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    sharedMap.clear();
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", PasteEObjectAxisInTableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected void executePasteFromStringCommandInAttachedMode(boolean useProgressMonitor, String pasteJobName) {
        Table table = this.tableManager.getTable();
        final TransactionalEditingDomain tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(table);
        final TransactionalEditingDomain contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(table);
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromFromStringCommand(contextEditingDomain, tableEditingDomain, (IProgressMonitor)new NullProgressMonitor());
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommand pasteCommand = PasteEObjectAxisInTableCommandProvider.this.getPasteFromFromStringCommand(contextEditingDomain, tableEditingDomain, monitor);
                    if (pasteCommand == null) {
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                        }
                        catch (ExecutionException e) {
                            return new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", PasteEObjectAxisInTableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected ICommand getPasteFromFromStringCommandInDetachedMode(final TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap) {
        List<Object> secondAxis;
        String[] axisToPaste;
        final Table table = this.tableManager.getTable();
        final EObject tableContext = table.getContext();
        switch (this.pasteMode) {
            case PASTE_EOBJECT_COLUMN: {
                axisToPaste = TableClipboardUtils.getColumnsFromClipboard();
                secondAxis = this.tableManager.getRowElementsList();
                break;
            }
            case PASTE_EOBJECT_ROW: {
                axisToPaste = TableClipboardUtils.getRowsFromClipboard();
                secondAxis = this.tableManager.getColumnElementsList();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int nbActions = axisToPaste.length;
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, nbActions + 1);
        }
        final ArrayList<EObject> createdElements = new ArrayList<EObject>();
        EClass eClassToCreate = this.typeToCreate.getEClass();
        EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
        sharedMap.put("pastedElementContainer", tableContext);
        sharedMap.put("referencesToSet", new ArrayList());
        sharedMap.put("cellsToAdd", new ArrayList());
        int index = 1;
        int moduloForRefresh = 1;
        if (axisToPaste.length > 1000) {
            moduloForRefresh = 100;
        } else if (axisToPaste.length > 100) {
            moduloForRefresh = 10;
        }
        String[] stringArray = axisToPaste;
        int n = axisToPaste.length;
        int n2 = 0;
        while (n2 < n) {
            String currentAxisAsString = stringArray[n2];
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            if (progressMonitor != null && index % moduloForRefresh == 0) {
                progressMonitor.subTask(NLS.bind((String)CREATING_ELEMENT_A_NUMBER_X_Y, (Object[])new Object[]{this.typeToCreate.getEClass().getName(), index, axisToPaste.length + 1}));
            }
            ++index;
            String[] cells = TableClipboardUtils.getCells(currentAxisAsString);
            EObject createdElement = eFactory.create(eClassToCreate);
            createdElements.add(createdElement);
            for (String currentPostActions : this.postActions) {
                PastePostActionRegistry.INSTANCE.doPostAction(this.tableManager, currentPostActions, tableContext, createdElement, sharedMap, currentAxisAsString);
            }
            int i = 0;
            while (i < secondAxis.size()) {
                Object rowObject;
                Object columnObject;
                Object currentAxis = secondAxis.get(i);
                String valueAsString = cells[i];
                if (this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_COLUMN) {
                    columnObject = createdElement;
                    rowObject = currentAxis;
                } else {
                    columnObject = currentAxis;
                    rowObject = createdElement;
                }
                boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, sharedMap, this.tableManager);
                if (isEditable) {
                    AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, this.existingConverters, ",", this.tableManager);
                    CellManagerFactory.INSTANCE.setStringValue(columnObject, rowObject, valueAsString, converter, sharedMap, this.tableManager);
                }
                ++i;
            }
            if (progressMonitor != null && index % moduloForRefresh == 0) {
                progressMonitor.worked(moduloForRefresh);
            }
            ++n2;
        }
        AbstractTransactionalCommand pasteCommand = new AbstractTransactionalCommand(tableEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Collection postActions = PasteEObjectAxisInTableCommandProvider.this.getPostActions();
                List cells = (List)sharedMap.get("cellsToAdd");
                List valueToSet = (List)sharedMap.get("referencesToSet");
                int nbTasks = 1;
                ++nbTasks;
                nbTasks += postActions.size();
                ++nbTasks;
                nbTasks += valueToSet.size();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.beginTask(Messages.PasteEObjectAxisInTableCommandProvider_FinishingThePaste, nbTasks);
                }
                AddCommand.create((EditingDomain)contextEditingDomain, (Object)tableContext, (Object)PasteEObjectAxisInTableCommandProvider.this.containmentFeature, (Collection)createdElements).execute();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_AddingElementToTheTable);
                }
                Command cmd = null;
                cmd = PasteEObjectAxisInTableCommandProvider.this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_COLUMN ? PasteEObjectAxisInTableCommandProvider.this.tableManager.getAddColumnElementCommand(createdElements) : PasteEObjectAxisInTableCommandProvider.this.tableManager.getAddRowElementCommand(createdElements);
                if (cmd != null) {
                    cmd.execute();
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_DoingAdditionalActions);
                }
                for (String currentPostActions : postActions) {
                    PastePostActionRegistry.INSTANCE.concludePostAction(PasteEObjectAxisInTableCommandProvider.this.tableManager, currentPostActions, sharedMap);
                    progressMonitor.worked(1);
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_LinkingReferencesToTheModel);
                }
                if (valueToSet.size() > 0) {
                    for (IValueSetter current : valueToSet) {
                        current.doSetValue((EditingDomain)contextEditingDomain);
                        if (progressMonitor == null) continue;
                        if (progressMonitor.isCanceled()) {
                            return CommandResult.newCancelledCommandResult();
                        }
                        progressMonitor.worked(1);
                    }
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                }
                AddCommand.create((EditingDomain)tableEditingDomain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Cells(), (Collection)cells).execute();
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                PasteEObjectAxisInTableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteCommand;
    }

    protected ICommand getPasteFromFromStringCommand(final TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor) {
        List<Object> secondAxis;
        String[] axisToPaste;
        Table table = this.tableManager.getTable();
        EObject tableContext = table.getContext();
        switch (this.pasteMode) {
            case PASTE_EOBJECT_COLUMN: {
                axisToPaste = TableClipboardUtils.getColumnsFromClipboard();
                secondAxis = this.tableManager.getRowElementsList();
                break;
            }
            case PASTE_EOBJECT_ROW: {
                axisToPaste = TableClipboardUtils.getRowsFromClipboard();
                secondAxis = this.tableManager.getColumnElementsList();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int nbActions = axisToPaste.length;
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, nbActions);
        }
        final CreateElementRequest createRequest = new CreateElementRequest(contextEditingDomain, table.getContext(), this.typeToCreate, (EReference)this.containmentFeature);
        final IElementEditService tableContextCommandProvider = ElementEditServiceUtils.getCommandProvider((EObject)tableContext);
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int moduloForRefresh = 1;
                if (axisToPaste.length > 1000) {
                    moduloForRefresh = 100;
                } else if (axisToPaste.length > 100) {
                    moduloForRefresh = 10;
                }
                int i = 0;
                while (i < axisToPaste.length) {
                    ICommand commandCreation;
                    String currentAxisAsString = axisToPaste[i];
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectAxisInTableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    if (progressMonitor != null && i % moduloForRefresh == 0) {
                        progressMonitor.subTask(NLS.bind((String)CREATING_ELEMENT_A_NUMBER_X_Y, (Object[])new Object[]{PasteEObjectAxisInTableCommandProvider.this.typeToCreate.getDisplayName(), i, axisToPaste.length}));
                    }
                    if ((commandCreation = tableContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest)).canExecute()) {
                        commandCreation.execute(monitor, info);
                        CommandResult res = commandCreation.getCommandResult();
                        commandCreation.dispose();
                        Object createdElement = res.getReturnValue();
                        Command addCommand = PasteEObjectAxisInTableCommandProvider.this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_COLUMN ? PasteEObjectAxisInTableCommandProvider.this.tableManager.getAddColumnElementCommand(Collections.singleton(createdElement)) : PasteEObjectAxisInTableCommandProvider.this.tableManager.getAddRowElementCommand(Collections.singleton(createdElement));
                        if (addCommand != null) {
                            addCommand.execute();
                            addCommand.dispose();
                        }
                        String[] cells = TableClipboardUtils.getCells(currentAxisAsString);
                        int j = 0;
                        while (j < secondAxis.size()) {
                            AbstractStringValueConverter converter;
                            Command setValueCommand;
                            Object rowObject;
                            Object columnObject;
                            Object currentAxis = secondAxis.get(j);
                            String valueAsString = cells[j];
                            if (PasteEObjectAxisInTableCommandProvider.this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_COLUMN) {
                                columnObject = createdElement;
                                rowObject = currentAxis;
                            } else {
                                columnObject = currentAxis;
                                rowObject = createdElement;
                            }
                            boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, PasteEObjectAxisInTableCommandProvider.this.tableManager);
                            if (isEditable && (setValueCommand = CellManagerFactory.INSTANCE.getSetStringValueCommand(contextEditingDomain, columnObject, rowObject, valueAsString, converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, PasteEObjectAxisInTableCommandProvider.this.existingConverters, ",", PasteEObjectAxisInTableCommandProvider.this.tableManager), PasteEObjectAxisInTableCommandProvider.this.tableManager)) != null && setValueCommand.canExecute()) {
                                setValueCommand.execute();
                                setValueCommand.dispose();
                            }
                            ++j;
                        }
                        if (progressMonitor != null && i % moduloForRefresh == 0) {
                            progressMonitor.worked(moduloForRefresh);
                        }
                    }
                    ++i;
                }
                progressMonitor.done();
                PasteEObjectAxisInTableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteAllCommand;
    }

    private Boolean mustInitializeName() {
        List<Object> existingColumns = this.pasteMode == PasteModeEnumeration.PASTE_EOBJECT_COLUMN ? this.tableManager.getRowElementsList() : this.tableManager.getColumnElementsList();
        for (Object object : existingColumns) {
            Object current = AxisUtils.getRepresentedElement(object);
            if (!(current instanceof EAttribute) || !((EAttribute)current).getName().equals("name")) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected PasteModeEnumeration askWhichPasteModeDo() {
        throw new UnsupportedOperationException();
    }

    private Collection<String> getPostActions() {
        return this.postActions;
    }

    private void localDispose() {
        this.tableManager = null;
        this.typeToCreate = null;
        this.containmentFeature = null;
        for (AbstractStringValueConverter current : this.existingConverters.values()) {
            current.dispose();
        }
        this.existingConverters.clear();
    }
}

