/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;

public class QvtCompilerFacade {
    private QvtCompilerFacade() {
    }

    public static CompilationResult getCompiledModule(URI uriTransf, QvtCompilerOptions compilerOptions, IProgressMonitor monitor) throws MdaException {
        IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)uriTransf);
        return QvtCompilerFacade.getCompiledModule(ifile, compilerOptions, monitor);
    }

    static CompilationResult getCompiledModule(IFile ifile, QvtCompilerOptions compilerOptions, IProgressMonitor monitor) throws MdaException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            URI resourceURI = URIUtils.getResourceURI((IResource)ifile);
            UnitProxy sourceUnit = UnitResolverFactory.Registry.INSTANCE.getUnit(resourceURI);
            if (sourceUnit == null) {
                throw new MdaException("Failed to resolve compilation unit: " + ifile);
            }
            final QVTOCompiler compiler = new QVTOCompiler();
            final CompiledUnit module = compiler.compile(sourceUnit, compilerOptions, monitor);
            CompilationResult compilationResult = new CompilationResult(){

                public CompiledUnit getCompiledModule() {
                    return module;
                }

                public QVTOCompiler getCompiler() {
                    return compiler;
                }
            };
            return compilationResult;
        }
        finally {
            monitor.done();
        }
    }

    public static interface CompilationResult {
        public QVTOCompiler getCompiler();

        public CompiledUnit getCompiledModule();
    }
}

