/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;

public class RevealResultCommand
extends CommandWrapper {
    private IViewPart viewPart = null;
    private Object sourceObject = null;
    private boolean revealAllResults = false;

    public RevealResultCommand(Command command, IViewPart part, Object editObject) {
        super(command);
        this.viewPart = part;
        this.sourceObject = editObject;
    }

    private void setRevealAllResults(boolean revealAllResults) {
        this.revealAllResults = revealAllResults;
    }

    public static Command wrap(Command command, IViewPart part, EObject container, boolean revealAllResults) {
        RevealResultCommand wrappedCommand = new RevealResultCommand(command, part, container);
        wrappedCommand.setRevealAllResults(revealAllResults);
        return wrappedCommand;
    }

    public static Command wrap(Command command, IViewPart part, EObject container) {
        return new RevealResultCommand(command, part, container);
    }

    public static Command wrap(Command command, IViewPart part) {
        return RevealResultCommand.wrap(command, part, null);
    }

    public void execute() {
        super.execute();
        this.selectResult();
    }

    public void undo() {
        super.undo();
        this.selectSource();
    }

    public void redo() {
        super.redo();
        this.selectResult();
    }

    private void revealTarget(final List<?> target) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RevealResultCommand.this.viewPart instanceof IRevealSemanticElement) {
                    ((IRevealSemanticElement)RevealResultCommand.this.viewPart).revealSemanticElement(target);
                }
            }
        });
    }

    private void selectResult() {
        Collection<?> results = this.getResultsCommand();
        if (!results.isEmpty()) {
            if (this.revealAllResults) {
                this.revealTarget(Arrays.asList(results.toArray()));
            } else {
                Iterator<?> resultIterator = results.iterator();
                Object result = resultIterator.next();
                this.revealTarget(Arrays.asList(result));
            }
        }
    }

    private Collection<?> getResultsCommand() {
        Collection resultsCommand = this.getResult();
        if (this.getResult().isEmpty()) {
            resultsCommand = this.getAffectedObjects();
        }
        return resultsCommand;
    }

    private void selectSource() {
        if (this.sourceObject != null) {
            this.revealTarget(Arrays.asList(this.sourceObject));
        } else if (!this.getAffectedObjects().isEmpty()) {
            this.revealTarget(Arrays.asList(this.getAffectedObjects().toArray()));
        }
    }
}

