/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusModelFactory;
import org.osgi.framework.Bundle;

public class PapyrusModelHelper {
    private static final String MODEL_FACTORY = "modelFactory";
    static List<Segment> segments;

    static {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.onefile", MODEL_FACTORY);
        segments = new ArrayList<Segment>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Segment s = new Segment();
            try {
                s.priority = Integer.parseInt(e.getAttribute("priority"));
                s.bundle = Platform.getBundle((String)e.getContributor().getName());
                s.className = e.getAttribute("instance");
                segments.add(s);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(segments, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                Integer val1 = 0;
                Integer val2 = 0;
                if (o1 != null) {
                    val1 = o1.priority;
                }
                if (o2 != null) {
                    val2 = o2.priority;
                }
                return val1.compareTo(val2);
            }
        });
    }

    public static IPapyrusModelFactory getPapyrusModelFactory() {
        if (segments == null || segments.size() == 0) {
            throw new RuntimeException("Initialisation error, please register extension to org.eclipse.papyrus.infra.onefile.modelFactory");
        }
        return segments.get(segments.size() - 1).getFactory();
    }

    private static class Segment {
        public String className;
        Bundle bundle;
        int priority;
        IPapyrusModelFactory instance = null;

        private Segment() {
        }

        IPapyrusModelFactory getFactory() {
            if (this.instance == null) {
                try {
                    this.instance = (IPapyrusModelFactory)this.bundle.loadClass(this.className).newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return this.instance;
        }
    }
}

