/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.services.validation.commands.AsyncValidateSubtreeCommand;
import org.eclipse.papyrus.uml.xtext.integration.InvalidStringUtil;
import org.eclipse.papyrus.uml.xtext.integration.InvalidSyntaxAdapter;
import org.eclipse.papyrus.uml.xtext.integration.XtextDirectEditManager;
import org.eclipse.papyrus.uml.xtext.integration.XtextFakeResourceContext;
import org.eclipse.papyrus.uml.xtext.integration.XtextStyledTextCellEditorEx;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public abstract class DefaultXtextDirectEditorConfiguration
extends DefaultDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    public static final String ANNOTATION_SOURCE = "expression_source";
    public static final String ANNOTATION_DETAIL = "expression";

    public abstract Injector getInjector();

    protected abstract ICommand getParseCommand(EObject var1, EObject var2);

    public int getStyle() {
        return 4;
    }

    public ContextElementAdapter.IContextElementProvider getContextProvider() {
        return new ContextElementAdapter.IContextElementProvider(){

            public EObject getContextObject() {
                if (DefaultXtextDirectEditorConfiguration.this.objectToEdit instanceof EObject) {
                    return (EObject)DefaultXtextDirectEditorConfiguration.this.objectToEdit;
                }
                return null;
            }
        };
    }

    public DirectEditManager createDirectEditManager(ITextAwareEditPart host) {
        return new XtextDirectEditManager(host, this.getInjector(), this.getStyle(), this);
    }

    public IParser createParser(final EObject semanticObject) {
        if (this.objectToEdit == null) {
            this.objectToEdit = semanticObject;
        }
        return new IParser(){

            public String getEditString(IAdaptable element, int flags) {
                return DefaultXtextDirectEditorConfiguration.this.getTextToEditInternal(semanticObject);
            }

            public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
                CompositeCommand result = new CompositeCommand("validation");
                ContextElementAdapter.IContextElementProvider provider = DefaultXtextDirectEditorConfiguration.this.getContextProvider();
                XtextFakeResourceContext context = new XtextFakeResourceContext(DefaultXtextDirectEditorConfiguration.this.getInjector());
                context.getFakeResource().eAdapters().add((Object)new ContextElementAdapter(provider));
                try {
                    context.getFakeResource().load((InputStream)new StringInputStream(newString), Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
                    ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(context.getFakeResource());
                }
                EcoreUtil2.resolveLazyCrossReferences((Resource)context.getFakeResource(), (CancelIndicator)CancelIndicator.NullImpl);
                if (!context.getFakeResource().getParseResult().hasSyntaxErrors() && context.getFakeResource().getErrors().size() == 0) {
                    EObject xtextObject = context.getFakeResource().getParseResult().getRootASTElement();
                    ICommand cmd = DefaultXtextDirectEditorConfiguration.this.getParseCommand(semanticObject, xtextObject);
                    if (cmd != null) {
                        result.add((IUndoableOperation)cmd);
                    }
                } else {
                    result.add((IUndoableOperation)DefaultXtextDirectEditorConfiguration.this.createInvalidStringCommand(newString, semanticObject));
                }
                AsyncValidateSubtreeCommand validationCommand = new AsyncValidateSubtreeCommand(semanticObject);
                validationCommand.disableUIFeedback();
                result.add((IUndoableOperation)validationCommand);
                return result;
            }

            public String getPrintString(IAdaptable element, int flags) {
                return DefaultXtextDirectEditorConfiguration.this.getTextToEdit(semanticObject);
            }

            public boolean isAffectingEvent(Object event, int flags) {
                return false;
            }

            public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
                return null;
            }

            public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
                return null;
            }
        };
    }

    protected String getTextToEditInternal(EObject semanticObject) {
        String textualRepresentation;
        if (semanticObject instanceof Element && (textualRepresentation = InvalidStringUtil.getTextualRepresentation((Element)semanticObject)) != null) {
            this.registerInvalidStringAdapter(semanticObject);
            return textualRepresentation;
        }
        return this.getTextToEdit(semanticObject);
    }

    protected ICommand createInvalidStringCommand(final String newString, EObject semanticElement) {
        if (semanticElement instanceof Element) {
            this.registerInvalidStringAdapter(semanticElement);
            final Element element = (Element)semanticElement;
            return new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)semanticElement), "", Collections.emptyList()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    String languageName = (String)DefaultXtextDirectEditorConfiguration.this.getInjector().getInstance(Key.get(String.class, (Annotation)Names.named((String)"languageName")));
                    Comment comment = InvalidStringUtil.getTextualRepresentationComment(element);
                    if (comment == null) {
                        comment = InvalidStringUtil.createTextualRepresentationComment(element, languageName);
                    }
                    comment.setBody(newString);
                    return CommandResult.newOKCommandResult();
                }
            };
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected void registerInvalidStringAdapter(EObject semanticElement) {
        Adapter existingAdapter = EcoreUtil.getExistingAdapter((Notifier)semanticElement, InvalidSyntaxAdapter.class);
        if (existingAdapter == null) {
            semanticElement.eAdapters().add((Object)new InvalidSyntaxAdapter());
        }
    }

    public CellEditor createCellEditor(Composite parent, EObject semanticObject) {
        ContextElementAdapter.IContextElementProvider provider = this.getContextProvider();
        XtextStyledTextCellEditorEx cellEditor = new XtextStyledTextCellEditorEx(2050, this.getInjector(), provider){

            protected StyledText createStyledText(Composite parent) {
                StyledText text = super.createStyledText(parent);
                text.addListener(3005, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.character == '\r' && !completionProposalAdapter.isProposalPopupOpen()) {
                            this.focusLost();
                        }
                    }
                });
                return text;
            }
        };
        cellEditor.create(parent);
        return cellEditor;
    }
}

