/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.urischeme.IUriSchemeHandler;
import org.eclipse.urischeme.IUriSchemeProcessor;

public class UriSchemeProcessor
implements IUriSchemeProcessor {
    private static final String PLUGIN_ID = "org.eclipse.urischeme";
    private static final String EXT_POINT_ID_URI_SCHEME_HANDLERS = "org.eclipse.urischeme.uriSchemeHandlers";
    private static final String EXT_POINT_ATTRIBUTE_URI_SCHEME = "uriScheme";
    private static final String EXT_POINT_ATTRIBUTE_CLASS = "class";
    private IConfigurationElement[] configurationElements = null;
    private Map<String, IUriSchemeHandler> createdHandlers = new HashMap<String, IUriSchemeHandler>();

    @Override
    public void handleUri(String uriScheme, String uri) throws CoreException {
        IUriSchemeHandler handler = null;
        if (this.createdHandlers.containsKey(uriScheme)) {
            handler = this.createdHandlers.get(uriScheme);
        } else {
            handler = this.getHandlerFromExtensionPoint(uriScheme);
            this.createdHandlers.put(uriScheme, handler);
        }
        if (handler != null) {
            handler.handle(uri);
        }
    }

    private IUriSchemeHandler getHandlerFromExtensionPoint(String uriScheme) throws CoreException {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = this.getOrReadConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (uriScheme.equals(element.getAttribute(EXT_POINT_ATTRIBUTE_URI_SCHEME))) {
                return this.createExecutableSchemeHandler(element);
            }
            ++n2;
        }
        return null;
    }

    private IConfigurationElement[] getOrReadConfigurationElements() {
        if (this.configurationElements == null) {
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            this.configurationElements = registry.getConfigurationElementsFor(EXT_POINT_ID_URI_SCHEME_HANDLERS);
        }
        return this.configurationElements;
    }

    private IUriSchemeHandler createExecutableSchemeHandler(IConfigurationElement element) throws CoreException {
        Object executableExtension = element.createExecutableExtension(EXT_POINT_ATTRIBUTE_CLASS);
        if (executableExtension instanceof IUriSchemeHandler) {
            return (IUriSchemeHandler)executableExtension;
        }
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Registered class has wrong type: " + executableExtension.getClass()));
    }
}

