/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.util;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.uml.properties.xtext.widget.property.AbstractXtextPropertyEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public abstract class TransactionalXtextEditor
extends AbstractXtextPropertyEditor {
    protected boolean changePending;
    protected ResourceSetListener rsl;

    public TransactionalXtextEditor(String name, Composite parent, int style) {
        super(name, parent, style);
        this.xtextEditor.getTextControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TransactionalXtextEditor.this.rsl != null) {
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)TransactionalXtextEditor.this.elementToEdit);
                    domain.removeResourceSetListener(TransactionalXtextEditor.this.rsl);
                }
            }
        });
    }

    public void handleChange(ChangeEvent event) {
        this.changePending = true;
    }

    protected void doBinding() {
        super.doBinding();
        if (this.rsl == null) {
            this.rsl = new ResourceSetListenerImpl(){

                public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                    if (TransactionalXtextEditor.this.changePending) {
                        if (!TransactionalXtextEditor.this.xtextEditor.getTextControl().isDisposed()) {
                            TransactionalXtextEditor.this.display();
                        }
                        TransactionalXtextEditor.this.changePending = false;
                    }
                    return null;
                }
            };
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.elementToEdit);
            domain.addResourceSetListener(this.rsl);
        }
    }
}

