/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.compdef.ui.contribution;

import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Activity;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Component;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Parameter;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Port;
import org.eclipse.papyrus.robotics.xtext.compdef.ui.contribution.UnparseCompDef;
import org.eclipse.papyrus.robotics.xtext.compdef.ui.internal.CompdefActivator;
import org.eclipse.papyrus.robotics.xtext.util.TrackNames;
import org.eclipse.papyrus.robotics.xtext.util.UpdateContextAdapter;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.TypeRule;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.xtext.integration.AbstractXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.InvalidStringUtil;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class CompDefEditorConfigurationContribution
extends AbstractXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    TrackNames<org.eclipse.uml2.uml.Port> lastPorts;
    TrackNames<Type> lastActivities;
    TrackNames<Property> lastParams;
    StructuredClassifier paramClass;

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof Class) {
            Class umlComponent = (Class)objectToEdit;
            this.lastPorts = new TrackNames(umlComponent.getOwnedPorts());
            BasicEList activities = new BasicEList();
            for (Property attribute : umlComponent.getOwnedAttributes()) {
                Type type = attribute.getType();
                if (type == null || !StereotypeUtil.isApplied((Element)type, org.eclipse.papyrus.robotics.profile.robotics.components.Activity.class)) continue;
                activities.add((Object)type);
            }
            this.lastActivities = new TrackNames((EList)activities);
            this.paramClass = ParameterUtils.getParameterClass((Class)umlComponent);
            BasicEList parameters = new BasicEList();
            if (this.paramClass != null) {
                for (Property attribute : this.paramClass.getAttributes()) {
                    if (attribute.getName() == null) continue;
                    parameters.add((Object)attribute);
                }
            }
            this.lastParams = new TrackNames((EList)parameters);
        }
        return super.preEditAction(objectToEdit);
    }

    public ContextElementAdapter.IContextElementProvider getContextProvider() {
        return new UpdateContextAdapter(this.objectToEdit){

            public void updateLastNames() {
                Component c = (Component)this.xtextResource.getContents().get(0);
                ArrayList<String> portNameList = new ArrayList<String>();
                for (Port port : c.getPorts()) {
                    portNameList.add(port.getName());
                }
                CompDefEditorConfigurationContribution.this.lastPorts.update(portNameList);
                ArrayList<String> activityNameList = new ArrayList<String>();
                for (Activity activity : c.getActivity()) {
                    activityNameList.add(activity.getName());
                }
                CompDefEditorConfigurationContribution.this.lastActivities.update(activityNameList);
                ArrayList<String> paramNameList = new ArrayList<String>();
                for (Parameter parameter : c.getParameters()) {
                    paramNameList.add(parameter.getName());
                }
                CompDefEditorConfigurationContribution.this.lastParams.update(paramNameList);
            }
        };
    }

    public int getStyle() {
        return 66;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Class) {
            Class clazz = (Class)editedObject;
            String invalidStr = InvalidStringUtil.getTextualRepresentation((Element)clazz);
            if (invalidStr != null) {
                return invalidStr;
            }
            return UnparseCompDef.getCompDefText(clazz).toString();
        }
        return "not a component";
    }

    public Injector getInjector() {
        return CompdefActivator.getInstance().getInjector("org.eclipse.papyrus.robotics.xtext.compdef.CompDef");
    }

    public ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        if (!(modelObject instanceof Class)) {
            return null;
        }
        Class clazz = (Class)modelObject;
        Component componentDef = (Component)xtextObject;
        TransactionalEditingDomain dom = TransactionUtil.getEditingDomain((EObject)clazz);
        UpdateComponentCommand updateCommand = new UpdateComponentCommand(dom, clazz, componentDef);
        return updateCommand;
    }

    protected class UpdateComponentCommand
    extends AbstractTransactionalCommand {
        private Class clazz;
        private final Component component;

        public UpdateComponentCommand(TransactionalEditingDomain domain, Class clazz, Component component) {
            super(domain, "Update component", UpdateComponentCommand.getWorkspaceFiles((EObject)clazz));
            this.clazz = clazz;
            this.component = component;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            if (this.component != null) {
                this.clazz.setName(this.component.getName());
                for (Port port : this.component.getPorts()) {
                    NamedElement required;
                    NamedElement provided;
                    String portName = port.getName();
                    org.eclipse.uml2.uml.Port existingPort = (org.eclipse.uml2.uml.Port)CompDefEditorConfigurationContribution.this.lastPorts.get(portName);
                    Type componentSvc = null;
                    if (existingPort != null) {
                        existingPort.setName(portName);
                        componentSvc = existingPort.getType();
                    }
                    if (componentSvc == null) {
                        componentSvc = this.clazz.createNestedClassifier(null, UMLPackage.eINSTANCE.getClass_());
                        StereotypeUtil.apply((Element)componentSvc, ComponentService.class);
                        if (existingPort == null) {
                            existingPort = this.clazz.createOwnedPort(port.getName(), componentSvc);
                            existingPort.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                            StereotypeUtil.apply((Element)existingPort, ComponentPort.class);
                        }
                        existingPort.setType(componentSvc);
                    }
                    if (port.getProv() != null && (provided = ElementUtils.getQualifiedElementFromRS((Element)this.clazz, (String)port.getProv().getType().getQualifiedName())) instanceof Interface) {
                        for (Dependency dep : componentSvc.getClientDependencies()) {
                            dep.destroy();
                        }
                        ((Class)componentSvc).createInterfaceRealization(null, (Interface)provided);
                    }
                    if (port.getReq() == null || (required = ElementUtils.getQualifiedElementFromRS((Element)this.clazz, (String)port.getReq().getType().getQualifiedName())) == null) continue;
                    for (Dependency dep : componentSvc.getClientDependencies()) {
                        dep.destroy();
                    }
                    ((Class)componentSvc).createUsage(required);
                }
                ArrayList activities = new ArrayList();
                activities.addAll(this.clazz.getOwnedAttributes());
                for (Property activity : activities) {
                    Type type = activity.getType();
                    if (type == null || !StereotypeUtil.isApplied((Element)type, org.eclipse.papyrus.robotics.profile.robotics.components.Activity.class) || CompDefEditorConfigurationContribution.this.lastActivities.containsValue((NamedElement)activity.getType())) continue;
                    activity.getType().destroy();
                    activity.destroy();
                }
                for (Activity activityXt : this.component.getActivity()) {
                    String activityName = activityXt.getName().trim();
                    Type activity = (Type)CompDefEditorConfigurationContribution.this.lastActivities.get(activityName);
                    if (activity != null) {
                        activity.setName(activityName);
                        continue;
                    }
                    activity = this.clazz.createNestedClassifier(activityName, UMLPackage.eINSTANCE.getActivity());
                    StereotypeUtil.apply((Element)activity, org.eclipse.papyrus.robotics.profile.robotics.components.Activity.class);
                    Property activityAttr = this.clazz.createOwnedAttribute(activityName.toLowerCase(), activity);
                    StereotypeUtil.apply((Element)activityAttr, ActivityInstance.class);
                }
                ArrayList attributes = new ArrayList();
                attributes.addAll(CompDefEditorConfigurationContribution.this.paramClass.getOwnedAttributes());
                for (Property paramEntry : attributes) {
                    if (CompDefEditorConfigurationContribution.this.lastParams.containsValue((NamedElement)paramEntry)) continue;
                    paramEntry.destroy();
                }
                CompDefEditorConfigurationContribution.this.paramClass.getOwnedAttributes().clear();
                for (Parameter parameter : this.component.getParameters()) {
                    String paramName = parameter.getName().trim();
                    TypeRule typeRule = parameter.getType();
                    Property paramEntry = (Property)CompDefEditorConfigurationContribution.this.lastParams.get(paramName);
                    if (paramEntry != null) {
                        paramEntry.setName(paramName);
                        paramEntry.setType(typeRule != null ? typeRule.getType() : null);
                        CompDefEditorConfigurationContribution.this.paramClass.getOwnedAttributes().add((Object)paramEntry);
                    } else {
                        paramEntry = CompDefEditorConfigurationContribution.this.paramClass.createOwnedAttribute(parameter.getName(), typeRule != null ? typeRule.getType() : null);
                    }
                    ParameterEntry pe = (ParameterEntry)StereotypeUtil.applyApp((Element)paramEntry, ParameterEntry.class);
                    String comment = parameter.getComment();
                    if (pe == null || comment == null) continue;
                    comment = comment.substring(2).trim();
                    pe.setDescription(comment);
                }
            }
            return CommandResult.newOKCommandResult((Object)this.clazz);
        }
    }
}

