/*
 * generated by Xtext 2.29.0
 */
package org.eclipse.papyrus.robotics.xtext.compdef.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Activity;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.CompDefTextPackage;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Component;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Connector;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.ConnectorEnd;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Port;
import org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Value;
import org.eclipse.papyrus.robotics.xtext.compdef.services.CompDefGrammarAccess;
import org.eclipse.papyrus.uml.textedit.common.xtext.serializer.UmlCommonSemanticSequencer;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.QualifiedName;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.TypeRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.UmlCommonPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class CompDefSemanticSequencer extends UmlCommonSemanticSequencer {

	@Inject
	private CompDefGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == CompDefTextPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case CompDefTextPackage.ACTIVITY:
				sequence_Activity(context, (Activity) semanticObject); 
				return; 
			case CompDefTextPackage.COMPONENT:
				sequence_Component(context, (Component) semanticObject); 
				return; 
			case CompDefTextPackage.CONNECTOR:
				sequence_Connector(context, (Connector) semanticObject); 
				return; 
			case CompDefTextPackage.CONNECTOR_END:
				sequence_ConnectorEnd(context, (ConnectorEnd) semanticObject); 
				return; 
			case CompDefTextPackage.PARAMETER:
				sequence_Parameter(context, (org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Parameter) semanticObject); 
				return; 
			case CompDefTextPackage.PORT:
				sequence_Port(context, (Port) semanticObject); 
				return; 
			case CompDefTextPackage.VALUE:
				sequence_Value(context, (Value) semanticObject); 
				return; 
			}
		else if (epackage == UmlCommonPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case UmlCommonPackage.BOUND_SPECIFICATION:
				sequence_BoundSpecification(context, (BoundSpecification) semanticObject); 
				return; 
			case UmlCommonPackage.MULTIPLICITY_RULE:
				sequence_MultiplicityRule(context, (MultiplicityRule) semanticObject); 
				return; 
			case UmlCommonPackage.QUALIFIED_NAME:
				sequence_QualifiedName(context, (QualifiedName) semanticObject); 
				return; 
			case UmlCommonPackage.TYPE_RULE:
				sequence_TypeRule(context, (TypeRule) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     Activity returns Activity
	 *
	 * Constraint:
	 *     name=ID
	 * </pre>
	 */
	protected void sequence_Activity(ISerializationContext context, Activity semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CompDefTextPackage.Literals.ACTIVITY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CompDefTextPackage.Literals.ACTIVITY__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getActivityAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Component returns Component
	 *
	 * Constraint:
	 *     (name=ID ports+=Port* activity+=Activity* parameters+=Parameter*)
	 * </pre>
	 */
	protected void sequence_Component(ISerializationContext context, Component semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ConnectorEnd returns ConnectorEnd
	 *
	 * Constraint:
	 *     port=ID
	 * </pre>
	 */
	protected void sequence_ConnectorEnd(ISerializationContext context, ConnectorEnd semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CompDefTextPackage.Literals.CONNECTOR_END__PORT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CompDefTextPackage.Literals.CONNECTOR_END__PORT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getConnectorEndAccess().getPortIDTerminalRuleCall_0(), semanticObject.getPort());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Connector returns Connector
	 *
	 * Constraint:
	 *     (name=ID end+=ConnectorEnd*)
	 * </pre>
	 */
	protected void sequence_Connector(ISerializationContext context, Connector semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Parameter returns Parameter
	 *
	 * Constraint:
	 *     (name=ID (type=TypeRule | typeUndefined?='&lt;Undefined&gt;')? multiplicity=MultiplicityRule? value=Value? comment=VSL_COMMENT?)
	 * </pre>
	 */
	protected void sequence_Parameter(ISerializationContext context, org.eclipse.papyrus.robotics.xtext.compdef.compDefText.Parameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Port returns Port
	 *
	 * Constraint:
	 *     (name=ID prov=TypeRule? req=TypeRule?)
	 * </pre>
	 */
	protected void sequence_Port(ISerializationContext context, Port semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Value returns Value
	 *
	 * Constraint:
	 *     (str=STRING | ival=INT | dval=DOUBLE)
	 * </pre>
	 */
	protected void sequence_Value(ISerializationContext context, Value semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
