// --------------------------------------------------------
// Copyright (c)
//
// contributions by Ansgar
//                  ansgar.radermacher@cea.fr
// maintained by    CEA LIST
//                  info-list@cea.fr

// --------------------------------------------------------
// Code generated by Papyrus C++
// --------------------------------------------------------

#define intermediate_IntermediateServer_impl_BODY

/************************************************************
 IntermediateServer_impl class body
 ************************************************************/

// include associated header file
#include "intermediate/IntermediateServer_impl.h"

// Derived includes directives
#include "rclcpp/rclcpp.hpp"

using namespace std::chrono_literals;

namespace intermediate {

// static attributes (if any)

/**
 * 
 * @param options 
 */
IntermediateServer_impl::IntermediateServer_impl(
    rclcpp::NodeOptions /*in*/options) :
    IntermediateServer(options) {
}

/**
 * A callback handler for getting request results. This handler is not used by
 * the intermediate server, the result is obtained via polling, see below
 *
 * @param future a future containing the result
 */
void IntermediateServer_impl::fResultCallback(
    rclcpp::Client<simple_msgs::srv::AddServiceDef>::SharedFuture /*in*/future) {
  auto result = future.get();
  RCLCPP_INFO(get_logger(), "result via callback = %d", result->sum);
}

/**
 *
 * @param request 
 * @param response 
 * @return ret 
 */
bool IntermediateServer_impl::addServiceDef_handler(
    const simple_msgs::srv::AddServiceDef::Request::SharedPtr /*in*/request,
    const simple_msgs::srv::AddServiceDef::Response::SharedPtr /*in*/response) {
  RCLCPP_INFO(get_logger(), "doing request");

  // use a call in which the future is polled
  auto result_future = useAdd_client_->async_send_request(request);

  if (result_future.wait_for(std::chrono::seconds(5s))
      != std::future_status::ready) {
    RCLCPP_ERROR(get_logger(),
        "service call failed. This should not happen, since a separate callback group is used for handler and new client call");
  } else {
    response->sum = result_future.get()->sum;
    RCLCPP_INFO(get_logger(), "result via polling = %d", response->sum);
  }
  return true;
}


} // of namespace intermediate

/************************************************************
 End of IntermediateServer_impl class body
 ************************************************************/
