/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.RosPythonTypes;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ParameterTransformations {
    public static boolean declareParameters(Class component) {
        boolean _xblockexpression = false;
        Operation declareParamsOp = component.createOwnedOperation("declareParameters", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior(component.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior declareParamsOb = (OpaqueBehavior)_createOwnedBehavior;
        declareParamsOp.getMethods().add((Object)declareParamsOb);
        declareParamsOb.getLanguages().add((Object)"Python");
        EList _bodies = declareParamsOb.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        List _allParameters = ParameterUtils.getAllParameters((Class)component);
        for (Property parameter : _allParameters) {
            String description = ParameterTransformations.getDescription(parameter);
            _builder.newLineIfNotEmpty();
            String descriptorVar = null;
            _builder.newLineIfNotEmpty();
            if (description != null) {
                String _plus;
                _builder.append("auto ");
                String _varName = StringUtils.varName((String)parameter.getName());
                String _descriptorVar = descriptorVar = (_plus = String.valueOf(_varName) + "_desc");
                _builder.append(_descriptorVar);
                _builder.append(" = rcl_interfaces::msg::ParameterDescriptor();");
                _builder.newLineIfNotEmpty();
                _builder.append(descriptorVar);
                _builder.append(".description = ");
                _builder.append(description);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("self.declare_parameter('");
            String _name = parameter.getName();
            _builder.append(_name);
            _builder.append("', ");
            String _strDefaultValue = ParameterTransformations.strDefaultValue(parameter, descriptorVar != null);
            _builder.append(_strDefaultValue);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public static boolean initParameters(Class component) {
        boolean _xblockexpression = false;
        Operation initParamsOp = component.createOwnedOperation("initParameterVars", null, null);
        Behavior _createOwnedBehavior = component.createOwnedBehavior(component.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior initParamsOb = (OpaqueBehavior)_createOwnedBehavior;
        initParamsOp.getMethods().add((Object)initParamsOb);
        initParamsOb.getLanguages().add((Object)"Python");
        EList _bodies = initParamsOb.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        List _allParameters = ParameterUtils.getAllParameters((Class)component);
        for (Property parameter : _allParameters) {
            _builder.append("self.");
            String _varName = StringUtils.varName((String)parameter.getName());
            _builder.append(_varName);
            _builder.append("_ = self.get_parameter(\"");
            String _name = parameter.getName();
            _builder.append(_name);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public static void moveParameters(Class component) {
        Class paramSet = ParameterUtils.getParameterClass((Class)component);
        if (paramSet != null) {
            Property[] _clone;
            Property[] propertyArray = _clone = (Property[])((Property[])Conversions.unwrapArray((Object)paramSet.getOwnedAttributes(), Property.class)).clone();
            int n = _clone.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _tripleNotEquals;
                Property parameter = propertyArray[n2];
                component.getOwnedAttributes().add((Object)parameter);
                String _varName = StringUtils.varName((String)parameter.getName());
                String _plus = String.valueOf(_varName) + "_";
                parameter.setName(_plus);
                ValueSpecification _defaultValue = parameter.getDefaultValue();
                boolean bl = _tripleNotEquals = _defaultValue != null;
                if (_tripleNotEquals) {
                    parameter.getDefaultValue().destroy();
                }
                ++n2;
            }
            paramSet.destroy();
        }
    }

    public static String strDefaultValue(Property parameter, boolean nonNull) {
        boolean _tripleNotEquals;
        ValueSpecification _defaultValue = parameter.getDefaultValue();
        boolean bl = _tripleNotEquals = _defaultValue != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            String value = parameter.getDefaultValue().stringValue();
            Type _type = parameter.getType();
            boolean bl2 = _tripleNotEquals_1 = _type != null;
            if (_tripleNotEquals_1) {
                String typeName = parameter.getType().getName().toLowerCase().replace("std::", "");
                boolean _equals = Objects.equal((Object)typeName, (Object)"string");
                if (_equals) {
                    value = String.format("std::string(\"%s\")", value);
                    parameter.setType(RosPythonTypes.getType((Element)parameter, "ros2Library::stdlib::string"));
                } else {
                    ValueSpecification _defaultValue_1 = parameter.getDefaultValue();
                    if (_defaultValue_1 instanceof LiteralBoolean) {
                        value = StringExtensions.toFirstUpper((String)value);
                    }
                }
            }
            return String.format("%s", value);
        }
        if (nonNull) {
            return "rclcpp::ParameterValue()";
        }
        return null;
    }

    public static String getDescription(Property umlParameter) {
        String description;
        ParameterEntry parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)umlParameter, ParameterEntry.class);
        if (parameter != null && (description = parameter.getDescription()) != null) {
            return StringUtils.quote((String)description.trim());
        }
        return null;
    }
}

