package org.eclipse.papyrus.robotics.ros2.codegen.python.build;

import java.util.List;
import org.eclipse.papyrus.designer.infra.base.StringConstants;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CreateCompTestAndResource {
  public static CharSequence createTestCopyRight() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# Copyright 2015 Open Source Robotics Foundation, Inc.");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Licensed under the Apache License, Version 2.0 (the \"License\");");
    _builder.newLine();
    _builder.append("# you may not use this file except in compliance with the License.");
    _builder.newLine();
    _builder.append("# You may obtain a copy of the License at");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("#     http://www.apache.org/licenses/LICENSE-2.0");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Unless required by applicable law or agreed to in writing, software");
    _builder.newLine();
    _builder.append("# distributed under the License is distributed on an \"AS IS\" BASIS,");
    _builder.newLine();
    _builder.append("# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
    _builder.newLine();
    _builder.append("# See the License for the specific language governing permissions and");
    _builder.newLine();
    _builder.append("# limitations under the License.");
    _builder.newLine();
    _builder.newLine();
    _builder.append("from ament_copyright.main import main");
    _builder.newLine();
    _builder.append("import pytest");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Remove the `skip` decorator once the source file(s) have a copyright header");
    _builder.newLine();
    _builder.append("@pytest.mark.skip(reason=\'No copyright header has been placed in the generated source file.\')");
    _builder.newLine();
    _builder.append("@pytest.mark.copyright");
    _builder.newLine();
    _builder.append("@pytest.mark.linter");
    _builder.newLine();
    _builder.append("def test_copyright():");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("rc = main(argv=[\'.\', \'test\'])");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("assert rc == 0, \'Found errors\'");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence createTestFlake8() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# Copyright 2017 Open Source Robotics Foundation, Inc.");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Licensed under the Apache License, Version 2.0 (the \"License\");");
    _builder.newLine();
    _builder.append("# you may not use this file except in compliance with the License.");
    _builder.newLine();
    _builder.append("# You may obtain a copy of the License at");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("#     http://www.apache.org/licenses/LICENSE-2.0");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Unless required by applicable law or agreed to in writing, software");
    _builder.newLine();
    _builder.append("# distributed under the License is distributed on an \"AS IS\" BASIS,");
    _builder.newLine();
    _builder.append("# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
    _builder.newLine();
    _builder.append("# See the License for the specific language governing permissions and");
    _builder.newLine();
    _builder.append("# limitations under the License.");
    _builder.newLine();
    _builder.newLine();
    _builder.append("from ament_flake8.main import main_with_errors");
    _builder.newLine();
    _builder.append("import pytest");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("@pytest.mark.flake8");
    _builder.newLine();
    _builder.append("@pytest.mark.linter");
    _builder.newLine();
    _builder.append("def test_flake8():");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("rc, errors = main_with_errors(argv=[])");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("assert rc == 0, \\");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("\'Found %d code style errors / warnings:\\n\' % len(errors) + \\");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("\'\\n\'.join(errors)");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence createTestPep257() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# Copyright 2017 Open Source Robotics Foundation, Inc.");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Licensed under the Apache License, Version 2.0 (the \"License\");");
    _builder.newLine();
    _builder.append("# you may not use this file except in compliance with the License.");
    _builder.newLine();
    _builder.append("# You may obtain a copy of the License at");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("#     http://www.apache.org/licenses/LICENSE-2.0");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Unless required by applicable law or agreed to in writing, software");
    _builder.newLine();
    _builder.append("# distributed under the License is distributed on an \"AS IS\" BASIS,");
    _builder.newLine();
    _builder.append("# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
    _builder.newLine();
    _builder.append("# See the License for the specific language governing permissions and");
    _builder.newLine();
    _builder.append("# limitations under the License.");
    _builder.newLine();
    _builder.newLine();
    _builder.append("from ament_flake8.main import main_with_errors");
    _builder.newLine();
    _builder.append("import pytest");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("@pytest.mark.flake8");
    _builder.newLine();
    _builder.append("@pytest.mark.linter");
    _builder.newLine();
    _builder.append("def test_flake8():");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("rc, errors = main_with_errors(argv=[])");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("assert rc == 0, \\");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("\'Found %d code style errors / warnings:\\n\' % len(errors) + \\");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("\'\\n\'.join(errors)");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public static void generate(final IPFileSystemAccess fileAccess, final org.eclipse.uml2.uml.Package pkg, final List<org.eclipse.uml2.uml.Class> allComponents, final List<org.eclipse.uml2.uml.Class> componentsInPkg) {
    fileAccess.generateFile("test/test_copyright.py", CreateCompTestAndResource.createTestCopyRight().toString());
    fileAccess.generateFile("test/test_flake8.py", CreateCompTestAndResource.createTestFlake8().toString());
    fileAccess.generateFile("test/test_pep257.py", CreateCompTestAndResource.createTestPep257().toString());
    String _pkgName = PackageTools.pkgName(pkg);
    String _plus = ("resource/" + _pkgName);
    fileAccess.generateFile(_plus, StringConstants.EMPTY);
  }
}
